package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;
import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;
import com.google.common.collect.ImmutableSet;

import java.util.Date;

/**
 * 兑吧活动工具
 * 
 * @author houwen
 */
public class DuibaHdtoolDO extends BaseDO {
	private static final long serialVersionUID = -1692595446834739092L;

	public static final int STATUS_NOCOMPLETE = 0; // 数据不完整
	public static final int STATUS_OPEN = 1; // 开启且可见
	public static final int STATUS_CLOSE_SHOW = 2; // 关闭且可见
	public static final int STATUS_CLOSE = 3; // 关闭不可见

	public static final String LimitTypeForever = "forever"; // 永久
	public static final String LimitTypeEveryday = "everyday"; // 每天

	public static final int CreditsTypeNo = 0; // 无积分模式
	public static final int CreditsTypeYes = 1; // 有积分模式
	
	public static final int SWITCHES_DIRECT = 0;//定向发放
	public static final int SWITCHES_DEV_BLACKLIST = 1;//黑名单
	public static final int SWITCHES_FREE_RULE = 2; // 免费次数使用的活动规则
	public static final int SWITCHES_NEW = 3;//判断是否是新添加的活动-与管理员端保持一样用3,新添加活动大奖默认开启库存预分配功能
	
	public static final int TYPE_SHAKE = 1;//摇一摇抽奖
	public static final int TYPE_SCRATCH = 2;//刮刮乐
	public static final int TYPE_TURNTABLE = 3;//大转盘
	public static final int TYPE_TIGER = 4;//老虎机,

	//Start chaijiangang,幸运转盘改为活动工具,2016/04/12
	public static final String TYPE_SHAKE_Action = "shake";//摇一摇抽奖
	public static final String TYPE_SCRATCH_Action = "ScratchCard";//刮刮乐
	public static final String TYPE_TURNTABLE_Action = "turntableNew";//大转盘
	public static final String TYPE_TIGER_Action = "tiger";//老虎机
	//End chaijiangang,幸运转盘改为活动工具,2016/04/12
	
	public static final ImmutableSet<Integer> hdtoolSet = ImmutableSet.of(TYPE_SHAKE,TYPE_SCRATCH,TYPE_TURNTABLE,TYPE_TIGER);


	private Long id;
	private String title;
	private Integer type;
	private String subType;
	private Integer creditsType;
	private Long creditsPrice;
	private Integer freeLimit;
	private String freeScope;
	private Integer limitCount;
	private String limitScope;
	private String description;
	private String image;
	private String bannerImage;
	private String smallImage;
	private String whiteImage;
	private String logo;
	private Integer switches;
	private Integer status;
	private Boolean deleted;
	private Date gmtCreate;
	private Date gmtModified;

	private String rateIntroduction;	// 概率说明
	private Date autoOffDate; //定时自动下架日期
	private String recommendImage; // 推荐位横幅图
	private String freeRule;
	private Long activityCategoryId;//活动分类

	public DuibaHdtoolDO() {

	}

	public DuibaHdtoolDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public DuibaHdtoolDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			status = OperatingActivityDO.StatusIntNoComplete;
			deleted = false;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}
	
	public void openSwitch(int s) {
		int v = 1 << s;
		switches = switches | v;
	}

	public void closeSwitch(int s) {
		int v = 1 << s;
		v = ~v;
		switches = switches & v;
	}

	public boolean isOpenSwitch(int s) {
		int v = 1 << s;
		int ret = switches & v;
		return ret != 0;
	}

	public String getRateIntroduction() {
		return rateIntroduction;
	}

	public void setRateIntroduction(String rateIntroduction) {
		this.rateIntroduction = rateIntroduction;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}

	public Integer getCreditsType() {
		return creditsType;
	}

	public void setCreditsType(Integer creditsType) {
		this.creditsType = creditsType;
	}

	public Long getCreditsPrice() {
		return creditsPrice;
	}

	public void setCreditsPrice(Long creditsPrice) {
		this.creditsPrice = creditsPrice;
	}

	public Integer getFreeLimit() {
		return freeLimit;
	}

	public void setFreeLimit(Integer freeLimit) {
		this.freeLimit = freeLimit;
	}

	public String getFreeScope() {
		return freeScope;
	}

	public void setFreeScope(String freeScope) {
		this.freeScope = freeScope;
	}

	public Integer getLimitCount() {
		return limitCount;
	}

	public void setLimitCount(Integer limitCount) {
		this.limitCount = limitCount;
	}

	public String getLimitScope() {
		return limitScope;
	}

	public void setLimitScope(String limitScope) {
		this.limitScope = limitScope;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getBannerImage() {
		return bannerImage;
	}

	public void setBannerImage(String bannerImage) {
		this.bannerImage = bannerImage;
	}

	public String getSmallImage() {
		return smallImage;
	}

	public void setSmallImage(String smallImage) {
		this.smallImage = smallImage;
	}

	public String getLogo() {
		return logo;
	}

	public void setLogo(String logo) {
		this.logo = logo;
	}

	public Integer getSwitches() {
		return switches;
	}

	public void setSwitches(Integer switches) {
		this.switches = switches;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Date getAutoOffDate() {
		return autoOffDate;
	}

	public void setAutoOffDate(Date autoOffDate) {
		this.autoOffDate = autoOffDate;
	}

	public String getWhiteImage() {
		return whiteImage;
	}

	public void setWhiteImage(String whiteImage) {
		this.whiteImage = whiteImage;
	}

	public String getRecommendImage() {
		return recommendImage;
	}

	public void setRecommendImage(String recommendImage) {
		this.recommendImage = recommendImage;
	}

	public String getFreeRule() {
		return freeRule;
	}

	public void setFreeRule(String freeRule) {
		this.freeRule = freeRule;
	}

	//Start chaijiangang,幸运转盘改为活动工具,2016/04/12
	public String getPreviewAction() {
		
		switch (this.type) {
		case TYPE_SHAKE: // 摇一摇 ok
			return TYPE_SHAKE_Action;
		case TYPE_SCRATCH: // 刮刮卡 ok
			return TYPE_SCRATCH_Action;
		case TYPE_TURNTABLE: // 活动工具大转盘 ok
			return TYPE_TURNTABLE_Action;
		case TYPE_TIGER: // 老虎机 ok
			return TYPE_TIGER_Action;
		default:
			return "";
		}
	}
	
	public boolean isHdTool(){
		if(this.type == TYPE_SHAKE
				|| this.type == TYPE_SCRATCH
			 	|| this.type == TYPE_TURNTABLE
			 	|| this.type == TYPE_TIGER)
			return true;
		else return false;
	}
	//End chaijiangang,幸运转盘改为活动工具,2016/04/12
	
	public Long getActivityCategoryId() {
        return activityCategoryId;
    }
    
    public void setActivityCategoryId(Long activityCategoryId) {
        this.activityCategoryId = activityCategoryId;
    }

}
