package cn.com.duiba.service.domain.dataobject;

import cn.com.duiba.dcommons.enums.AppBannerSourceTypeEnum;
import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class AppBannerDO extends BaseDO {
	private static final long serialVersionUID = 125L;


	public static final int SourceTypeMannual = AppBannerSourceTypeEnum.SourceTypeMannual.getCode();// 人工配制地址
	public static final int SourceTypeOperatingActivity = AppBannerSourceTypeEnum.SourceTypeOperatingActivity.getCode(); // 运营活动配制
	public static final int SourceTypeMannualUrl = AppBannerSourceTypeEnum.SourceTypeMannualUrl.getCode();// 人工配置 url
	public static final int SourceTypeDuibaActivity = AppBannerSourceTypeEnum.SourceTypeDuibaActivity.getCode(); // 专题活动
	public static final int SourceTypeSingleLottery = AppBannerSourceTypeEnum.SourceTypeSingleLottery.getCode(); // 单品抽奖
	public static final int SourceTypeList = AppBannerSourceTypeEnum.SourceTypeList.getCode(); // 指向列表类型
	public static final int SourceTypeManualLottery = AppBannerSourceTypeEnum.SourceTypeManualLottery.getCode();//手动开奖
	public static final int SourceTypeShakeLottery = AppBannerSourceTypeEnum.SourceTypeShakeLottery.getCode();//摇一摇抽奖
	public static final int SourceTypeScratchCardLottery = AppBannerSourceTypeEnum.SourceTypeScratchCardLottery.getCode();//刮刮乐抽奖
	public static final int SourceTypeHdturntable = AppBannerSourceTypeEnum.SourceTypeHdturntable.getCode();//活动工具幸运转盘
	public static final int SourceTypeTiger = AppBannerSourceTypeEnum.SourceTypeTiger.getCode();//刮刮乐抽奖
	public static final int SourceTypeSecondsKill = AppBannerSourceTypeEnum.SourceTypeSecondsKill.getCode();//秒杀专题
	public static final int SourceTypeGameSanta = AppBannerSourceTypeEnum.SourceTypeGameSanta.getCode();//游戏，打劫圣诞老人
	public static final int SourceTypeGameYearAward = AppBannerSourceTypeEnum.SourceTypeGameYearAward.getCode();//游戏，数年终奖
	public static final int SourceTypeGameGirl = AppBannerSourceTypeEnum.SourceTypeGameGirl.getCode();//游戏，女神pk
	public static final int SourceTypeGameJiong = AppBannerSourceTypeEnum.SourceTypeGameJiong.getCode();//游戏，人在囧途
	public static final int SourceTypeDuibaQuestionAnswer = AppBannerSourceTypeEnum.SourceTypeDuibaQuestionAnswer.getCode();//兑吧答题活动
	public static final int SourceTypeDuibaQuizz = AppBannerSourceTypeEnum.SourceTypeDuibaQuizz.getCode();//兑吧测试题活动
	public static final int SourceTypeDuibaSeckill = AppBannerSourceTypeEnum.SourceTypeDuibaSeckill.getCode();//秒杀活动
	public static final int SourceTypeDuibaNgame = AppBannerSourceTypeEnum.SourceTypeDuibaNgame.getCode();//新游戏
	public static final int SourceTypeDuibaGuess = AppBannerSourceTypeEnum.SourceTypeDuibaGuess.getCode();//兑吧竞猜
	public static final int SourceTypeNgame = AppBannerSourceTypeEnum.SourceTypeNgame.getCode();//新游戏
	public static final int SourceTypeGuess = AppBannerSourceTypeEnum.SourceTypeGuess.getCode();//竞猜活动
	
	public static final String TypeBanner = "banner";
	public static final String TypeButton = "button";

	private Long id;

	private Long appId;

	private Integer payload;

	private String image;

	private String name;

	private String url;

	private String type;

	private Integer sourceType; // 来源类型

	private Long sourceRelationId; // 来源管理对象主键id

	private Boolean deleted;

	private Long appItemId;

	private String classifyImage;//分类列表表头图片

	private Boolean classifyImageSwitch;//分类列表表头图片显示开关

	private Date gmtCreate;

	private Date gmtModified;

	public AppBannerDO() {
	}

	public AppBannerDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public AppBannerDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			deleted = false;
			payload = 0;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public void beforeUpdate() {
		gmtModified = new Date();
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Integer getSourceType() {
		return sourceType;
	}

	public void setSourceType(Integer sourceType) {
		this.sourceType = sourceType;
	}

	public Long getSourceRelationId() {
		return sourceRelationId;
	}

	public void setSourceRelationId(Long sourceRelationId) {
		this.sourceRelationId = sourceRelationId;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getClassifyImage() {
		return classifyImage;
	}

	public void setClassifyImage(String classifyImage) {
		this.classifyImage = classifyImage;
	}

	public Boolean getClassifyImageSwitch() {
		return classifyImageSwitch;
	}

	public void setClassifyImageSwitch(Boolean classifyImageSwitch) {
		this.classifyImageSwitch = classifyImageSwitch;
	}

}
