/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.tools;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;

public class ItemCornerTagUtils {
    private static String CustomTagSplitSymbol = ",";
    private static Joiner joiner = Joiner.on((String)CustomTagSplitSymbol).skipNulls();
    public static int CustomTag_No1 = 0;
    public static int CustomTag_No2 = 1;

    public static String getCustomTagText(Optional<AppItemDO> appItem) {
        String custom = ((AppItemDO)appItem.get()).getCustomTag();
        if (StringUtils.isBlank((String)custom)) {
            return "";
        }
        String[] ss = custom.split(CustomTagSplitSymbol);
        if (ss.length == 0) {
            return "";
        }
        return ss[CustomTag_No1];
    }

    public static String getCustomTagColor(Optional<AppItemDO> appItem) {
        String custom = ((AppItemDO)appItem.get()).getCustomTag();
        if (StringUtils.isBlank((String)custom)) {
            return "#fe4a21";
        }
        String[] ss = custom.split(CustomTagSplitSymbol);
        if (ss.length < CustomTag_No2 + 1) {
            return "#fe4a21";
        }
        return ss[CustomTag_No2];
    }

    public static String getCustomTag(String customTagText, String customTagColor) throws Exception {
        if (StringUtils.isBlank((String)customTagText) || StringUtils.isBlank((String)customTagColor)) {
            throw new Exception("\u81ea\u5b9a\u4e49\u89d2\u6807\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        return joiner.join((Object)customTagText, (Object)customTagColor, new Object[0]);
    }
}

