package cn.com.duiba.service.remoteservice;

import java.util.List;

import cn.com.duiba.service.domain.dataobject.DeveloperBlackDO;

public interface RemoteAdminBlackListService {
    /**
     * 批量新增黑名单
     * 批量新增黑名单,返回执行成功的类,已存在的会自动过滤不添加
     * return 执行成功的类
     * 类中包含参数:id,activityId,activityType,developerId
     */
    public List<DeveloperBlackDO> createBlackList(List<DeveloperBlackDO> blacks);
 
    /**
     * 删除黑名单
     * @param id
     * @return 成功,失败
     */
    public Boolean removeBlack(Long id);
    /**
     * 根据活动查询黑名单列表
     * 管理端 分页显示某个活动的黑名单列表
     * @param
     *      activityId 活动id
     *      activityType 活动类型
     *      offset 开始位置
     *      max 每页数量
     * @return
     *      List<DeveloperBlackDO> 黑名单列表
     */
    public List<DeveloperBlackDO> queryByActivity(Long activityId,Integer activityType,Integer offset,Integer max);
 
    /**
      *查询总数
      *@param
      *    activityId  活动id,activityType 活动类型
      *@return
      *    Integer 总数
      */
    public Integer queryCountByActivity(Long activityId,Integer activityType);
}
