package cn.com.duiba.service.remoteservice;

import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.vo.AppDeveloperVO;
import cn.com.duiba.service.domain.vo.AppManageVO;
import cn.com.duiba.service.exception.StatusException;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/4/14.
 */
public interface RemoteAppService {

    public List<AppDO> findByIds(List<Long> ids);

    public List<AppDO> findAll();

    public AppDO find(Long id);

    public AppDO insert(AppDO app);

    public int update(AppDO app);

    public List<Long> findAllEnable();

    public int updateSwitch(Long id, Integer appSwitch);


    public void updateForDeveloperBack(AppDO app);

    public void clearMonthBudget(Long appId);

    public void cleanDayBudget(Long appId);

    /**
     * 扣除预算，用于创建订单流程中
     */
    public void deductBudget(Long appId, Integer actualPrice) throws StatusException;

    /**
     * 返还预算
     */
    public void restoreBudget(OrdersDto order);

    //public AppDO findAppByDetail(Long appId);

    public List<AppDO> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds);

    public AppDO findByAppKey(String appKey);

    public List<AppDO> findAllByDeveloper(Long developerId);

    public List<AppDO> findAppNameByNameLike(String appName);
    /**
     * 自动推荐的兑换项 推荐的app数量
     * @param itemId
     * @return
     */
    public Integer countItemAutoRecommandApp(Long itemId);
    /**
     * 获取某兑换项自动推荐的app列表
     * @param itemId
     * @return
     */
    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId);

    public List<AppDO> findAllByDeveloperIds(List<Long> developerIds);

    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap);

    public Integer findAppListCount(Map<String, Object> queryMap);

    /**
     * 找到第一个创建的App
     * @param developerId
     * @return
     */
    public AppDO findFristAppByDeveloperId(Long developerId);

    public List<AppManageVO> findByAppIds(List<Long> appIds);



    /**
     * 根据appId列表查询多条APP+开发者信息
     * @param appIdList
     * @return
     */
    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList);

    /**
     * 查询所有app
     * @param start
     * @param pageSize
     * @return
     */
    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize);


    public HashMap<String, Object> selectOneAppDeveloper(Long appId);


    public List<Long> selectAppIdByName(String appName);


    public List<Long> selectAppIdByEmail(String email);


    public List<Long> selectAppIdByEmailAndName(String email, String appName);

    public Integer countApp();

    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList);

    /**
     * 开发者后台更新 预算控制
     */
    public boolean updateForDeveloperBack(Long appId, Double dayBudget, Double monthBudget, Double auditPricePerConsumer);

    /**
     * from AappManageCtrl.updateAppConfig in manager,
     * @param appId
     * @param entranceDesc
     * @param callLoginProgram
     * @param appType
     * @param useloginCode
     * @param freeItemVip
     */
    public void updateAppConfig(Long appId,String entranceDesc, String callLoginProgram,String appType, String useloginCode,String freeItemVip,String exchangeCreditsType);
}
