package cn.com.duiba.service.tools;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.order.center.api.dto.orders.OrdersDto;
import cn.com.duiba.service.domain.dataobject.*;
import cn.com.duiba.service.exception.BusinessException;

public class DevAccessVerifyUtils {
	/**
	 * app本地化验证（保证：developerId是从RequestLocal中获取的）
	 * @param developerId
	 * @param app
	 * @throws Exception 验证不通过
	 */
	public static void canAccessApp(Long developerId,AppDO app) throws BusinessException{
		if(app==null){
			throw new BusinessException("无权访问");
		}
		if(!app.getDeveloperId().equals(developerId)){
			throw new BusinessException("无权访问");
		}
	}
	/**
	 * appItem归属验证
	 * @param appId
	 * @param appItem
	 * @throws Exception 验证不通过
	 */
	public static void canAccessAppItem(Long appId,AppItemDO appItem) throws BusinessException{
		if(appItem==null){
			throw new BusinessException("无权访问");
		}
		if(!appItem.getAppId().equals(appId)){
			throw new BusinessException("无权访问");
		}
	}
	/**
	 * 开发者优惠券批次归属验证
	 * @param batch
	 * @throws Exception 验证不通过
	 */
	public static void canAccessCouponBatch(Long appItemId,CouponBatchDO batch)throws BusinessException{
		if(batch==null){
			throw new BusinessException("无权访问该批次");
		}
		if(!batch.getAppItemId().equals(appItemId)){
			throw new BusinessException("无权访问该批次");
		}
	}

	/**
	 * 开发者活动归属验证
	 * @param appId
	 * @param activity
	 * @throws Exception
	 */
	public static void canAccessActivity(Long appId,OperatingActivityDto activity)throws BusinessException{
		if(activity==null){
			throw new BusinessException("无权访问该活动");
		}
		if(!activity.getAppId().equals(appId)){
			throw new BusinessException("无权访问该活动");

		}
	}

	public static void canAccessAppLayout(Long appId,AppLayoutDO appLayout)throws BusinessException{
		if(appLayout==null){
			throw new BusinessException("无权访问该活动");
		}
		if(!appLayout.getAppId().equals(appId)){
			throw new BusinessException("无权访问该活动");

		}
	}
	/**
	 * AppBanner归属验证
	 * @param appId
	 * @param appBanner
	 * @throws Exception
	 */
	public static void canAccessAppBanner(Long appId,AppBannerDO appBanner)throws BusinessException{
		if(appBanner==null){
			throw new BusinessException("无权访问该活动");
		}
		if(!appBanner.getAppId().equals(appId)){
			throw new BusinessException("无权访问该活动");

		}
	}
	/**
	 * 订单归属验证
	 * @param appId
	 * @param order
	 * @throws Exception
	 */
	public static void canAccessOrder(Long appId,OrdersDto order)throws BusinessException{
		if(order==null){
			throw new BusinessException("无权访问该活动");
		}
		if(!order.getAppId().equals(appId)){
			throw new BusinessException("无权访问该活动");

		}
	}

	public  static void canAccessAppSingleLottery(Long appId, AppSingleLotteryDto appSingleLottery) throws BusinessException{
		if(appSingleLottery==null){
			throw new BusinessException("无权访问该活动");
		}
		if(!appSingleLottery.getAppId().equals(appId)){
			throw new BusinessException("无权访问该活动");
		}
	}

}
