package cn.com.duiba.service.tools;

import cn.com.duiba.wolf.perf.timeprofile.RequestTool;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public interface DuibaEvent<X> {

	public X getData();
	
	public static class RequestParams implements Serializable{
		private static final long serialVersionUID = 1529364971492104908L;
		private String userAgent;
		private Long consumerId;
		private String ip;
		private String os;
		private Map<String, String> cookies = new HashMap<String, String>();
		public String getUserAgent() {
			return userAgent;
		}
		public void setUserAgent(String userAgent) {
			this.userAgent = userAgent;
		}
		public Long getConsumerId() {
			return consumerId;
		}
		public void setConsumerId(Long consumerId) {
			this.consumerId = consumerId;
		}
		public String getIp() {
			return ip;
		}
		public void setIp(String ip) {
			this.ip = ip;
		}
		public String getCookies(String name) {
			return this.cookies.get(name);
		}

		public void setCookies(HttpServletRequest request) {
			Cookie[] cookies = request.getCookies();
			if (cookies != null) {
				for (int i = 0; i < cookies.length; i++) {
					Cookie c = cookies[i];
					this.cookies.put(c.getName(), c.getValue());
				}
			}
		}
		public String getOs() {
			return os;
		}
		public void setOs(String os) {
			this.os = os;
		}
		public static RequestParams parse(HttpServletRequest request,Long consumerId){
			RequestParams rp=new RequestParams();
			rp.setUserAgent(request.getHeader("User-Agent"));
			rp.setIp(RequestTool.getIpAddr(request));
			rp.setConsumerId(consumerId);
			rp.setCookies(request);
			rp.setOs(RequestTool.getOSNew(request));
			return rp;
		}
		public Map<String, String> getCookies() {
			return cookies;
		}
		public void setCookies(Map<String, String> cookies) {
			this.cookies = cookies;
		}
	}
	
	
	
}
