package cn.com.duiba.service.domain.dataobject;

import java.util.Date;

import cn.com.duiba.service.domain.BaseDO;

public class ConsumerExchangeRecordDO extends BaseDO{
	/**
     * serialVersionUID:TODO(用一句话描述这个变量表示什么).
     * @since JDK 1.6
     */
    private static final long serialVersionUID = -7153678546807176822L;
    public static final int UNREAD = 1;
	public static final int TypeOrder = 1; // 普通的兑换订单而来
	public static final int TypeTurntable = 2; // 大转盘中奖订单而来
	public static final int TypeSingleLottery = 3;// 来源单品抽奖订单
	public static final int TypeManualLottery = 4;// 来源手动开奖订单
	public static final int TypeHdtoolLottery = 5;// 来源活动工具
	public static final int TypeGame = 6;// 来源游戏活动

	private Long id;
	private Long consumerId;
	private Integer type;
	private Long orderId;
	private Long relationId;
	private Date gmtCreate;
	private Date gmtModified;
	private Long switchs;
	private String json;

	public ConsumerExchangeRecordDO() {

	}

	public ConsumerExchangeRecordDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public ConsumerExchangeRecordDO(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = gmtCreate;
			switchs = (long) 0;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getRelationId() {
		return relationId;
	}

	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getSwitchs() {
		return switchs;
	}

	public void setSwitchs(Long switchs) {
		this.switchs = switchs;
	}

	public boolean getSwitchs(Integer type) {
		int v = 1 << type;
		long ret = switchs & v;
		return ret != 0;
	}

	public void disableSwitchs(Integer type) {
		int v = 1 << type;
		v = ~v;
		switchs = switchs & v;
	}

	public void enableSwitchs(Integer type) {
		int v = 1 << type;
		switchs = switchs | v;
	}

	public String getJson() {
		return json;
	}

	public void setJson(String json) {
		this.json = json;
	}

}
