package cn.com.duiba.service.tools;

import cn.com.duiba.wolf.utils.BlowfishUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.config.PropertiesFactoryBean;

import java.io.IOException;
import java.util.Properties;

public class DubiaPropertiesFactoryBean extends PropertiesFactoryBean{
	private static final String PREFIX="dbseccode";
	private static final String secret="CNxgrtFG2nYQUfu";
	
	
	@Override
	protected Properties createProperties() throws IOException {
		Properties properties = super.createProperties();
		Properties p=(Properties) properties.clone();
		for(Object key:p.keySet()){
			if(key instanceof String){
				String skey=(String) key;
				String value=(String)properties.get(skey);
				if(value!=null && value.startsWith(PREFIX)){
					//如果是加密的，进行解密操作
					value=decode(value);
					properties.put(skey, value);
				}else if(value!=null && skey.equals("memcached.authInfos")){
					String[] authInfos = StringUtils.split(value, ",");
					StringBuilder sb = new StringBuilder();
					if (authInfos != null && authInfos.length > 0) {
						for(String authInfo:authInfos) {
							if(StringUtils.isBlank(authInfo)){
								continue;
							}
							String[] temp = authInfo.split(":");
							if (temp.length >= 2) {
								String name = temp[0];
								String pass = temp[1];
								if(name.startsWith(PREFIX)){
									name = decode(name);
								}
								if(pass.startsWith(PREFIX)){
									pass = decode(pass);
								}
								sb.append(name).append(":").append(pass).append(",");
							}
						}
					}
					if(sb.length()>0) {
						sb.deleteCharAt(sb.length() - 1);
					}else{
						sb.append(value);
					}
					properties.put(skey, sb.toString());
				}
			}
		}
		return properties;
	}
	private String decode(String value){
		if(value.startsWith(PREFIX)){
			value=value.substring(PREFIX.length());
			return BlowfishUtils.decryptBlowfish(value, secret);
		}
		return value;
	}
	
	public static void main(String[] args) {
		String code="joadfjds";
		String value= BlowfishUtils.encryptBlowfish(code, secret);
		System.out.println(value);
	}
	
}
