package cn.com.duiba.service.domain.vo;

import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.tools.ItemCornerTagUtils;
import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;


public class ItemOpenVO implements Serializable {
	private static final long serialVersionUID = -2274527244857763304L;
	private String logo;
	private String image;//依赖与皮肤的缩略图风格
	private String title;
	private String subtitle;
	private String credits;
	private String tagClasses;
	private String tagColor;
	private String tagText;
	private String recommendText;
	private String link;
	private String salePrice;
	private Long id;
	private String type;

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getSalePrice() {
		return salePrice;
	}

	public void setSalePrice(String salePrice) {
		this.salePrice = salePrice;
	}

	public ItemOpenVO(ItemKeyVO ikv, String spm){
		this.logo=ikv.getLogo();
		this.title=ikv.getTitle();
		this.subtitle=ikv.getSubtitle();
		this.tagText = "";
		this.id = ikv.getId();
		this.type = ikv.getType();

		//判断自有模式
		ItemKey items = ikv.getItemKey();
		boolean owner = true;
		if(items.isSelfAppItemMode() && (items.getAppItem().getSourceType()==5&&items.getAppItem().getSourceType()==6)){
			owner = false;
		}
		StringBuffer sb = new StringBuffer();
		//除去兑完和已经兑换，代码逻辑越靠前，优先级越高
		if(owner && items.getAppItem()!=null && !StringUtils.isBlank(items.getAppItem().getCustomTag())){//自定义
			recommendText = "兑换";
			tagText = ItemCornerTagUtils.getCustomTagText(Optional.of(items.getAppItem()));
			tagColor = ItemCornerTagUtils.getCustomTagColor(Optional.of(items.getAppItem()));
			sb.append("custom ");
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_NORMAL){//普通
			recommendText = "兑换";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_TIME){//秒杀
			sb.append("timelimit ");
			tagText = "秒杀";
			tagColor = "#fe950b";
			recommendText = "兑换";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_LOTTERY){//抽奖
			sb.append("turntable ");
			tagText = "抽奖";
			tagColor = "#f43632";
			recommendText = "抽奖";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_GAME){//游戏
			sb.append("turntable ");
			tagText = "游戏";
			tagColor = "#f43632";
			recommendText = "游戏";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_NGAME){//游戏
			sb.append("turntable ");
			tagText = "游戏";
			tagColor = "#f43632";
			recommendText = "游戏";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_QUESTION){//游戏
			sb.append("turntable ");
			tagText = "答题";
			tagColor = "#f43632";
			recommendText = "答题";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_QUIZZ){//测试题
			sb.append("turntable");
			tagText = "活动";
			tagColor = "#f43632";
			recommendText = "活动";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_GUESS){//竞猜
			sb.append("turntable");
			tagText = "竞猜";
			tagColor = "#f43632";
			recommendText = "竞猜";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_NEW){//NEW
			sb.append("new ");
			tagText = "NEW";
			tagColor = "#ea0d08";
			if(ItemDO.TypeFake.equals(items.getItemType()) && items.getAppItem()!=null && ItemDO.TypeGameLottery.equals(items.getAppItem().getSourceType()) ){
				recommendText = "游戏";
			}if(ItemDO.TypeFake.equals(items.getItemType()) && items.getAppItem()!=null && ItemDO.TypeNgameLottery.equals(items.getAppItem().getSourceType()) ){
				recommendText = "游戏";
			}if(ItemDO.TypeFake.equals(items.getItemType()) && items.getAppItem()!=null && ItemDO.TypeQuestionLottery.equals(items.getAppItem().getSourceType())){
				recommendText = "答题";
			}if(ItemDO.TypeFake.equals(items.getItemType()) && items.getAppItem()!=null && ItemDO.TypeGuessLottery.equals(items.getAppItem().getSourceType())){
				recommendText = "竞猜";
			}
			if(ItemDO.TypeFake.equals(items.getItemType()) && items.getAppItem()!=null && ItemDO.TypeQuizzLottery.equals(items.getAppItem().getSourceType())){
				recommendText = "活动";
			}else if(ItemDO.TypeFake.equals(items.getItemType())){
				recommendText = "抽奖";
			}else {
				recommendText = "兑换";
			}
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_ACTIVITY){//活动
			sb.append("activity ");
			tagText = "活动";
			tagColor = "#32c59b";
			recommendText = "抽奖";
		}else if(ikv.getMarkStatus()==ItemKeyVO.MARK_CREDIT_GAME){//积分游戏
            sb.append("activity ");
            tagText = "积分游戏";
            tagColor = "#f43632";
            recommendText = "积分游戏";
        }

		if(ikv.getUseStatus()==ItemKeyVO.STATUS_USED){
			sb.append("hasexchanged ");
			tagText = "已兑";
			tagColor = "#aaa";
			recommendText = "已兑";
		}else if(ikv.getUseStatus()==ItemKeyVO.STATUS_NOREMAING){
			sb.append("outofstock ");
			tagText = "兑完";
			tagColor = "#aaa";
			recommendText = "兑完";
		}

		tagClasses = sb.toString().trim();
		//设置埋点
		String link = ikv.getLink();
		if(link.contains("?")){
			if(link.contains("dbnewopen")){
				link=link.replace("dbnewopen", "spm="+spm+"&dbnewopen");
			}else{
				link=link+"&spm="+spm;
			}
		}else{
			link=link+"?spm="+spm;
		}
		this.link = link;
	}

	public ItemOpenVO() {
	}

	public String getLogo() {
		return logo;
	}
	public void setLogo(String logo) {
		this.logo = logo;
	}
	public String getImage() {
		return image;
	}
	public void setImage(String image) {
		this.image = image;
	}
	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getSubtitle() {
		return subtitle;
	}
	public void setSubtitle(String subtitle) {
		this.subtitle = subtitle;
	}
	public String getCredits() {
		return credits;
	}
	public void setCredits(String credits) {
		this.credits = credits;
	}
	public String getTagClasses() {
		return tagClasses;
	}
	public void setTagClasses(String tagClasses) {
		this.tagClasses = tagClasses;
	}

	public String getRecommendText() {
		return recommendText;
	}

	public void setRecommendText(String recommendText) {
		this.recommendText = recommendText;
	}

	public String getLink() {
		return link;
	}

	public void setLink(String link) {
		this.link = link;
	}

	public String getTagText() {
		return tagText;
	}

	public void setTagText(String tagText) {
		this.tagText = tagText;
	}

	public String getTagColor() {
		return tagColor;
	}

	public void setTagColor(String tagColor) {
		this.tagColor = tagColor;
	}

}
