package cn.com.duiba.service.remoteservice;

import java.util.List;
import java.util.Map;

import cn.com.duiba.activity.center.api.dto.manual.AppManualLotteryDto;
import cn.com.duiba.service.exception.BusinessException;

public interface RemoteAppManualLotteryService {

	public List<AppManualLotteryDto> scanOverManualLottery();
	
	public void updateManualLottery(AppManualLotteryDto appManualLottery);
	
	public AppManualLotteryDto insert(AppManualLotteryDto appManualLotteryDO);
	
	public void update(AppManualLotteryDto appManualLotteryDO);
	
	public AppManualLotteryDto find(Long id);

	//from AppManualLotteryService in developer

	/**
	 * @auth huangwq
	 * @description 解析参数并新增一条抽奖数据
	 */
	public AppManualLotteryDto insertAppManualLottery(AppManualLotteryDto lottery) throws BusinessException;

	/**
	 * @auth zhangpan
	 * @description 解析参数并新增一条抽奖数据
	 * @param params
	 */
	public AppManualLotteryDto insertAppManualLottery(Map<String,Object> params);

	public void updateAppManualLottery(AppManualLotteryDto lottery) throws BusinessException;

	/**
	 * @auth zhangpan
	 * @description 更新
	 * @param params
	 * @return
	 */
	public void updateAppManualLottery(Map<String,Object> params) throws BusinessException;

	/**
	 * @auth huangwq
	 * @description 把开发者添加的人工开奖加入到活动列表中
	 * @param appManualLotteryDO
	 */
	public void appManualLotteryToActivity(AppManualLotteryDto appManualLotteryDO) throws BusinessException;
	
	public List<AppManualLotteryDto> findAllByIds(List<Long> ids);
}
