/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.developer.DeveloperDao;
import cn.com.duiba.service.dao.credits.developer.RemainingMoneyDao;
import cn.com.duiba.service.domain.dataobject.DeveloperDO;
import cn.com.duiba.service.domain.dataobject.RemainingMoneyDO;
import cn.com.duiba.service.service.DeveloperService;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeveloperServiceImpl
implements DeveloperService {
    @Resource
    private DeveloperDao developerDao;
    @Resource
    private RemainingMoneyDao remainingMoneyDao;
    @Value(value="#{configProperties['app.balance.key']}")
    private String privateKey;

    @Override
    @Transactional(value="credits")
    public void insertDeveloper(DeveloperDO developer) {
        this.developerDao.insert(developer);
        developer = this.developerDao.findByEmail(developer.getEmail());
        RemainingMoneyDO rm = new RemainingMoneyDO(true);
        rm.setDeveloperId(developer.getId());
        rm.setMoney(Integer.valueOf(0));
        rm.setVersion(Long.valueOf(0L));
        Integer newMoney = rm.getMoney();
        Long newVersion = rm.getVersion();
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + newMoney.toString() + newVersion + newModifedStr));
        rm.setSign(newSign);
        this.remainingMoneyDao.insert(rm);
    }
}

