/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.dao.credits.app.impl;

import cn.com.duiba.service.dao.BaseDao;
import cn.com.duiba.service.dao.DatabaseSchema;
import cn.com.duiba.service.dao.credits.app.AppDao;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.vo.AppDeveloperVO;
import cn.com.duiba.service.domain.vo.AppManageVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class AppDaoImpl
extends BaseDao
implements AppDao {
    @Override
    public List<AppDO> findByIds(List<Long> ids) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("ids", ids);
        return this.selectList("findByIds", map);
    }

    @Override
    public List<AppDO> findAll() {
        return this.selectList("findAll");
    }

    @Override
    public AppDO find(Long id) {
        return (AppDO)this.selectOne("find", id);
    }

    @Override
    public void insert(AppDO app) {
        this.insert("insert", app);
    }

    @Override
    public int update(AppDO app) {
        int ret = this.update("update", app);
        return ret;
    }

    @Override
    public List<Long> findAllEnable() {
        return this.selectList("findAllEnable");
    }

    @Override
    public AppDO findForUpdate(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (AppDO)this.selectOne("findForUpdate", paramMap);
    }

    @Override
    public int updateSwitch(Long id, Integer appSwitch) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("id", id);
        map.put("appSwitch", appSwitch);
        int ret = this.update("updateSwitch", map);
        return ret;
    }

    @Override
    public void updateForDeveloperBack(AppDO app) {
        this.update("updateForDeveloperBack", app);
    }

    @Override
    public void clearMonthBudget(Long appId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        this.update("clearMonthBudget", map);
    }

    @Override
    public void cleanDayBudget(Long appId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        this.update("cleanDayBudget", map);
    }

    @Override
    public int deductBudgetDay(Long appId, Integer price) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("appId", appId);
        map.put("price", price);
        int ret = this.update("deductBudgetDay", map);
        return ret;
    }

    @Override
    public int deductBudgetMonth(Long appId, Integer price) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("appId", appId);
        map.put("price", price);
        int ret = this.update("deductBudgetMonth", map);
        return ret;
    }

    @Override
    public void restoreDayBudget(Long appId, Integer price) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("appId", appId);
        map.put("price", price);
        this.update("restoreDayBudget", map);
    }

    @Override
    public void restoreMonthBudget(Long appId, Integer price) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("appId", appId);
        map.put("price", price);
        this.update("restoreMonthBudget", map);
    }

    @Override
    public List<AppDO> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("specifyAppIds", specifyAppIds);
        map.put("blackAppIds", blackAppIds);
        return this.selectList("findAllBySpecifyAndBlack", map);
    }

    @Override
    public AppDO findByAppKey(String appKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appKey", appKey);
        return (AppDO)this.selectOne("findByAppKey", map);
    }

    @Override
    public List<AppDO> findAllByDeveloper(Long developerId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("developerId", developerId);
        return this.selectList("findAllByDeveloper", map);
    }

    @Override
    public List<AppDO> findAppNameByNameLike(String appName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appName", appName);
        return this.selectList("findAppNameByNameLike", map);
    }

    @Override
    public Integer countItemAutoRecommandApp(Long itemId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("itemId", itemId);
        return (Integer)this.selectOne("countItemAutoRecommandApp", map);
    }

    @Override
    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("itemId", itemId);
        return this.selectList("getAutoRecommandAppIdListByItemId", map);
    }

    @Override
    public List<AppDO> findAllByDeveloperIds(List<Long> developerIds) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("developerIds", developerIds);
        return this.selectList("findAllByDeveloperIds", map);
    }

    @Override
    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap) {
        return this.selectList("findAppListByCondition", queryMap);
    }

    @Override
    public Integer findAppListCount(Map<String, Object> queryMap) {
        return (Integer)this.selectOne("findAppListCount", queryMap);
    }

    @Override
    public AppDO findFristAppByDeveloperId(Long developerId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("developerId", developerId);
        return (AppDO)this.selectOne("findFristAppByDeveloperId", map);
    }

    @Override
    public List<AppManageVO> findByAppIds(List<Long> appIds) {
        return this.selectList("findByAppIds", appIds);
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("list", appIdList);
        return this.selectList("selectAppDeveloper", map);
    }

    @Override
    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("start", start);
        map.put("pageSize", pageSize);
        return this.selectList("selectAllAppDeveloper", map);
    }

    @Override
    public HashMap<String, Object> selectOneAppDeveloper(Long appId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        return (HashMap)this.selectOne("selectOneAppDeveloper", map);
    }

    @Override
    public List<Long> selectAppIdByName(String appName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appName", appName);
        return this.selectList("selectAppIdByName", map);
    }

    @Override
    public List<Long> selectAppIdByEmail(String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        return this.selectList("selectAppIdByEmail", map);
    }

    @Override
    public List<Long> selectAppIdByEmailAndName(String email, String appName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        map.put("appName", appName);
        return this.selectList("selectAppIdByEmailAndName", map);
    }

    @Override
    public Integer countApp() {
        return (Integer)this.selectOne("countApp");
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("list", appIdList);
        return this.selectList("selectAppDeveloperByAppId", map);
    }

    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}

