/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.AppVipLimitDao;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppVipLimitDO;
import cn.com.duiba.service.domain.vo.VipConfigVO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.service.AppService;
import cn.com.duiba.service.service.AppVipLimitService;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AppVipLimitServiceImpl
implements AppVipLimitService {
    @Resource
    private AppVipLimitDao appVipLimitDao;
    @Resource
    private AppService appService;

    @Override
    public String submitVipConfig(VipConfigVO vo) throws BusinessException {
        if (vo.getAppId() == null) {
            throw new BusinessException("appId is null");
        }
        AppVipLimitDO viplimit = this.appVipLimitDao.findbyAppId(vo.getAppId());
        viplimit = viplimit == null ? new AppVipLimitDO(true) : new AppVipLimitDO(viplimit.getId());
        viplimit.setAppId(vo.getAppId());
        viplimit.setDoMethod(Integer.valueOf(vo.getDoMethod()));
        viplimit.setRulePoint(Integer.valueOf(vo.getRulePoint()));
        viplimit.setRuleText(vo.getRuleText());
        if (vo.getRulePoint() == AppVipLimitDO.USE_YOUSELF && StringUtils.isBlank((String)vo.getRuleUrl())) {
            throw new BusinessException("\u4f7f\u7528\u81ea\u5df1\u7684\u89c4\u5219\u8bf4\u660e\u9875\u9762\u65f6\uff0c\u5fc5\u987b\u8981\u914d\u7f6e\u9875\u9762\u94fe\u63a5");
        }
        if (!(vo.getRulePoint() != AppVipLimitDO.USE_YOUSELF || vo.getRuleUrl().contains("://") && vo.getRuleUrl().indexOf("://") != 0)) {
            throw new BusinessException("\u89c4\u5219\u9875\u9762\u94fe\u63a5\u5fc5\u987b\u5e26\u534f\u8bae\u524d\u7f00");
        }
        viplimit.setRuleUrl(vo.getRuleUrl());
        String[] names = vo.getNames();
        int[] levels = vo.getLevels();
        if (names.length != levels.length) {
            throw new BusinessException("\u7b49\u7ea7\u6570\u4e0e\u540d\u79f0\u6570\u4e0d\u76f8\u7b49");
        }
        if (levels.length > 40) {
            throw new BusinessException("\u7b49\u7ea7\u6570\u8d85\u8fc740\u4e2a");
        }
        HashMap<Integer, String> configMap = new HashMap<Integer, String>();
        int i = 0;
        while (i < names.length) {
            if (names[i].length() > 20) {
                throw new BusinessException("\u4f1a\u5458\u540d\u79f0\u8fc7\u957f");
            }
            configMap.put(levels[i], names[i]);
            ++i;
        }
        String jsonconfig = this.getLevelForNameJson(configMap);
        AppDO app = this.appService.findForUpdate(vo.getAppId());
        if (vo.isOpen()) {
            app.grantAppSwitch(3);
        } else {
            app.ungrantAppSwitch(3);
        }
        app.setVipLevelConfig(jsonconfig);
        AppDO app4u = new AppDO(app.getId());
        app4u.setAppSwitch(app.getAppSwitch());
        app4u.setVipLevelConfig(app.getVipLevelConfig());
        this.appService.update(app4u);
        if (viplimit.getId() == null) {
            this.appVipLimitDao.insert(viplimit);
        } else {
            this.appVipLimitDao.update(viplimit);
        }
        return "\u4f1a\u5458\u914d\u7f6e\u63d0\u4ea4\u6210\u529f\uff01";
    }

    private String getLevelForNameJson(Map<Integer, String> map) {
        ArrayList jsonObj = new ArrayList();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            HashMap<String, Object> jsonmap = new HashMap<String, Object>();
            jsonmap.put("level", entry.getKey());
            jsonmap.put("name", entry.getValue());
            jsonObj.add(jsonmap);
        }
        return JSON.toJSONString(jsonObj);
    }
}

