/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.AppTagsMaskingDao;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppTagsMaskingDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.service.AppService;
import cn.com.duiba.service.service.DevCustomMService;
import cn.com.duiba.service.tools.DevAccessVerifyUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DevCustomMServiceImpl
implements DevCustomMService {
    private static Logger log = LoggerFactory.getLogger(DevCustomMServiceImpl.class);
    @Resource
    private AppService appService;
    @Resource
    private AppTagsMaskingDao appTagsMaskingDao;

    @Override
    @Transactional(value="credits")
    public void doSet(Long developerId, Long appId, boolean autoRecommend, List<Long> tagids) throws BusinessException {
        AppDO app = this.appService.find(appId);
        DevAccessVerifyUtils.canAccessApp((Long)developerId, (AppDO)app);
        try {
            AppDO app4update = new AppDO(app.getId());
            app4update.setAutoRecommend(Boolean.valueOf(autoRecommend));
            this.appService.update(app4update);
            this.appTagsMaskingDao.deleteByAppId(app.getId());
            for (Long id : tagids) {
                AppTagsMaskingDO appTags = new AppTagsMaskingDO(true);
                appTags.setAppId(app.getId());
                appTags.setTagsId(id);
                this.appTagsMaskingDao.insert(appTags);
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u63a8\u8350\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4fdd\u5b58\u63a8\u8350\u8bbe\u7f6e\u5f02\u5e38", (Throwable)e);
        }
    }
}

