/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.developer.DeveloperActivityBlackDao;
import cn.com.duiba.service.domain.dataobject.DeveloperBlackDO;
import cn.com.duiba.service.service.DeveloperActBlackService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DeveloperActBlackServiceImpl
implements DeveloperActBlackService {
    @Resource
    private DeveloperActivityBlackDao developerActivityBlackDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public List<DeveloperBlackDO> createBlackList(List<DeveloperBlackDO> blacks) {
        if (blacks == null) {
            return null;
        }
        ArrayList<DeveloperBlackDO> rs = new ArrayList<DeveloperBlackDO>();
        for (DeveloperBlackDO black : blacks) {
            int num = this.developerActivityBlackDao.query(black);
            if (num != 0) continue;
            this.developerActivityBlackDao.insert(black);
            rs.add(black);
        }
        return rs;
    }

    @Override
    public Boolean removeBlack(Long id) {
        if (1 == this.developerActivityBlackDao.remove(id)) {
            return true;
        }
        return false;
    }

    @Override
    public List<DeveloperBlackDO> queryByActivity(Long activityId, Integer activityType, Integer offset, Integer max) {
        if (activityId == null || activityType == null) {
            return null;
        }
        if (offset == null || offset < 0) {
            offset = 0;
        }
        if (max == null || max <= 0) {
            max = 10;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("activityId", activityId);
        paramMap.put("activityType", activityType);
        paramMap.put("offset", offset);
        paramMap.put("max", max);
        return this.developerActivityBlackDao.queryByActivity(paramMap);
    }

    @Override
    public Integer queryCountByActivity(Long activityId, Integer activityType) {
        return this.developerActivityBlackDao.queryCountByActivity(activityId, activityType);
    }

    @Override
    public Integer query(DeveloperBlackDO black) {
        return this.developerActivityBlackDao.query(black);
    }

    @Override
    public void removeBlackCache(DeveloperBlackDO black) {
        this.memcachedClient.remove(this.getBlackCacheKey(black));
    }

    @Override
    public void setBlackCache(DeveloperBlackDO black, Boolean value) {
        this.memcachedClient.set(this.getBlackCacheKey(black), (Object)value, 300);
    }

    public String getBlackCacheKey(DeveloperBlackDO black) {
        return "chaos.black_" + black.getDeveloperId() + "_" + black.getActivityId() + "_" + black.getActivityType();
    }
}

