/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.AppBannerDao;
import cn.com.duiba.service.domain.dataobject.AppBannerDO;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.service.AppBannerService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppBannerServiceImpl
implements AppBannerService {
    @Resource
    private AppBannerDao appBannerDao;
    @Resource
    private CacheClient cacheClient;

    @Override
    public List<AppBannerDO> findAllByIds(List<Long> ids) {
        return this.appBannerDao.findAllByIds(ids);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        return this.appBannerDao.findAppIdsByIds(ids);
    }

    @Override
    public AppBannerDO find(Long id) {
        return this.appBannerDao.find(id);
    }

    @Override
    public void insert(AppBannerDO appBanner) {
        this.appBannerDao.insert(appBanner);
        this.removeCacheByAppId(appBanner.getAppId());
    }

    @Override
    public Integer update(AppBannerDO appBanner) {
        Integer ret = this.appBannerDao.update(appBanner);
        this.removeCacheByAppId(appBanner.getAppId());
        return ret;
    }

    @Override
    public List<AppBannerDO> findIconClassify(Long appId, Long classifyId) {
        return this.appBannerDao.findIconClassify(appId, classifyId);
    }

    @Override
    public Integer deleteByClassify(Boolean delete, Long relationId, Long appId) {
        Integer ret = this.appBannerDao.deleteByClassify(delete, relationId, appId);
        this.removeCacheByAppId(appId);
        return ret;
    }

    @Override
    public Integer disableAppBannerByIds(List<Long> appBannerIdList) {
        int ret = this.appBannerDao.disableAppBannerByIds(appBannerIdList);
        this.removeCacheByAppBannerIds(appBannerIdList);
        return ret;
    }

    @Override
    public Integer disableByActivityId(Boolean delete, Long activityId, Integer type) {
        int ret = this.appBannerDao.disableByActivityId(delete, activityId, type);
        List<Long> appIds = this.appBannerDao.findAppIdsByActivityIdAndType(activityId, type);
        for (Long appId : appIds) {
            this.removeCacheByAppId(appId);
        }
        return ret;
    }

    @Override
    public Integer disableByOperatingActivityId(Boolean delete, Long relationId) {
        int ret = this.appBannerDao.disableByOperatingActivityId(delete, relationId);
        List<Long> appIds = this.appBannerDao.findAppIdsByActivityId(relationId);
        for (Long appId : appIds) {
            this.removeCacheByAppId(appId);
        }
        return ret;
    }

    @Override
    public Integer disableByAppItemId(Long appItemId) {
        int ret = this.appBannerDao.disableByAppItemId(appItemId);
        List<AppBannerDO> abs = this.appBannerDao.findByAppItemId(appItemId);
        ArrayList<Long> appBannerIds = new ArrayList<Long>();
        for (AppBannerDO ab : abs) {
            appBannerIds.add(ab.getId());
        }
        this.removeCacheByAppBannerIds(appBannerIds);
        return ret;
    }

    @Override
    public Integer disableByItemId(Long itemId) {
        int ret = this.appBannerDao.disableByItemId(itemId);
        List<AppBannerDO> appBanners = this.appBannerDao.findAllByItemId(itemId);
        ArrayList<Long> appBannerIds = new ArrayList<Long>();
        for (AppBannerDO ab : appBanners) {
            appBannerIds.add(ab.getId());
        }
        this.removeCacheByAppBannerIds(appBannerIds);
        return ret;
    }

    @Override
    public Integer disableByAppIdAndAppItemId(Long appId, Long appItemId) {
        int ret = this.appBannerDao.disableByAppIdAndAppItemId(appId, appItemId);
        this.removeCacheByAppId(appId);
        return ret;
    }

    @Override
    public Integer updateNameImage(Long id, String name, String image) {
        int ret = this.appBannerDao.updateNameImage(id, name, image);
        this.removeCacheByAppBannerIds(Arrays.asList(id));
        return ret;
    }

    @Override
    public AppBannerDO findExistBanner(Long appId, Long appItemId, String type) {
        return this.appBannerDao.findExistBanner(appId, appItemId, type);
    }

    @Override
    public Integer findBannerNumByType(Long appId, String type) {
        return this.appBannerDao.findBannerNumByType(appId, type);
    }

    @Override
    public Integer findMaxPlayload(Long appId, String type) {
        return this.appBannerDao.findMaxPlayload(appId, type);
    }

    @Override
    public List<AppBannerDO> findAllByAppIdDeleteAndType(Long appId, String type, Boolean deleted) {
        return this.appBannerDao.findAllByAppIdDeleteAndType(appId, type, deleted);
    }

    @Override
    public List<AppBannerDO> findAllByAppId(Long appId, Boolean deleted) {
        return this.appBannerDao.findAllByAppId(appId, deleted);
    }

    @Override
    public List<AppBannerDO> findAllByItemId(Long itemId) {
        return this.appBannerDao.findAllByItemId(itemId);
    }

    @Override
    public List<AppBannerDO> findByAppItemId(Long appItemId) {
        return this.appBannerDao.findByAppItemId(appItemId);
    }

    @Override
    public List<AppBannerDO> findHomeBannerByCache(AppDO app, boolean deleted) {
        String key = this.getCacheKeyByAppId(app.getId());
        List<AppBannerDO> list = (List<AppBannerDO>)this.cacheClient.get(key);
        if (list == null) {
            list = this.findAllByAppId(app.getId(), deleted);
            if (list == null) {
                list = new ArrayList<AppBannerDO>();
            }
            this.cacheClient.set(key, list, 120);
        }
        return list;
    }

    private void removeCacheByAppBannerIds(List<Long> appBannerIds) {
        List<Long> bannerAppIds = this.findAppIdsByIds(appBannerIds);
        for (Long appId : bannerAppIds) {
            this.removeCacheByAppId(appId);
        }
    }

    private void removeCacheByAppId(Long appId) {
        this.cacheClient.remove(this.getCacheKeyByAppId(appId));
    }

    private String getCacheKeyByAppId(Long appId) {
        return "chaos.keyAppBanners_" + appId;
    }
}

