/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.AppLayoutDao;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppLayoutDO;
import cn.com.duiba.service.service.AppLayoutService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppLayoutServiceImpl
implements AppLayoutService {
    private static Logger log = LoggerFactory.getLogger(AppLayoutServiceImpl.class);
    @Value(value="${app.theme.defaultId}")
    private String defaultThemeId;
    @Resource
    private AppLayoutDao appLayoutDao;

    @Override
    public void createAppLayoutDO(AppDO app) {
        JSONObject json = new JSONObject();
        AppLayoutDO appLayoutDO = new AppLayoutDO(true);
        appLayoutDO.setAppId(app.getId());
        appLayoutDO.setDraftBrickIds(json.toJSONString());
        appLayoutDO.setCustomBrickIds(json.toJSONString());
        json.put("0", (Object)new Long(this.defaultThemeId));
        appLayoutDO.setBrickIds(json.toJSONString());
        appLayoutDO.setThemeColor("#11c3bc");
        this.appLayoutDao.insert(appLayoutDO);
    }

    @Override
    public int updateAppColor(Optional<AppDO> app, Optional<String> color) {
        return this.appLayoutDao.updateAppColor(app, color);
    }

    @Override
    public int insert(AppLayoutDO appLayout) {
        return this.appLayoutDao.insert(appLayout);
    }

    @Override
    public AppLayoutDO findByAppId(Long appId) {
        return this.appLayoutDao.findByAppId(appId);
    }

    @Override
    public int updateTheme(Optional<Long> id, Optional<JSONObject> brickIdJson) {
        return this.appLayoutDao.updateTheme(id, brickIdJson);
    }

    @Override
    public int updateColor(Optional<Long> id, Optional<String> color) {
        return this.appLayoutDao.updateColor(id, color);
    }
}

