/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.developer.DeveloperDao;
import cn.com.duiba.service.dao.credits.developer.RemainingMoneyDao;
import cn.com.duiba.service.domain.dataobject.DeveloperDO;
import cn.com.duiba.service.domain.dataobject.RemainingMoneyDO;
import cn.com.duiba.service.domain.queryparams.ADeveloperQueryEntity;
import cn.com.duiba.service.service.DeveloperService;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeveloperServiceImpl
implements DeveloperService {
    @Resource
    private DeveloperDao developerDao;
    @Resource
    private RemainingMoneyDao remainingMoneyDao;
    @Value(value="#{configProperties['app.balance.key']}")
    private String privateKey;

    @Override
    @Transactional(value="credits")
    public void insertDeveloper(DeveloperDO developer) {
        this.developerDao.insert(developer);
        developer = this.developerDao.findByEmail(developer.getEmail());
        RemainingMoneyDO rm = new RemainingMoneyDO(true);
        rm.setDeveloperId(developer.getId());
        rm.setMoney(Integer.valueOf(0));
        rm.setVersion(Long.valueOf(0L));
        Integer newMoney = rm.getMoney();
        Long newVersion = rm.getVersion();
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + newMoney.toString() + newVersion + newModifedStr));
        rm.setSign(newSign);
        this.remainingMoneyDao.insert(rm);
    }

    @Override
    public DeveloperDO findByEmail(String email) {
        return this.developerDao.findByEmail(email);
    }

    @Override
    public DeveloperDO find(Long id) {
        return this.developerDao.find(id);
    }

    @Override
    public List<DeveloperDO> findByEmailLike(String email) {
        return this.developerDao.findByEmailLike(email);
    }

    @Override
    public List<DeveloperDO> findAllByIdList(List<Long> idList) {
        return this.developerDao.findAllByIdList(idList);
    }

    @Override
    public List<DeveloperDO> findDeveloperPage(ADeveloperQueryEntity queryEntity) {
        return this.developerDao.findDeveloperPage(queryEntity);
    }

    @Override
    public Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity) {
        return this.developerDao.findDeveloperPageCount(queryEntity);
    }

    @Override
    public void insert(DeveloperDO developerDO) {
        this.developerDao.insert(developerDO);
    }

    @Override
    public int updateDeveloperSwitch(Long id, Integer developerSwitch) {
        return this.developerDao.updateDeveloperSwitch(id, developerSwitch);
    }

    @Override
    public int updateLastRemindTime(Long id, Date lastRemindTime) {
        return this.developerDao.updateLastRemindTime(id, lastRemindTime);
    }

    @Override
    public int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company) {
        return this.developerDao.updateRemindMoneyNameCompany(id, remindMoney, name, company);
    }

    @Override
    public int updatePassword(Long id, String password) {
        return this.developerDao.updatePassword(id, password);
    }

    @Override
    public int updateVerifyAndEnable(Long id, boolean verify, boolean enable) {
        return this.developerDao.updateVerifyAndEnable(id, verify, enable);
    }
}

