/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.remoteservice.impl;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.OrdersDO;
import cn.com.duiba.service.domain.vo.AppDeveloperVO;
import cn.com.duiba.service.domain.vo.AppManageVO;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.service.AppService;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RemoteAppServiceImpl
implements RemoteAppService {
    @Resource
    private AppService appService;

    public List<AppDO> findByIds(List<Long> ids) {
        return this.appService.findByIds(ids);
    }

    public List<AppDO> findAll() {
        return this.appService.findAll();
    }

    public AppDO find(Long id) {
        return this.appService.find(id);
    }

    public void insert(AppDO app) {
        this.appService.insert(app);
    }

    public int update(AppDO app) {
        return this.appService.update(app);
    }

    public List<Long> findAllEnable() {
        return this.appService.findAllEnable();
    }

    public AppDO findForUpdate(Long id) {
        return this.appService.findForUpdate(id);
    }

    public int updateSwitch(Long id, Integer appSwitch) {
        return this.appService.updateSwitch(id, appSwitch);
    }

    public void updateForDeveloperBack(AppDO app) {
        this.appService.updateForDeveloperBack(app);
    }

    public void clearMonthBudget(Long appId) {
        this.appService.clearMonthBudget(appId);
    }

    public void cleanDayBudget(Long appId) {
        this.appService.cleanDayBudget(appId);
    }

    public void deductBudget(Long appId, Integer actualPrice) throws StatusException {
        this.appService.deductBudget(appId, actualPrice);
    }

    public void restoreBudget(OrdersDO order) {
        this.appService.restoreBudget(order);
    }

    public List<AppDO> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds) {
        return this.appService.findAllBySpecifyAndBlack(specifyAppIds, blackAppIds);
    }

    public AppDO findByAppKey(String appKey) {
        return this.appService.findByAppKey(appKey);
    }

    public List<AppDO> findAllByDeveloper(Long developerId) {
        return this.appService.findAllByDeveloper(developerId);
    }

    public List<AppDO> findAppNameByNameLike(String appName) {
        return this.appService.findAppNameByNameLike(appName);
    }

    public Integer countItemAutoRecommandApp(Long itemId) {
        return this.appService.countItemAutoRecommandApp(itemId);
    }

    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId) {
        return this.appService.getAutoRecommandAppIdListByItemId(itemId);
    }

    public List<AppDO> findAllByDeveloperIds(List<Long> developerIds) {
        return this.appService.findAllByDeveloperIds(developerIds);
    }

    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap) {
        return this.appService.findAppListByCondition(queryMap);
    }

    public Integer findAppListCount(Map<String, Object> queryMap) {
        return this.appService.findAppListCount(queryMap);
    }

    public AppDO findFristAppByDeveloperId(Long developerId) {
        return this.appService.findFristAppByDeveloperId(developerId);
    }

    public List<AppManageVO> findByAppIds(List<Long> appIds) {
        return this.appService.findByAppIds(appIds);
    }

    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList) {
        return this.appService.selectAppDeveloper(appIdList);
    }

    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize) {
        return this.appService.selectAllAppDeveloper(start, pageSize);
    }

    public HashMap<String, Object> selectOneAppDeveloper(Long appId) {
        return this.appService.selectOneAppDeveloper(appId);
    }

    public List<Long> selectAppIdByName(String appName) {
        return this.appService.selectAppIdByName(appName);
    }

    public List<Long> selectAppIdByEmail(String email) {
        return this.appService.selectAppIdByEmail(email);
    }

    public List<Long> selectAppIdByEmailAndName(String email, String appName) {
        return this.appService.selectAppIdByEmailAndName(email, appName);
    }

    public Integer countApp() {
        return this.appService.countApp();
    }

    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList) {
        return this.appService.selectAppDeveloperByAppId(appIdList);
    }

    public boolean updateForDeveloperBack(Long appId, Double dayBudget, Double monthBudget, Double auditPricePerConsumer) {
        return this.appService.updateForDeveloperBack(appId, dayBudget, monthBudget, auditPricePerConsumer);
    }

    public static void main(String[] args) {
        System.out.println(BlowfishUtils.encryptBlowfish((String)"{\"time\":1461136700404,\"aid\":12}", (String)"joadfjdsjoadfjds"));
    }
}

