/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.AppLayoutBrickDao;
import cn.com.duiba.service.domain.dataobject.AppLayoutBrickDO;
import cn.com.duiba.service.service.AppLayoutBrickService;
import cn.com.duiba.wolf.cache.CacheClient;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppLayoutBrickServiceImpl
implements AppLayoutBrickService {
    @Resource
    private AppLayoutBrickDao appLayoutBrickDao;
    @Resource
    private CacheClient cacheClient;

    private String getSimpleCacheKeyById(Long id) {
        return "chaos.keyAppLayoutSimpleById_" + id;
    }

    private String getContentCacheKeyById(Long id) {
        return "chaos.keyAppLayoutContentById_" + id;
    }

    @Override
    @Deprecated
    public AppLayoutBrickDO find(Long id) {
        return this.appLayoutBrickDao.find(id);
    }

    @Override
    public AppLayoutBrickDO findWithSimple(Long id) {
        String key = this.getSimpleCacheKeyById(id);
        AppLayoutBrickDO d = (AppLayoutBrickDO)this.cacheClient.get(key);
        if (d == null) {
            d = this.appLayoutBrickDao.findWithSimple(id);
            this.cacheClient.set(key, (Object)d, 10, TimeUnit.MINUTES);
        }
        return d;
    }

    @Override
    public int insert(AppLayoutBrickDO appLayoutBrick) {
        return this.appLayoutBrickDao.insert(appLayoutBrick);
    }

    @Override
    public List<AppLayoutBrickDO> findAllShowSystemBrickWithSimple() {
        return this.appLayoutBrickDao.findAllShowSystemBrickWithSimple();
    }

    @Override
    public List<AppLayoutBrickDO> findDingzhiThemeWithSimple(Long appId) {
        return this.appLayoutBrickDao.findDingzhiThemeWithSimple(appId);
    }

    @Override
    public String getBrickContentById(Long brickId) {
        String content = (String)this.cacheClient.get(this.getContentCacheKeyById(brickId));
        if (content == null) {
            content = this.appLayoutBrickDao.getBrickContentById(brickId);
            this.cacheClient.set(this.getContentCacheKeyById(brickId), (Object)content, 1, TimeUnit.HOURS);
        }
        return content;
    }

    @Override
    public List<AppLayoutBrickDO> getAllSystemLayoutBrickWithSimple(Map<String, Object> params) {
        return this.appLayoutBrickDao.getAllSystemLayoutBrickWithSimple(params);
    }

    @Override
    public Long getAllSystemLayoutCount() {
        return this.appLayoutBrickDao.getAllSystemLayoutCount();
    }

    @Override
    public List<AppLayoutBrickDO> getCustomLayoutBrickWithSimple(Map<String, Object> params) {
        return this.appLayoutBrickDao.getCustomLayoutBrickWithSimple(params);
    }

    @Override
    public Long getCustomLayoutCount(Long appId) {
        return this.appLayoutBrickDao.getCustomLayoutCount(appId);
    }

    @Override
    public int updateLayoutBrickPayload(Optional<Long> id, Optional<Integer> payload) {
        int ret = this.appLayoutBrickDao.updateLayoutBrickPayload(id, payload);
        this.cacheClient.remove(this.getSimpleCacheKeyById((Long)id.get()));
        return ret;
    }

    @Override
    public int updateLayoutBrickShowStatus(Optional<Long> id, Optional<Integer> status) {
        int ret = this.appLayoutBrickDao.updateLayoutBrickShowStatus(id, status);
        this.cacheClient.remove(this.getSimpleCacheKeyById((Long)id.get()));
        return ret;
    }

    @Override
    public int updateBrick(AppLayoutBrickDO brick) {
        int ret = this.appLayoutBrickDao.updateBrick(brick);
        this.cacheClient.remove(this.getSimpleCacheKeyById(brick.getId()));
        this.cacheClient.remove(this.getContentCacheKeyById(brick.getId()));
        return ret;
    }

    @Override
    public int updateBrickDelete(Optional<Long> id) {
        int ret = this.appLayoutBrickDao.updateBrickDelete(id);
        this.cacheClient.remove(this.getSimpleCacheKeyById((Long)id.get()));
        return ret;
    }
}

