/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.AppManualLotteryDao;
import cn.com.duiba.service.domain.dataobject.AppManualLotteryDO;
import cn.com.duiba.service.service.AppManualLotteryService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppManualLotteryServiceImpl
implements AppManualLotteryService {
    @Resource
    private AppManualLotteryDao appManualLotteryDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "chaos.appManualLotteryById_" + id;
    }

    @Override
    public List<AppManualLotteryDO> scanOverManualLottery() {
        return this.appManualLotteryDao.scanOverManualLottery();
    }

    @Override
    public void updateManualLottery(AppManualLotteryDO appManualLottery) {
        this.appManualLotteryDao.updateManualLottery(appManualLottery);
        this.cacheClient.remove(this.getCacheKeyById(appManualLottery.getId()));
    }

    @Override
    public void insert(AppManualLotteryDO appManualLotteryDO) {
        this.appManualLotteryDao.insert(appManualLotteryDO);
    }

    @Override
    public void update(AppManualLotteryDO appManualLotteryDO) {
        this.appManualLotteryDao.update(appManualLotteryDO);
        this.cacheClient.remove(this.getCacheKeyById(appManualLotteryDO.getId()));
    }

    @Override
    public AppManualLotteryDO find(Long id) {
        String key = this.getCacheKeyById(id);
        AppManualLotteryDO d = (AppManualLotteryDO)this.cacheClient.get(key);
        if (d == null) {
            d = this.appManualLotteryDao.find(id);
            this.cacheClient.set(key, (Object)d, 1, TimeUnit.HOURS);
        }
        return d;
    }
}

