/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.ConsumerFootprintDao;
import cn.com.duiba.service.domain.dataobject.ConsumerFootprintDO;
import cn.com.duiba.service.service.ConsumerFootPrintService;
import cn.com.duiba.wolf.cache.CacheClient;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ConsumerFootPrintServiceImpl
implements ConsumerFootPrintService {
    @Resource
    private ConsumerFootprintDao consumerFootprintDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyByConsumerId(Long consumerId) {
        return "chaos.consumerFootprintByCconsumerid_" + consumerId;
    }

    @Override
    public ConsumerFootprintDO findByConsumerId(Long consumerId) {
        String key = this.getCacheKeyByConsumerId(consumerId);
        ConsumerFootprintDO footprintDO = (ConsumerFootprintDO)this.cacheClient.get(key);
        if (footprintDO == null) {
            footprintDO = this.consumerFootprintDao.findByConsumerId(consumerId);
            this.cacheClient.set(key, (Object)footprintDO, 300);
        }
        return footprintDO;
    }

    @Override
    public ConsumerFootprintDO findByColumnAndConsumerId(Long consumerId, String column) {
        return this.consumerFootprintDao.findByColumnAndConsumerId(consumerId, column);
    }

    @Override
    public Integer updateByConsumerId(ConsumerFootprintDO consumerFootprintDO) {
        Integer updateCount = this.consumerFootprintDao.updateByConsumerId(consumerFootprintDO);
        this.cacheClient.remove(this.getCacheKeyByConsumerId(consumerFootprintDO.getConsumerId()));
        return updateCount;
    }

    @Override
    public void insert(ConsumerFootprintDO consumerFootprintDO) {
        this.consumerFootprintDao.insert(consumerFootprintDO);
    }

    @Override
    public Integer update(ConsumerFootprintDO consumerFootprintDO) {
        Integer updateCount = this.consumerFootprintDao.update(consumerFootprintDO);
        this.cacheClient.remove(this.getCacheKeyByConsumerId(consumerFootprintDO.getConsumerId()));
        return updateCount;
    }
}

