/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.AppDao;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.OrdersDO;
import cn.com.duiba.service.domain.vo.AppDeveloperVO;
import cn.com.duiba.service.domain.vo.AppManageVO;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.service.AppService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.DateUtils;
import com.google.common.base.Optional;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppServiceImpl
implements AppService {
    @Resource
    private AppDao appDao;
    @Resource
    private CacheClient memcachedClient;

    private String getAppIdKey(Long id) {
        return "chaos.key_appId_" + id;
    }

    private void removeCacheById(Long id) {
        this.memcachedClient.remove(this.getAppIdKey(id));
    }

    @Override
    public List<AppDO> findByIds(List<Long> ids) {
        return this.appDao.findByIds(ids);
    }

    @Override
    public List<Long> selectAppIdByName(String appName) {
        return this.appDao.selectAppIdByName(appName);
    }

    @Override
    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize) {
        return this.appDao.selectAllAppDeveloper(start, pageSize);
    }

    @Override
    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap) {
        return this.appDao.findAppListByCondition(queryMap);
    }

    @Override
    public int updateSwitch(Long id, Integer appSwitch) {
        int ret = this.appDao.updateSwitch(id, appSwitch);
        this.removeCacheById(id);
        return ret;
    }

    @Override
    public void updateForDeveloperBack(AppDO app) {
        this.appDao.updateForDeveloperBack(app);
        this.removeCacheById(app.getId());
    }

    @Override
    public AppDO findByAppKey(String appKey) {
        return this.appDao.findByAppKey(appKey);
    }

    @Override
    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId) {
        return this.appDao.getAutoRecommandAppIdListByItemId(itemId);
    }

    @Override
    public Integer countApp() {
        return this.appDao.countApp();
    }

    @Override
    public List<Long> selectAppIdByEmail(String email) {
        return this.appDao.selectAppIdByEmail(email);
    }

    @Override
    public List<Long> selectAppIdByEmailAndName(String email, String appName) {
        return this.appDao.selectAppIdByEmailAndName(email, appName);
    }

    @Override
    public AppDO findForUpdate(Long id) {
        return this.appDao.findForUpdate(id);
    }

    @Override
    public int update(AppDO app) {
        int ret = this.appDao.update(app);
        this.removeCacheById(app.getId());
        return ret;
    }

    @Override
    public List<AppDO> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds) {
        return this.appDao.findAllBySpecifyAndBlack(specifyAppIds, blackAppIds);
    }

    @Override
    public Integer countItemAutoRecommandApp(Long itemId) {
        return this.appDao.countItemAutoRecommandApp(itemId);
    }

    @Override
    public AppDO find(Long id) {
        AppDO a = (AppDO)this.memcachedClient.get(this.getAppIdKey(id));
        if (a == null) {
            a = this.appDao.find(id);
            this.memcachedClient.set(this.getAppIdKey(id), (Object)a, 300);
        }
        return a;
    }

    @Override
    public AppDO findFristAppByDeveloperId(Long developerId) {
        String key = "chaos.firstAppOfDevId_" + developerId;
        AppDO firstApp = (AppDO)this.memcachedClient.get(key);
        if (firstApp == null) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("developerId", developerId);
            firstApp = this.appDao.findFristAppByDeveloperId(developerId);
            this.memcachedClient.set(key, (Object)firstApp, 1, TimeUnit.HOURS);
        }
        return firstApp;
    }

    @Override
    public List<AppDO> findAllByDeveloperIds(List<Long> developerIds) {
        return this.appDao.findAllByDeveloperIds(developerIds);
    }

    @Override
    public void insert(AppDO app) {
        this.appDao.insert(app);
    }

    @Override
    public Integer findAppListCount(Map<String, Object> queryMap) {
        return this.appDao.findAppListCount(queryMap);
    }

    @Override
    public List<AppManageVO> findByAppIds(List<Long> appIds) {
        return this.appDao.findByAppIds(appIds);
    }

    @Override
    public HashMap<String, Object> selectOneAppDeveloper(Long appId) {
        return this.appDao.selectOneAppDeveloper(appId);
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList) {
        return this.appDao.selectAppDeveloper(appIdList);
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList) {
        return this.appDao.selectAppDeveloperByAppId(appIdList);
    }

    @Override
    public void clearMonthBudget(Long appId) {
        this.appDao.clearMonthBudget(appId);
        this.removeCacheById(appId);
    }

    @Override
    public List<AppDO> findAllByDeveloper(Long developerId) {
        return this.appDao.findAllByDeveloper(developerId);
    }

    @Override
    public List<AppDO> findAppNameByNameLike(String appName) {
        return this.appDao.findAppNameByNameLike(appName);
    }

    @Override
    public void cleanDayBudget(Long appId) {
        this.appDao.cleanDayBudget(appId);
        this.removeCacheById(appId);
    }

    @Override
    public List<AppDO> findAll() {
        return this.appDao.findAll();
    }

    @Override
    public List<Long> findAllEnable() {
        return this.appDao.findAllEnable();
    }

    @Override
    public boolean updateForDeveloperBack(Long appId, Double dayBudget, Double monthBudget, Double auditPricePerConsumer) {
        AppDO app = this.appDao.find(appId);
        BigDecimal dayBudgetBD = null;
        Integer dayBudgetInt = null;
        if (dayBudget != null) {
            dayBudgetBD = new BigDecimal(dayBudget);
            dayBudgetInt = dayBudgetBD.divide(BigDecimal.ONE, 2, 4).multiply(new BigDecimal(100.0)).intValue();
            if (!dayBudgetInt.equals(app.getDayBudget())) {
                Integer remain = dayBudgetInt - (app.getDayBudget() == null ? 0 : app.getDayBudget()) + (app.getDayBudgetRemain() == null ? 0 : app.getDayBudgetRemain());
                app.setDayBudgetRemain(Integer.valueOf(remain < 0 ? 0 : remain));
                app.setDayBudget(dayBudgetInt);
            }
        } else {
            app.setDayBudgetRemain(null);
            app.setDayBudget(null);
        }
        BigDecimal monthBudgetBD = null;
        Integer monthBudgetInt = null;
        if (monthBudget != null) {
            monthBudgetBD = new BigDecimal(monthBudget);
            monthBudgetInt = monthBudgetBD.divide(BigDecimal.ONE, 2, 4).multiply(new BigDecimal(100.0)).intValue();
            if (!monthBudgetInt.equals(app.getBudget())) {
                Integer remain = monthBudgetInt - (app.getBudget() == null ? 0 : app.getBudget()) + (app.getBudgetRemain() == null ? 0 : app.getBudgetRemain());
                app.setBudgetRemain(Integer.valueOf(remain < 0 ? 0 : remain));
                app.setBudget(monthBudgetInt);
            }
        } else {
            app.setBudgetRemain(null);
            app.setBudget(null);
        }
        BigDecimal auditPricePerConsumerBD = new BigDecimal(auditPricePerConsumer == null ? 0.0 : auditPricePerConsumer);
        app.setAuditPricePerConsumer(Integer.valueOf(auditPricePerConsumerBD.divide(BigDecimal.ONE, 2, 4).multiply(new BigDecimal(100.0)).intValue()));
        this.updateForDeveloperBack(app);
        return true;
    }

    @Override
    @Deprecated
    public int updateAppColor(Optional<AppDO> app, Optional<String> color) {
        int ret = this.appDao.updateAppColor(app, color);
        this.removeCacheById(((AppDO)app.get()).getId());
        return ret;
    }

    @Override
    @Transactional(value="credits")
    public void deductBudget(Long appId, Integer actualPrice) throws StatusException {
        if (actualPrice > 0) {
            int rt;
            int ret;
            AppDO capp = this.appDao.find(appId);
            if (capp.getDayBudget() != null && (ret = this.appDao.deductBudgetDay(appId, actualPrice)) == 0) {
                throw new StatusException(4);
            }
            if (capp.getBudget() != null && (rt = this.appDao.deductBudgetMonth(appId, actualPrice)) == 0) {
                throw new StatusException(3);
            }
        }
        this.removeCacheById(appId);
    }

    @Override
    @Transactional(value="credits")
    public void restoreBudget(OrdersDO order) {
        if (order.getActualPrice() <= 0) {
            return;
        }
        if (order.getGmtCreate() == null) {
            return;
        }
        Date today = new Date();
        String todayStr = DateUtils.getDayStr((Date)today);
        String gmtCreateStr = DateUtils.getDayStr((Date)order.getGmtCreate());
        AppDO capp = this.appDao.find(order.getAppId());
        if (!todayStr.equals(gmtCreateStr)) {
            return;
        }
        if (capp.getDayBudget() != null) {
            this.appDao.restoreDayBudget(order.getAppId(), order.getActualPrice());
        }
        if (!todayStr.substring(0, 7).equals(gmtCreateStr.substring(0, 7))) {
            return;
        }
        if (capp.getBudget() != null) {
            this.appDao.restoreMonthBudget(order.getAppId(), order.getActualPrice());
        }
        this.removeCacheById(order.getAppId());
    }
}

