/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.app.AppExtraDao;
import cn.com.duiba.service.domain.dataobject.AppExtraDO;
import cn.com.duiba.service.service.AppExtraService;
import cn.com.duiba.wolf.cache.CacheClient;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppExtraServiceImpl
implements AppExtraService {
    @Resource
    private AppExtraDao appExtraDao;
    @Resource
    private CacheClient cacheClient;

    private String getSimpleCacheKeyByAppId(Long appId) {
        return "chaos.keyAppExtraSimpleByAppId_" + appId;
    }

    private String getProgramCacheKeyByAppId(Long appId) {
        return "chaos.keyAppExtraProgramByAppId_" + appId;
    }

    @Override
    public AppExtraDO findByAppId(Long appId) {
        String key = this.getSimpleCacheKeyByAppId(appId);
        AppExtraDO d = (AppExtraDO)this.cacheClient.get(key);
        if (d == null) {
            d = this.appExtraDao.findByAppId(appId);
            this.cacheClient.set(key, (Object)d, 300);
        }
        return d;
    }

    @Override
    public AppExtraDO findByAppIdIfNullAutoCreate(Long appId) {
        AppExtraDO appExtra = this.findByAppId(appId);
        if (appExtra == null) {
            appExtra = new AppExtraDO(true);
            appExtra.setAppId(appId);
            this.insert(appExtra);
            appExtra = this.findByAppId(appId);
        }
        return appExtra;
    }

    @Override
    public void insert(AppExtraDO appExtraDO) {
        this.appExtraDao.insert(appExtraDO);
    }

    @Override
    public AppExtraDO find(Long id) {
        return this.appExtraDao.find(id);
    }

    @Override
    public Integer update(AppExtraDO appExtraDO) {
        AppExtraDO d;
        Long appId = appExtraDO.getAppId();
        if (appId == null && (d = this.find(appExtraDO.getId())) != null) {
            appId = d.getAppId();
        }
        Integer ret = this.appExtraDao.update(appExtraDO);
        this.cacheClient.remove(this.getSimpleCacheKeyByAppId(appId));
        return ret;
    }

    @Override
    public void insertAppConfig(AppExtraDO appExtraDO) {
        this.appExtraDao.insertAppConfig(appExtraDO);
    }

    @Override
    public Integer updateAppConfig(Long appId, String entranceDesc, String callLoginProgram) {
        Integer ret = this.appExtraDao.updateAppConfig(appId, entranceDesc, callLoginProgram);
        this.cacheClient.remove(this.getSimpleCacheKeyByAppId(appId));
        this.cacheClient.remove(this.getProgramCacheKeyByAppId(appId));
        return ret;
    }

    @Override
    public String findCallLoginProgramByAppId(Long appId) {
        String key = this.getProgramCacheKeyByAppId(appId);
        String ret = (String)this.cacheClient.get(key);
        if (ret == null) {
            ret = this.appExtraDao.findCallLoginProgramByAppId(appId);
            this.cacheClient.set(key, (Object)ret, 300);
        }
        return ret;
    }
}

