/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.dao.consumer.impl;

import cn.com.duiba.service.dao.BaseShardDao;
import cn.com.duiba.service.dao.DatabaseSchema;
import cn.com.duiba.service.dao.consumer.ConsumerDao;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class ConsumerDaoImpl
extends BaseShardDao
implements ConsumerDao {
    @Override
    public ConsumerDO find(Long consumerId) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        ConsumerDO c = (ConsumerDO)this.selectOne("find", paramMap);
        return c;
    }

    @Override
    @Deprecated
    public List<ConsumerDO> findAllByIds(List<Long> ids) {
        ArrayList<ConsumerDO> result = new ArrayList<ConsumerDO>();
        for (Long id : ids) {
            ConsumerDO c = this.find(id);
            if (c == null) continue;
            result.add(c);
        }
        return result;
    }

    @Override
    public ConsumerDO findByAppAndPartnerUserId(Long appId, String partnerUserId) {
        Long cid = this.findInMapByAppAndPartnerUserId(appId, partnerUserId);
        if (cid == null) {
            return null;
        }
        return this.find(cid);
    }

    private Long findInMapByAppAndPartnerUserId(Long appId, String partnerUserId) {
        Map<String, Object> paramMap = this.getTbMapConsumer1024SuffixParamsMap(appId);
        paramMap.put("appId", appId);
        paramMap.put("partnerUserId", partnerUserId);
        Long cid = (Long)this.selectOne("findByAppAndPartnerUserId", paramMap);
        return cid;
    }

    private long makeConsumerSequence() {
        HashMap params = new HashMap();
        this.insert("makeConsumerSequence", params);
        return Long.valueOf(params.get("id").toString());
    }

    private void insertMapConsume(long consumeId, long appid, String partnerUserId) {
        Map<String, Object> paramMap = this.getTbMapConsumer1024SuffixParamsMap(appid);
        paramMap.put("consumer_id", consumeId);
        paramMap.put("app_id", appid);
        paramMap.put("partner_user_id", partnerUserId);
        this.insert("insertMapConsume", paramMap);
    }

    @Override
    public ConsumerDO insert(ConsumerDO consumer) {
        if (consumer.getId() == null) {
            consumer.setId(Long.valueOf(this.makeConsumerSequence()));
        }
        Map<String, Object> map = this.getConsumerTbSuffixParamsMap(consumer.getId());
        consumer.setTb_suffix(String.valueOf(map.get("tb_suffix")));
        this.insert("insert", consumer);
        this.insertMapConsume(consumer.getId(), consumer.getAppId(), consumer.getPartnerUserId());
        return consumer;
    }

    @Override
    public int updateCredits(Long consumerId, Long credits) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("id", consumerId);
        paramMap.put("credits", credits);
        int ret = this.update("updateCredits", paramMap);
        return ret;
    }

    @Override
    public int increaseCredits(Long consumerId, Long credits) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("credits", credits);
        int ret = this.update("increaseCredits", paramMap);
        return ret;
    }

    @Override
    public int decrementCredits(Long consumerId, Long credits) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("credits", credits);
        int ret = this.update("decrementCredits", paramMap);
        return ret;
    }

    @Override
    public int updateAutologinParams(Long consumerId, Long credits, String alipay, String qq, String phone, Integer vipLevel) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("credits", credits);
        paramMap.put("alipay", alipay);
        paramMap.put("qq", qq);
        paramMap.put("phone", phone);
        if (vipLevel == null) {
            vipLevel = 0;
        }
        paramMap.put("vipLevel", vipLevel);
        int ret = this.update("updateAutologinParams", paramMap);
        return ret;
    }

    @Override
    public int updateUnreadCount(Long consumerId, int count) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("count", count);
        int ret = this.update("updateUnreadCount", paramMap);
        return ret;
    }

    @Override
    public int updateLastAlipay(Long consumerId, String lastAlipay, String lastRealname) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("lastAlipay", lastAlipay);
        paramMap.put("lastRealname", lastRealname);
        int ret = this.update("updateLastAlipay", paramMap);
        return ret;
    }

    @Override
    public int updateAddress(Long consumerId, String addrName, String addrProvince, String addrCity, String addrArea, String addrDetail, String addrPhone) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("addrName", addrName);
        paramMap.put("addrProvince", addrProvince);
        paramMap.put("addrCity", addrCity);
        paramMap.put("addrArea", addrArea);
        paramMap.put("addrDetail", addrDetail);
        paramMap.put("addrPhone", addrPhone);
        int ret = this.update("updateAddress", paramMap);
        return ret;
    }

    @Override
    public int updateLastPhone(Long consumerId, String lastPhone) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("lastPhone", lastPhone);
        int ret = this.update("updateLastPhone", paramMap);
        return ret;
    }

    @Override
    public int updateLastQq(Long consumerId, String lastQq) {
        Map<String, Object> paramMap = this.getConsumerTbSuffixParamsMap(consumerId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("lastQq", lastQq);
        int ret = this.update("updateLastQq", paramMap);
        return ret;
    }

    private Map<String, Object> getConsumerTbSuffixParamsMap(Long id) {
        Long tbLong = id / 10000000L;
        int tbInt = tbLong.intValue();
        String tb = String.valueOf(tbInt);
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tb_suffix", tb);
        return params;
    }

    private Map<String, Object> getTbMapConsumer1024SuffixParamsMap(Long appId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tb_suffix", this.getTableMapConsumerSuffix(appId));
        return params;
    }

    private String getTableMapConsumerSuffix(Long appId) {
        int tbInt = appId.intValue() % 1024;
        if (tbInt < 0) {
            tbInt = -tbInt;
        }
        String tb = String.valueOf(tbInt);
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }
        return tb;
    }

    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CONSUMER;
    }
}

