/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.developer.HdtoolSkinDataDao;
import cn.com.duiba.service.domain.biz.HdtoolSkinEntity;
import cn.com.duiba.service.domain.dto.HdtoolSkinDataDto;
import cn.com.duiba.service.service.HdtoolSkinDataService;
import cn.com.duiba.wolf.cache.CacheClient;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class HdtoolSkinDataServiceImpl
implements HdtoolSkinDataService {
    @Resource
    private HdtoolSkinDataDao hdtoolSkinDataDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public void createHdtoolSkinData(HdtoolSkinEntity hdtoolSkinEntity) {
        if (hdtoolSkinEntity == null) {
            return;
        }
        this.hdtoolSkinDataDao.insert(hdtoolSkinEntity);
    }

    @Override
    public int updateHdtoolSkinData(Long hdtoolId, String type, String dataJson) {
        int ret = this.hdtoolSkinDataDao.updateDataJson(hdtoolId, type, dataJson);
        if (ret == 1) {
            this.removeHdtoolSkinCache(hdtoolId, type);
        }
        return ret;
    }

    @Override
    public HdtoolSkinDataDto queryBaseHdtoolSkin(Long hdtoolId, String type) {
        return this.hdtoolSkinDataDao.selectByHdtoolIdAndType(hdtoolId, type);
    }

    @Override
    public String querySkin(Long hdtoolId, String type) {
        String skin = null;
        if (StringUtils.isBlank(skin)) {
            skin = this.hdtoolSkinDataDao.selectJsonByHdtoolIdAndType(hdtoolId, type);
        }
        return skin;
    }

    public void removeHdtoolSkinCache(Long hdtoolId, String type) {
        this.memcachedClient.remove(this.getSkinCacheKey(hdtoolId, type));
    }

    public void setHdtoolSkinCache(Long hdtoolId, String type, String json) {
        this.memcachedClient.set(this.getSkinCacheKey(hdtoolId, type), (Object)json, 3600);
    }

    public String getHdtoolSkin(Long hdtoolId, String type) {
        return (String)this.memcachedClient.get(this.getSkinCacheKey(hdtoolId, type));
    }

    public String getSkinCacheKey(Long hdtoolId, String type) {
        return "chaos.keyHdtoolSkinCacheKeyId_" + hdtoolId + "_" + type;
    }
}

