/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.developer.HdtoolDefaultSkinDataDao;
import cn.com.duiba.service.domain.biz.HdtoolSkinDefaultEntity;
import cn.com.duiba.service.domain.dto.HdtoolSkinDefaultDataDto;
import cn.com.duiba.service.service.HdtoolSkinDefaultDataSerivce;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class HdtoolSkinDefaultDataServiceImpl
implements HdtoolSkinDefaultDataSerivce {
    @Resource
    private HdtoolDefaultSkinDataDao hdtoolDefaultSkinDataDao;
    @Resource
    private CacheClient memcachedClient;

    @Override
    public void createHdtoolDefaultSkin(HdtoolSkinDefaultEntity hdtoolSkinDefaultEntity) {
        if (hdtoolSkinDefaultEntity == null) {
            return;
        }
        this.hdtoolDefaultSkinDataDao.insert(hdtoolSkinDefaultEntity);
    }

    @Override
    public int updateHdtoolDefaultSkin(HdtoolSkinDefaultEntity hdtoolSkinDefaultEntity) {
        int ret = this.hdtoolDefaultSkinDataDao.updateData(hdtoolSkinDefaultEntity);
        if (ret == 1) {
            this.removeHdtoolSkinCache(hdtoolSkinDefaultEntity.getTemplateType(), hdtoolSkinDefaultEntity.getType());
        }
        return ret;
    }

    @Override
    public HdtoolSkinDefaultDataDto queryHdtoolBaseSkin(String templateType, String type) {
        return this.hdtoolDefaultSkinDataDao.selectBaseHdtoolData(templateType, type);
    }

    @Override
    public HdtoolSkinDefaultDataDto queryHdtoolDefaultConfig(String templateType, String type) {
        String defaultConfig = null;
        if (StringUtils.isBlank(defaultConfig)) {
            HdtoolSkinDefaultDataDto skin = this.hdtoolDefaultSkinDataDao.selectConfigAndStyleData(templateType, type);
            if (skin != null) {
                return skin;
            }
        } else {
            String[] ct = StringUtils.split(defaultConfig, (String)"@");
            if (ct.length == 2) {
                HdtoolSkinDefaultDataDto skin = new HdtoolSkinDefaultDataDto();
                skin.setTemplateType(templateType);
                skin.setType(type);
                skin.setDataConfig(ct[0]);
                skin.setDataStyle(ct[1]);
                return skin;
            }
        }
        return null;
    }

    public void removeHdtoolSkinCache(String templateType, String type) {
        this.memcachedClient.remove(this.getSkinCacheKey(templateType, type));
    }

    public void setHdtoolSkinCache(String templateType, String type, String dataConfig, String dataStyle) {
        this.memcachedClient.set(this.getSkinCacheKey(templateType, type), (Object)(String.valueOf(dataConfig) + "@" + dataStyle), 3600);
    }

    public String getHdtoolDefaultSkin(String templateType, String type) {
        return (String)this.memcachedClient.get(this.getSkinCacheKey(templateType, type));
    }

    public String getSkinCacheKey(String templateType, String type) {
        return "chaos.keyHdtoolDefaultSkinCacheKeyId_" + templateType + "_" + type;
    }

    @Override
    public List<HdtoolSkinDefaultDataDto> queryListPagnation(Integer offset, Integer max) {
        return this.hdtoolDefaultSkinDataDao.selectAllByPagination(offset, max);
    }

    @Override
    public Integer queryListCount() {
        return this.hdtoolDefaultSkinDataDao.selectAllByPaginationCount();
    }
}

