package cn.com.duiba.service.demo.api.bean;

import com.google.common.base.Preconditions;

import java.io.Serializable;

/**
 * 分页请求
 */
public class PagerRequest implements Serializable {

    private static final long serialVersionUID = 6978259860952317764L;

    /**
     * 当前页索引号。从1开始计数
     */
    private Integer           pageIndex;
    /**
     * 页面页码
     */
    private Integer           pageSize;

    public PagerRequest() {
        super();
    }

    public PagerRequest(Integer pageIndex, Integer pageSize) {
        super();
        Preconditions.checkArgument(null != pageIndex && pageIndex > 0, "pageIndex无效");
        Preconditions.checkArgument(null != pageSize && pageSize > 0, "pageSize无效");

        if (pageIndex <= 0) {
            pageIndex = 1;
        }
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
    }

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        Preconditions.checkArgument(null != pageIndex && pageIndex > 0, "pageIndex无效");
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        Preconditions.checkArgument(null != pageSize && pageSize > 0, "pageSize无效");
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        //如果页索引或页大小为空，则返回为null
        if (null == this.pageIndex || null == this.pageSize) {
            return null;
        }
        return (this.pageIndex - 1) * this.pageSize;
    }
}
