package cn.com.duiba.service.demo.api.bean;

import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 分页响应
 *
 * @param <T>
 */
public class PagerResponse<T> implements Serializable {

    private static final long serialVersionUID = -7987046099215712314L;

    /**
     * 总记录数
     */
    private Integer totalRecords;
    /**
     * 当前页索引
     */
    private Integer pageIndex;
    /**
     * 页大小
     */
    private Integer pageSize;
    /**
     * 当前页记录
     */
    private List<T> records;

    public PagerResponse() {
        super();
    }

    public PagerResponse(PagerRequest pagerRequest, Integer totalRecords, List<T> records) {
        super();
        this.pageIndex = pagerRequest.getPageIndex();
        this.pageSize = pagerRequest.getPageSize();
        this.totalRecords = totalRecords;
        this.records = records;
    }

    public PagerResponse(PagerResponse<?> pagerResponse, List<T> records) {
        super();
        BeanUtils.copyProperties(pagerResponse, this, "records");
        this.records = records;
    }

    public Integer getTotalRecords() {
        return totalRecords;
    }

    public void setTotalRecords(Integer totalRecords) {
        this.totalRecords = totalRecords;
    }

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<T> getRecords() {
        return records;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

}
