/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.CouponBatchService;
import cn.com.duiba.service.item.service.CouponFlowInnerService;
import cn.com.duiba.service.item.service.CouponFlowService;
import cn.com.duiba.service.item.service.CouponService;
import cn.com.duiba.service.item.service.ItemKeyService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="couponFlowService")
public class CouponFlowServiceImpl
implements CouponFlowService {
    private static Logger log = LoggerFactory.getLogger(CouponFlowServiceImpl.class);
    @Autowired
    private CouponFlowInnerService couponFlowInnerService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private CouponService couponService;
    @Autowired
    private CouponBatchService couponBatchService;
    @Autowired
    private ItemKeyService itemKeyService;

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CouponDO getOneCoupon(ItemKey itemKey) throws StatusException {
        this.couponFlowInnerService.checkCouponBatch(itemKey);
        Long batchId = null;
        AppItemDO appItem = itemKey.getAppItem();
        ItemDO item = itemKey.getItem();
        if (itemKey.isSelfAppItemMode()) {
            appItem = this.appItemService.findForUpdate(itemKey.getAppItem().getId());
            batchId = appItem.getBatchId();
        } else if (itemKey.isDuibaAppItemMode() || itemKey.isItemMode()) {
            item = this.itemService.findForUpdate(itemKey.getItem().getId());
            batchId = item.getBatchId();
        }
        if (batchId == null) {
            throw new StatusException(0, "\u5151\u6362\u52b5\u5df2\u7ecf\u7528\u5b8c");
        }
        itemKey = this.itemKeyService.getItemKey(item, appItem, itemKey.getApp());
        CouponBatchDO batch = this.couponBatchService.findForUpdate(batchId);
        if (batch == null) {
            throw new StatusException(0, "\u5151\u6362\u52b5\u5df2\u7ecf\u7528\u5b8c");
        }
        if (batch.getRemaining() <= 0) {
            throw new StatusException(0, "\u5151\u6362\u52b5\u5df2\u7ecf\u7528\u5b8c");
        }
        if (batch.getValidEndDate().before(new Date())) {
            this.couponFlowInnerService.switchBatch(itemKey);
            this.couponFlowInnerService.refreshItemKeyCoupon(itemKey);
            return null;
        }
        CouponDO coupon = this.couponService.getOneCouponByBatch(batch.getId());
        if (coupon != null) {
            int couponRet = this.couponService.lockCoupon(coupon.getId());
            if (couponRet < 1) {
                throw new StatusException(0, "\u5151\u6362\u52b5\u5df2\u7ecf\u7528\u5b8c");
            }
            this.couponBatchService.reduceCouponBatchRemaining(batch.getId());
            if (coupon.getItemId() != null) {
                this.itemService.reduceRemaining(coupon.getItemId());
            } else if (coupon.getAppItemId() != null && coupon.getItemId() == null) {
                this.appItemService.reduceRemaining(coupon.getAppItemId());
            }
        }
        this.couponFlowInnerService.switchBatch(itemKey);
        this.couponFlowInnerService.refreshItemKeyCoupon(itemKey);
        return coupon;
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void returnOneCoupon(long couponId) throws StatusException {
        CouponDO coupon = this.couponService.find(couponId);
        if (!coupon.getLocked().booleanValue()) {
            return;
        }
        if (coupon.getItemId() != null) {
            this.itemService.findForUpdate(coupon.getItemId());
        } else if (coupon.getAppItemId() != null) {
            this.appItemService.findForUpdate(coupon.getAppItemId());
        }
        CouponBatchDO couponBatch = this.couponBatchService.findForUpdate(coupon.getBatchId());
        int ret = this.couponService.unlockCoupon(couponId);
        if (ret < 1) {
            throw new StatusException(0, "\u5151\u6362\u52b5\u89e3\u9501\u5931\u8d25");
        }
        this.couponFlowInnerService.refreshBatch(couponBatch);
        if (coupon.getItemId() != null) {
            this.couponFlowInnerService.switchItemBatch(coupon.getItemId());
            this.couponFlowInnerService.refreshItemCoupon(coupon.getItemId());
        } else if (coupon.getAppItemId() != null) {
            this.couponFlowInnerService.switchAppItemBatch(coupon.getAppItemId());
            this.couponFlowInnerService.refreshAppItemCoupon(coupon.getAppItemId());
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void deleteCouponBatch(long batchId) {
        CouponBatchDO batch = this.couponBatchService.find(batchId);
        if (batch.getItemId() != null) {
            this.itemService.findForUpdate(batch.getItemId());
        } else if (batch.getAppItemId() != null) {
            this.appItemService.findForUpdate(batch.getAppItemId());
        }
        batch = this.couponBatchService.findForUpdate(batchId);
        if (batch != null && !batch.getActive().equals(4)) {
            this.couponService.deleteByBatchId(batchId);
            if (batch.getItemId() != null) {
                this.couponFlowInnerService.refreshBatch(batch);
                this.couponFlowInnerService.switchItemBatch(batch.getItemId());
                this.couponFlowInnerService.refreshItemCoupon(batch.getItemId());
            } else if (batch.getAppItemId() != null && batch.getItemId() == null) {
                this.couponFlowInnerService.refreshBatch(batch);
                this.couponFlowInnerService.switchAppItemBatch(batch.getAppItemId());
                this.couponFlowInnerService.refreshAppItemCoupon(batch.getAppItemId());
            }
        }
    }

    @Override
    @Transactional(value="credits", propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public int deleteCouponCode(long couponId) throws StatusException {
        CouponDO coupon = this.couponService.find(couponId);
        if (coupon.getLocked().booleanValue() || coupon.getUsed().booleanValue()) {
            throw new StatusException(0, "\u5151\u6362\u5238\u5df2\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if (coupon.getItemId() != null) {
            this.itemService.findForUpdate(coupon.getItemId());
        } else if (coupon.getAppItemId() != null) {
            this.appItemService.findForUpdate(coupon.getAppItemId());
        }
        CouponBatchDO couponBatch = this.couponBatchService.findForUpdate(coupon.getBatchId());
        int ret = this.couponService.deleteOneCoupon(couponId);
        if (ret < 1) {
            throw new StatusException(0, "\u5151\u6362\u5238\u5df2\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if (coupon.getItemId() != null) {
            this.couponFlowInnerService.refreshBatch(couponBatch);
            this.couponFlowInnerService.switchItemBatch(coupon.getItemId());
            this.couponFlowInnerService.refreshItemCoupon(coupon.getItemId());
        } else if (coupon.getAppItemId() != null && coupon.getItemId() == null) {
            this.couponFlowInnerService.refreshBatch(couponBatch);
            this.couponFlowInnerService.switchAppItemBatch(coupon.getAppItemId());
            this.couponFlowInnerService.refreshAppItemCoupon(coupon.getAppItemId());
        }
        return ret;
    }

    @Override
    public int scanOverdueCoupon() {
        int selfAppItemNum = 0;
        int itemNum = 0;
        try {
            this.couponBatchService.updateAllNewOverDueBatch();
            List<AppItemDO> selfAppItems = this.appItemService.findSelfOverdueAppItem("coupon");
            for (AppItemDO appItem : selfAppItems) {
                Date validEndDate;
                if (appItem.getValidEndDate() == null || !(validEndDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)appItem.getValidEndDate()) + " 23:59:59"))).before(new Date())) continue;
                int ret = this.appItemService.updateStatusAndSubStatusById(appItem.getId(), "off", "expired");
                selfAppItemNum += ret;
                this.couponFlowInnerService.switchAppItemBatch(appItem.getId());
                this.couponFlowInnerService.refreshAppItemCoupon(appItem.getId());
            }
            List<ItemDO> items = this.itemService.findOverdueItem("coupon");
            for (ItemDO item : items) {
                Date validEndDate;
                if (item.getValidEndDate() == null || !(validEndDate = DateUtils.getSecondDate((String)(DateUtils.getDayStr((Date)item.getValidEndDate()) + " 23:59:59"))).before(new Date())) continue;
                int ret = this.appItemService.updateStatusAndSubStatusByItemId(item.getId(), "off", "expired");
                itemNum += ret;
                this.couponFlowInnerService.switchItemBatch(item.getId());
                this.couponFlowInnerService.refreshItemCoupon(item.getId());
            }
        }
        catch (Exception e) {
            log.error("\u626b\u63cf\u8fc7\u671f\u4f18\u60e0\u5238:", (Throwable)e);
        }
        return selfAppItemNum + itemNum;
    }
}

