/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.queryparams.AdminPageQueryEntity;
import cn.com.duiba.service.domain.vo.ItemClassifyItemCountVO;
import cn.com.duiba.service.item.dao.ItemDao;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.temp.EventHomeCache;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ItemServiceImpl
implements ItemService {
    @Resource
    private ItemDao itemDao;
    @Resource
    private EventHomeCache eventHomeCache;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "item.itemId_" + id;
    }

    @Override
    public List<ItemDO> findAllByType4DSL(String type) {
        return this.itemDao.findAllByType4DSL(type);
    }

    @Override
    public ItemDO findBySourceRelationIdAndSourceType(Long sourceRelationId, Integer sourceType) {
        return this.itemDao.findBySourceRelationIdAndSourceType(sourceRelationId, sourceType);
    }

    @Override
    public List<ItemDO> findByInTypes(List<String> types) {
        return this.itemDao.findByInTypes(types);
    }

    @Override
    public List<ItemDO> findAllByIds4ASL(List<Long> ids) {
        return this.itemDao.findAllByIds4ASL(ids);
    }

    @Override
    public List<ItemDO> findAllActivityItemAndEnable(Boolean enable) {
        return this.itemDao.findAllActivityItemAndEnable(enable);
    }

    @Override
    public List<ItemDO> findAllByNameAndType4Lottery(String name, String type) {
        return this.itemDao.findAllByNameAndType4Lottery(name, type);
    }

    @Override
    public List<ItemDO> findAllByNameAndType4LotteryAmb(String name, String type) {
        return this.itemDao.findAllByNameAndType4LotteryAmb(name, type);
    }

    @Override
    public List<ItemDO> findAllForDuibaSecondsKill() {
        return this.itemDao.findAllForDuibaSecondsKill();
    }

    @Override
    public List<ItemDO> findAllByClassify(List<Long> classifyIds) {
        return this.itemDao.findAllByClassify(classifyIds);
    }

    @Override
    public List<ItemClassifyItemCountVO> findItemClassifyCountMap(List<Long> icIds) {
        return this.itemDao.findItemClassifyCountMap(icIds);
    }

    @Override
    public List<ItemDO> findBatchScan() {
        return this.itemDao.findBatchScan();
    }

    @Override
    public List<ItemDO> findAutoRecommend(Boolean isAutoRecommend) {
        return this.itemDao.findAutoRecommend(isAutoRecommend);
    }

    @Override
    public List<Long> findAutoRecommendAndTagsItems(Long tagsId) {
        return this.itemDao.findAutoRecommendAndTagsItems(tagsId);
    }

    @Override
    public List<ItemDO> findRecommandItems(String itemName) {
        return this.itemDao.findRecommandItems(itemName);
    }

    @Override
    public Long findRecommandItemsCount(String itemName) {
        return this.itemDao.findRecommandItemsCount(itemName);
    }

    @Override
    public List<ItemDO> findAllEnableCoupon() {
        return this.itemDao.findAllEnableCoupon();
    }

    @Override
    public List<ItemDO> findAllTargetItemList(String type, Boolean deleted, Integer subType) {
        return this.itemDao.findAllTargetItemList(type, deleted, subType);
    }

    @Override
    public List<ItemDO> findItemByCondAndIdsPage(AdminPageQueryEntity queryEntity) {
        return this.itemDao.findItemByCondAndIdsPage(queryEntity);
    }

    @Override
    public Integer findItemByCondAndIdsPageCount(AdminPageQueryEntity queryEntity) {
        return this.itemDao.findItemByCondAndIdsPageCount(queryEntity);
    }

    @Override
    public List<ItemDO> findAdminItemPage(AdminPageQueryEntity queryEntity) {
        return this.itemDao.findAdminItemPage(queryEntity);
    }

    @Override
    public Integer findAdminItemPageCount(AdminPageQueryEntity queryEntity) {
        return this.itemDao.findAdminItemPageCount(queryEntity);
    }

    @Override
    public List<Map<String, Object>> findAllSupplementItemById(Map<String, Object> queryMap) {
        return this.itemDao.findAllSupplementItemById(queryMap);
    }

    @Override
    public List<ItemDO> findAllNewItem() {
        return this.itemDao.findAllNewItem();
    }

    @Override
    public List<ItemDO> findHomeItem(List<Long> ids) {
        return this.itemDao.findHomeItem(ids);
    }

    @Override
    public List<ItemDO> findAllBlacklistItem() {
        return this.itemDao.findAllBlacklistItem();
    }

    @Override
    public Integer getNewItemsNum(Date newItemTime) {
        return this.itemDao.getNewItemsNum(newItemTime);
    }

    @Override
    public List<ItemDO> findDuibaItemChoose(Map<String, Object> paramMap) {
        return this.itemDao.findDuibaItemChoose(paramMap);
    }

    @Override
    public Long findDuibaItemChooseCount(Map<String, Object> paramMap) {
        return this.itemDao.findDuibaItemChooseCount(paramMap);
    }

    @Override
    public List<ItemDO> findDuibaItemChooseFree(Integer offset, Integer max, String selectType, Set<Long> idsSet, String itemName) {
        return this.itemDao.findDuibaItemChooseFree(offset, max, selectType, idsSet, itemName);
    }

    @Override
    public Long findDuibaItemChooseCountFree(Integer offset, Integer max, String selectType, Set<Long> idsSet, String itemName) {
        return this.itemDao.findDuibaItemChooseCountFree(offset, max, selectType, idsSet, itemName);
    }

    @Override
    public List<ItemDO> findDuibaItemChooseCharge(Integer offset, Integer max, String selectType, Set<Long> idsSet, String itemName) {
        return this.itemDao.findDuibaItemChooseCharge(offset, max, selectType, idsSet, itemName);
    }

    @Override
    public Long findDuibaItemChooseCountCharge(Integer offset, Integer max, String selectType, Set<Long> idsSet, String itemName) {
        return this.itemDao.findDuibaItemChooseCountCharge(offset, max, selectType, idsSet, itemName);
    }

    @Override
    public List<ItemDO> findAutoOffItem() {
        return this.itemDao.findAutoOffItem();
    }

    @Override
    public ItemDO findForUpdate(Long id) {
        return this.itemDao.findForUpdate(id);
    }

    @Override
    public ItemDO find(Long id) {
        String key = this.getCacheKeyById(id);
        ItemDO d = (ItemDO)this.cacheClient.get(key);
        if (d == null) {
            d = this.itemDao.find(id);
            this.cacheClient.set(key, (Object)d, 60);
        }
        return d;
    }

    @Override
    public List<ItemDO> findAllByIds(List<Long> ids) {
        return this.itemDao.findAllByIds(ids);
    }

    @Override
    public List<ItemDO> findAllByIdsOrderByIdStr(List<Long> ids, String idsStr) {
        return this.itemDao.findAllByIdsOrderByIdStr(ids, idsStr);
    }

    @Override
    public List<Long> findIdAllByEnable(Boolean enable) {
        return this.itemDao.findIdAllByEnable(enable);
    }

    @Override
    public List<ItemDO> findAllByName(String name) {
        return this.itemDao.findAllByName(name);
    }

    @Override
    public ItemDO findByType(String type) {
        return this.itemDao.findByType(type);
    }

    @Override
    public List<ItemDO> findOverdueItem(String type) {
        return this.itemDao.findOverdueItem(type);
    }

    @Override
    public void insert(ItemDO item) {
        this.itemDao.insert(item);
        this.eventHomeCache.invalidItem(item.getId());
    }

    @Override
    public void update(ItemDO item) {
        this.itemDao.update(item);
        this.eventHomeCache.invalidItem(item.getId());
        this.cacheClient.remove(this.getCacheKeyById(item.getId()));
    }

    @Override
    public List<Long> findAllPreStockItems(int opType) {
        return this.itemDao.findAllPreStockItems(opType);
    }

    @Override
    public List<ItemDO> findAllByExpressTemplateId(Long expressTemplateId) {
        return this.itemDao.findAllByExpressTemplateId(expressTemplateId);
    }

    @Override
    public int setJsonValue(Long id, String key, String value) {
        int ret = this.itemDao.setJsonValue(id, key, value);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public String getJsonValue(Long id, String key) {
        return this.itemDao.getJsonValue(id, key);
    }

    @Override
    public int reduceRemaining(Long itemId) {
        int ret = this.itemDao.reduceRemaining(itemId);
        this.eventHomeCache.invalidItemRemaining(itemId);
        this.cacheClient.remove(this.getCacheKeyById(itemId));
        return ret;
    }

    @Override
    public int increaseRemaining(Long itemId) {
        int ret = this.itemDao.increaseRemaining(itemId);
        this.eventHomeCache.invalidItemRemaining(itemId);
        this.cacheClient.remove(this.getCacheKeyById(itemId));
        return ret;
    }

    @Override
    public int turnbackItemRemaining(Long itemId) {
        int ret = this.itemDao.turnbackItemRemaining(itemId);
        this.eventHomeCache.invalidItemRemaining(itemId);
        this.cacheClient.remove(this.getCacheKeyById(itemId));
        return ret;
    }

    @Override
    public int decreaseItemRemaining(Long itemId) {
        int ret = this.itemDao.decreaseItemRemaining(itemId);
        this.eventHomeCache.invalidItemRemaining(itemId);
        this.cacheClient.remove(this.getCacheKeyById(itemId));
        return ret;
    }

    @Override
    public int turnbackItemSales(Long itemId) {
        int ret = this.itemDao.turnbackItemSales(itemId);
        this.eventHomeCache.invalidItemRemaining(itemId);
        this.cacheClient.remove(this.getCacheKeyById(itemId));
        return ret;
    }

    @Override
    public void refreshRemaining(Long id, Date validEndDate, Integer remaining) {
        this.itemDao.refreshRemaining(id, validEndDate, remaining);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void enableOrDisableById(Long id, Boolean enable, Boolean deleted) {
        this.itemDao.enableOrDisableById(id, enable, deleted);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void setDelete(Long id, Boolean deleted) {
        this.itemDao.setDelete(id, deleted);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void enableById(Long id, Boolean enable, Date publishTime) {
        this.itemDao.enableById(id, enable, publishTime);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void updateRemaingById(Long id, Integer remaining) {
        this.itemDao.updateRemaingById(id, remaining);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void updateBatchIdById(Long id, Long batchId) {
        this.itemDao.updateBatchIdById(id, batchId);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void switchBatch(Long id, Long batchId, Integer remaining) {
        this.itemDao.switchBatch(id, batchId, remaining);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        int ret = this.itemDao.subRemainingById(id, subRemaining);
        this.eventHomeCache.invalidItemRemaining(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        int ret = this.itemDao.addRemainingById(id, addRemaining);
        this.eventHomeCache.invalidItemRemaining(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        int ret = this.itemDao.updateAutoOffDateNull(id);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateLimitCountNull(Long id) {
        int ret = this.itemDao.updateLimitCountNull(id);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateItemClassifyIdNullByItemClassifyId(Long itemClassifyId) {
        List<Long> ids = this.itemDao.findItemIdsByItemClassifyId(itemClassifyId);
        int ret = this.itemDao.updateItemClassifyIdNullByItemClassifyId(itemClassifyId);
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
        return ret;
    }

    @Override
    public int updateItemClassifyIdNullById(Long id) {
        int ret = this.itemDao.updateItemClassifyIdNullById(id);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public void updateSubTypeById(Long id, Integer subType) {
        this.itemDao.updateSubTypeById(id, subType);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void updateValidEndDateById(Long id, Date validEndDate) {
        this.itemDao.updateValidEndDateById(id, validEndDate);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public void updateOperationsTypeById(Long id, Integer operationsType) {
        this.itemDao.updateOperationsTypeById(id, operationsType);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public int updateAutoRecommendById(Long id, Boolean autoRecommend) {
        int ret = this.itemDao.updateAutoRecommendById(id, autoRecommend);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public void updatePayloadById(Long id, Integer payload) {
        this.itemDao.updatePayloadById(id, payload);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
    }

    @Override
    public int updateRemainingAndvalidEndDate(Long id, Integer remaining, Date validEndDate) {
        int ret = this.itemDao.updateRemainingAndvalidEndDate(id, remaining, validEndDate);
        this.eventHomeCache.invalidItem(id);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }
}

