/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.dao.ItemStockConsumeDao;
import cn.com.duiba.service.item.domain.dataobject.ItemStockConsumeDO;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.service.ItemStockConsumeService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemStockConsumeServiceImpl
implements ItemStockConsumeService {
    @Resource
    private ItemStockConsumeDao itemStockConsumeDao;
    @Resource
    private AppItemService appItemService;
    @Resource
    private ItemService itemService;

    @Override
    public int insert(ItemStockConsumeDO itemStockConsumeDO) {
        return this.itemStockConsumeDao.insert(itemStockConsumeDO);
    }

    @Override
    public int countConsumeStockLock(Long relationId, String relationType, Date time) {
        return this.itemStockConsumeDao.countConsumeStockLock(relationId, relationType, time);
    }

    @Override
    public int countAppConsumeStockLock(Long relationId, String relationType, Long appId, Date time) {
        return this.itemStockConsumeDao.countAppConsumeStockLock(relationId, relationType, appId, time);
    }

    @Override
    public ItemStockConsumeDO findByBizIdAndSource(String bizId, String bizSource) {
        return this.itemStockConsumeDao.findByBizIdAndSource(bizId, bizSource);
    }

    @Override
    @Transactional(value="credits")
    public void consumeStock(ItemKey itemKey, String bizId, String bizSource) throws BusinessException {
        int row;
        if (!itemKey.getItemType().equals("object") && !itemKey.getItemType().equals("virtual")) {
            throw new BusinessException("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\uff1a" + itemKey.getItemType());
        }
        Long relationId = null;
        String relationType = null;
        if (itemKey.isSelfAppItemMode()) {
            AppItemDO appitem = this.appItemService.findForUpdate(itemKey.getAppItem().getId());
            if (null == appitem) {
                throw new BusinessException("\u65e0\u6b64\u5546\u54c1");
            }
            if (appitem.getRemaining() <= 0) {
                throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,appItemId=" + itemKey.getAppItem().getId());
            }
            if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                Integer limit = appitem.getLimitEverydayQuantity();
                int sales = this.itemStockConsumeDao.countAppConsumeStockLock(appitem.getId(), "appItem", itemKey.getApp().getId(), DateUtils.getDayDate((Date)new Date()));
                if (null != limit && sales >= limit) {
                    throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,appItemId=" + itemKey.getAppItem().getId());
                }
            }
            if ((row = this.appItemService.reduceRemaining(appitem.getId())) < 1) {
                throw new BusinessException("\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25");
            }
            relationId = appitem.getId();
            relationType = "appItem";
        } else if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            Integer limit;
            ItemDO itemDO = this.itemService.findForUpdate(itemKey.getItem().getId());
            if (null == itemDO) {
                throw new BusinessException("\u65e0\u6b64\u5546\u54c1");
            }
            if (itemDO.getRemaining() <= 0) {
                throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,itemId=" + itemKey.getItem().getId());
            }
            if (itemKey.isItemMode()) {
                if (itemDO.isOpTypeItem(1)) {
                    limit = itemDO.getLimitEverydayQuantity();
                    int sales = this.itemStockConsumeDao.countConsumeStockLock(itemDO.getId(), "item", DateUtils.getDayDate((Date)new Date()));
                    if (null != limit && sales >= limit) {
                        throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,itemId=" + itemKey.getItem().getId());
                    }
                }
            } else if (itemKey.isDuibaAppItemMode()) {
                if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                    limit = itemKey.getAppItem().getLimitEverydayQuantity();
                    int sales = this.itemStockConsumeDao.countAppConsumeStockLock(itemDO.getId(), "item", itemKey.getApp().getId(), DateUtils.getDayDate((Date)new Date()));
                    if (null != limit && sales >= limit) {
                        throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,itemId=" + itemKey.getItem().getId());
                    }
                } else if (itemKey.getItem().isOpTypeItem(1)) {
                    limit = itemDO.getLimitEverydayQuantity();
                    int sales = this.itemStockConsumeDao.countConsumeStockLock(itemDO.getId(), "item", DateUtils.getDayDate((Date)new Date()));
                    if (null != limit && sales >= limit) {
                        throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,itemId=" + itemKey.getItem().getId());
                    }
                }
            }
            if ((row = this.itemService.reduceRemaining(itemKey.getItem().getId())) < 1) {
                throw new BusinessException("\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25");
            }
            relationId = itemDO.getId();
            relationType = "item";
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        ItemStockConsumeDO consume = new ItemStockConsumeDO(true);
        consume.setBizId(bizId);
        consume.setBizSource(bizSource);
        consume.setRelationId(relationId);
        consume.setRelationType(relationType);
        consume.setAppId(itemKey.getApp().getId());
        consume.setAction("pay");
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.itemStockConsumeDao.insert(consume);
    }

    @Override
    public void paybackStock(String bizId, String bizSource) throws BusinessException {
        ItemDO itemDO;
        AppItemDO appitem;
        int row;
        ItemStockConsumeDO consume = this.itemStockConsumeDao.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            return;
        }
        if (consume.getRelationType().equals("appItem") ? (row = this.appItemService.increaseRemaining((appitem = this.appItemService.findForUpdate(consume.getRelationId())).getId())) < 1 : consume.getRelationType().equals("item") && (row = this.itemService.increaseRemaining((itemDO = this.itemService.findForUpdate(consume.getRelationId())).getId())) < 1) {
            throw new BusinessException("\u8fd4\u5e93\u5b58\u5931\u8d25");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        ItemStockConsumeDO detail = new ItemStockConsumeDO(true);
        detail.setBizId(consume.getBizId());
        detail.setBizSource(consume.getBizSource());
        detail.setRelationId(consume.getRelationId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(consume.getAppId());
        detail.setAction("back");
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.itemStockConsumeDao.insert(detail);
    }
}

