/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.temp;

import cn.com.duiba.service.constants.DsConstants;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.service.AppService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventHomeCache
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(EventHomeCache.class);
    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private AppService appService;
    private static final List<Long> noRefreshList = DsConstants.TEST_COUPON;
    private static Map<Long, Long> enableAppIds = new HashMap<Long, Long>();
    private static volatile Set<Long> APP_IDS = Collections.synchronizedSet(new HashSet());
    private static volatile Set<Long> ITEM_IDS = Collections.synchronizedSet(new HashSet());
    private static volatile Set<Long> APP_ITEM_IDS = Collections.synchronizedSet(new HashSet());
    private static volatile Set<Long> ITEM_REMAINING = Collections.synchronizedSet(new HashSet());
    private static volatile Set<Long> APP_ITEM_REMAINING = Collections.synchronizedSet(new HashSet());
    static AtomicBoolean init = new AtomicBoolean();
    private ScheduledExecutorService es;

    public void invalidApp(Long appId) {
        APP_IDS.add(appId);
    }

    public void invalidItem(Long itemId) {
        ITEM_IDS.add(itemId);
    }

    public void invalidItemRemaining(Long itemId) {
        ITEM_REMAINING.add(itemId);
    }

    public void invalidAppItem(Long appItemId) {
        APP_ITEM_IDS.add(appItemId);
    }

    public void invalidAppItemRemaining(Long appItemId) {
        APP_ITEM_REMAINING.add(appItemId);
    }

    public void invalidAppItem(List<Long> appItemIds) {
        APP_ITEM_IDS.addAll(appItemIds);
    }

    public void invalidRelationActivity(Long relationId, Integer type) {
        List<Long> appIds = this.appItemService.findAppIdsByInActivityId(relationId, type);
        if (appIds != null && appIds.size() > 0) {
            APP_IDS.addAll(appIds);
        }
    }

    public void invalidRelationActivity(Long relationId) {
        List<Long> appIds = this.appItemService.findAppIdsByActivityId(relationId);
        if (appIds != null && appIds.size() > 0) {
            APP_IDS.addAll(appIds);
        }
    }

    public void updateAppTimestamp(Long appId) {
        try {
            String cacheKey = "item.MS_HOME_ITEM_-" + appId;
            this.memcachedClient.set(cacheKey, (Object)System.currentTimeMillis(), 3600);
        }
        catch (Exception e) {
            log.error("invalidAppHomeItemKeyCache error:", (Throwable)e);
        }
    }

    public Long getAppTimestamp(Long appId) {
        String cacheKey = "item.MS_HOME_ITEM_-" + appId;
        return (Long)this.memcachedClient.get(cacheKey);
    }

    private void init() {
        if (init.compareAndSet(false, init.get())) {
            this.es = Executors.newScheduledThreadPool(2);
            this.es.scheduleWithFixedDelay(new Runnable(){

                private void process() {
                    List appIds = EventHomeCache.this.appService.findAllEnable();
                    for (Long appId : appIds) {
                        enableAppIds.put(appId, appId);
                    }
                }

                @Override
                public void run() {
                    try {
                        this.process();
                    }
                    catch (Exception e) {
                        log.error("schedule run error", (Throwable)e);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
            this.es.scheduleWithFixedDelay(new Runnable(){

                private void process() {
                    Set tempItemIds = ITEM_IDS;
                    Set tempAppItemIds = APP_ITEM_IDS;
                    Set tempAppIds = APP_IDS;
                    Set tempItemRemaining = ITEM_REMAINING;
                    Set tempAppItemRemaining = APP_ITEM_REMAINING;
                    ITEM_IDS = Collections.synchronizedSet(new HashSet());
                    APP_ITEM_IDS = Collections.synchronizedSet(new HashSet());
                    APP_IDS = Collections.synchronizedSet(new HashSet());
                    ITEM_REMAINING = Collections.synchronizedSet(new HashSet());
                    APP_ITEM_REMAINING = Collections.synchronizedSet(new HashSet());
                    if (!tempAppItemRemaining.isEmpty()) {
                        List<AppItemDO> ais = EventHomeCache.this.appItemService.findAllByIds(new ArrayList<Long>(tempAppItemRemaining));
                        for (AppItemDO ai : ais) {
                            if (ai.getRemaining() == null || ai.getRemaining() > 0) continue;
                            tempAppIds.add(ai.getAppId());
                        }
                    }
                    if (!tempItemRemaining.isEmpty()) {
                        List<ItemDO> items = EventHomeCache.this.itemService.findAllByIds(new ArrayList<Long>(tempItemRemaining));
                        for (ItemDO item : items) {
                            if (item.getRemaining() == null || item.getRemaining() > 0) continue;
                            tempItemIds.add(item.getId());
                        }
                    }
                    if (!tempItemIds.isEmpty()) {
                        tempItemIds.removeAll(noRefreshList);
                        if (!tempItemIds.isEmpty()) {
                            List<Long> itemAppIds = EventHomeCache.this.appItemService.findAppIdByItemIds(new ArrayList<Long>(tempItemIds));
                            tempAppIds.addAll(itemAppIds);
                        }
                    }
                    if (!tempAppItemIds.isEmpty()) {
                        List<Long> appItemAppIds = EventHomeCache.this.appItemService.findAppIdsByIds(new ArrayList<Long>(tempAppItemIds));
                        tempAppIds.addAll(appItemAppIds);
                    }
                    int temp = 0;
                    for (Long appId : tempAppIds) {
                        if (!enableAppIds.containsKey(appId)) continue;
                        EventHomeCache.this.updateAppTimestamp(appId);
                        ++temp;
                    }
                    EventHomeCache.this.warnLog(temp, tempItemIds, tempAppItemIds);
                }

                @Override
                public void run() {
                    try {
                        this.process();
                    }
                    catch (Exception e) {
                        log.error("schedule run error", (Throwable)e);
                    }
                }
            }, 1000L, 200L, TimeUnit.MILLISECONDS);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    private void warnLog(int appNum, Set<Long> item, Set<Long> appItem) {
        if (appNum > 100) {
            StringBuffer itemIds = new StringBuffer("[");
            for (Long id : item) {
                itemIds.append(id).append(",");
            }
            itemIds.append("]");
            StringBuffer appItemIds = new StringBuffer("[");
            for (Long id : appItem) {
                appItemIds.append(id).append(",");
            }
            appItemIds.append("]");
            log.error("refresh homeCache warn : app=" + appNum + " itemIds=" + itemIds.toString() + " appItemIds=" + appItemIds.toString());
        }
    }
}

