/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.dao.AppItemDao;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.temp.AppItemCache;
import cn.com.duiba.service.item.temp.EventHomeCache;
import cn.com.duiba.service.item.temp.ItemKeyCache;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppItemServiceImpl
implements AppItemService {
    @Resource
    private AppItemDao appItemDao;
    @Resource
    private ItemService itemService;
    @Resource
    private EventHomeCache eventHomeCache;
    @Resource
    private CacheClient cacheClient;

    @Override
    public List<Long> findIdsByOpenLotteryIds(List<Long> openOaIds) {
        return this.appItemDao.findIdsByOpenLotteryIds(openOaIds);
    }

    @Override
    public List<AppItemDO> findAllBySourceTypeAndRelationIdAndDeleted(Integer sourceType, Long sourceRelationId, Boolean deleted) {
        return this.appItemDao.findAllBySourceTypeAndRelationIdAndDeleted(sourceType, sourceRelationId, deleted);
    }

    @Override
    public List<AppItemDO> findAllDuibaActivityAppItem(List<Long> itemIds, Long appId) {
        return this.appItemDao.findAllDuibaActivityAppItem(itemIds, appId);
    }

    @Override
    public List<AppItemDO> findAllOwnerByTitleAndTypeAndAppId4ASL(String title, String type, Long appId) {
        return this.appItemDao.findAllOwnerByTitleAndTypeAndAppId4ASL(title, type, appId);
    }

    @Override
    public List<AppItemDO> findAllNotOwnerByTitleAndTypeAndAppId4ASL(String title, String type, Long appId) {
        return this.appItemDao.findAllNotOwnerByTitleAndTypeAndAppId4ASL(title, type, appId);
    }

    @Override
    public Long countRow(Map<String, Object> params) {
        return this.appItemDao.countRow(params);
    }

    @Override
    public List<AppItemDO> findByLimit(Map<String, Object> params) {
        return this.appItemDao.findByLimit(params);
    }

    @Override
    public List<Long> findInvalidAppItemIds(Long appId, String subStatus) {
        return this.appItemDao.findInvalidAppItemIds(appId, subStatus);
    }

    @Override
    public List<AppItemDO> findAllByTypeAndIsOwnerAndStatus(String type, Boolean isOwner, String status) {
        return this.appItemDao.findAllByTypeAndIsOwnerAndStatus(type, isOwner, status);
    }

    @Override
    public List<Long> selectHasUpItems(List<Long> ids, Long appId) {
        return this.appItemDao.selectHasUpItems(ids, appId);
    }

    @Override
    public AppItemDO selectItemStore(Long appId, Long itemId) {
        return this.appItemDao.selectItemStore(appId, itemId);
    }

    @Override
    public List<AppItemDO> findAllByAppIdAndTypeIn(Long appId) {
        return this.appItemDao.findAllByAppIdAndTypeIn(appId);
    }

    @Override
    public List<AppItemDO> findAllUpVirtaulAppItems(Long appId) {
        return this.appItemDao.findAllUpVirtaulAppItems(appId);
    }

    @Override
    public List<AppItemDO> findAllVirtualValid(Long appId) {
        return this.appItemDao.findAllVirtualValid(appId);
    }

    @Override
    public List<AppItemDO> findhomeAppItemNeed(Long appId) {
        return this.appItemDao.findhomeAppItemNeed(appId);
    }

    @Override
    public List<AppItemDO> findhomeAppItemNeedOfPptv(Long appId) {
        return this.appItemDao.findhomeAppItemNeedOfPptv(appId);
    }

    @Override
    public List<AppItemDO> findAllAppTasksContent(Long appId) {
        return this.appItemDao.findAllAppTasksContent(appId);
    }

    @Override
    public AppItemDO selectItemStore4Task(Long appId, Long itemId) {
        return this.appItemDao.selectItemStore4Task(appId, itemId);
    }

    @Override
    public AppItemDO findForUpdate(Long id) {
        return this.appItemDao.findForUpdate(id);
    }

    @Override
    public AppItemDO find(Long id) {
        String key = this.getKeyById(id);
        AppItemDO d = (AppItemDO)this.cacheClient.get(key);
        if (d == null) {
            d = this.appItemDao.find(id);
            this.cacheClient.set(key, (Object)d, 60);
        }
        return d;
    }

    private String getKeyById(Long id) {
        return "item.appItemId_" + id;
    }

    @Override
    public void insert(AppItemDO appItem) {
        this.appItemDao.insert(appItem);
        this.eventHomeCache.invalidApp(appItem.getAppId());
    }

    @Override
    public void update(AppItemDO appItem) {
        this.appItemDao.update(appItem);
        this.eventHomeCache.invalidApp(appItem.getAppId());
        this.cacheClient.remove(this.getKeyById(appItem.getId()));
    }

    @Override
    public List<AppItemDO> findAllByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        return this.appItemDao.findAllByItemIdsAndAppId(itemIds, appId);
    }

    @Override
    public List<AppItemDO> findAllByIds(List<Long> ids) {
        return this.appItemDao.findAllByIds(ids);
    }

    @Override
    public AppItemDO findByAppAndItemOnline(Long appId, Long itemId) {
        return this.appItemDao.findByAppAndItemOnline(appId, itemId);
    }

    @Override
    public List<AppItemDO> findAllByItemId(Long itemId) {
        return this.appItemDao.findAllByItemId(itemId);
    }

    @Override
    public AppItemDO findByAppIdAndItemId(Long appId, Long itemId) {
        return this.appItemDao.findByAppIdAndItemId(appId, itemId);
    }

    @Override
    public List<AppItemDO> findAllByAppIdAndType(Long appId, String type) {
        return this.appItemDao.findAllByAppIdAndType(appId, type);
    }

    @Override
    public List<AppItemDO> findAllByAppIdAndInType(Long appId, String[] type) {
        return this.appItemDao.findAllByAppIdAndInType(appId, type);
    }

    @Override
    public List<AppItemDO> findAllByInType(String[] type) {
        return this.appItemDao.findAllByInType(type);
    }

    @Override
    public List<AppItemDO> findAllByAppAndIsOwner(Long appId, Boolean isOwner) {
        return this.appItemDao.findAllByAppAndIsOwner(appId, isOwner);
    }

    @Override
    public Integer findCountByItemId(Long itemId) {
        return this.appItemDao.findCountByItemId(itemId);
    }

    @Override
    public Integer findOnlineCount(Long appId) {
        return this.appItemDao.findOnlineCount(appId);
    }

    @Override
    public List<AppItemDO> findOnShelfByItemId(Long itemId) {
        return this.appItemDao.findOnShelfByItemId(itemId);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        return this.appItemDao.findAppIdByItemIds(itemIds);
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        return this.appItemDao.findAppIdsByInActivityId(activityId, type);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        return this.appItemDao.findAppIdsByActivityId(relationId);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        return this.appItemDao.findAppIdsByIds(ids);
    }

    @Override
    public List<AppItemDO> findSelfOverdueAppItem(String type) {
        return this.appItemDao.findSelfOverdueAppItem(type);
    }

    @Override
    public List<AppItemDO> findAutoOffAppItem() {
        return this.appItemDao.findAutoOffAppItem();
    }

    @Override
    public List<AppItemDO> findAppItemLimit(Map<String, Object> param, int start, int pageSize) {
        return this.appItemDao.findAppItemLimit(param, start, pageSize);
    }

    @Override
    public Long findAppItemCount(Map<String, Object> param) {
        return this.appItemDao.findAppItemCount(param);
    }

    @Override
    public List<AppItemDO> findAllAppItem(Map<String, Object> param) {
        return this.appItemDao.findAllAppItem(param);
    }

    @Override
    public List<AppItemDO> findAllByAppId(Long appId) {
        return this.appItemDao.findAllByAppId(appId);
    }

    @Override
    public List<AppItemDO> findAllByExpressTemplateId(Long expressTemplateId) {
        return this.appItemDao.findAllByExpressTemplateId(expressTemplateId);
    }

    @Override
    public Long countPublishItemRow(Map<String, Object> queryPublish) {
        return this.appItemDao.countPublishItemRow(queryPublish);
    }

    @Override
    public List<AppItemDO> findPublishItemLimit(Map<String, Object> queryPublish) {
        return this.appItemDao.findPublishItemLimit(queryPublish);
    }

    @Override
    public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type) {
        int ret = this.appItemDao.updateStatusByActivityId(status, delete, activityId, type);
        this.eventHomeCache.invalidRelationActivity(activityId, type);
        List<Long> ids = this.appItemDao.findIdsByInActivityId(activityId, type);
        for (Long id : ids) {
            this.cacheClient.remove(this.getKeyById(id));
        }
        return ret;
    }

    @Override
    public Integer updateStatusByOperationActivityId(String status, Boolean delete, Long relationId) {
        int ret = this.appItemDao.updateStatusByOperationActivityId(status, delete, relationId);
        this.eventHomeCache.invalidRelationActivity(relationId);
        List<Long> ids = this.appItemDao.findIdsByActivityId(relationId);
        for (Long id : ids) {
            this.cacheClient.remove(this.getKeyById(id));
        }
        return ret;
    }

    @Override
    public int reduceRemaining(Long appItemId) {
        int ret = this.appItemDao.reduceRemaining(appItemId);
        this.eventHomeCache.invalidAppItemRemaining(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
        return ret;
    }

    @Override
    public int increaseRemaining(Long appItemId) {
        int ret = this.appItemDao.increaseRemaining(appItemId);
        this.eventHomeCache.invalidAppItemRemaining(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
        return ret;
    }

    @Override
    public void turnbackAppitemRemaining(Long appItemId) {
        this.appItemDao.turnbackAppitemRemaining(appItemId);
        this.eventHomeCache.invalidAppItemRemaining(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
    }

    @Override
    public void decreaseAppitemRemaining(Long appItemId) {
        this.appItemDao.decreaseAppitemRemaining(appItemId);
        this.eventHomeCache.invalidAppItemRemaining(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
    }

    @Override
    public void updateBatchIdById(Long id, Long batchId) {
        this.appItemDao.updateBatchIdById(id, batchId);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay) {
        this.appItemDao.standUpOrDownAppItem(id, status, deleted, payload, homeDisplay);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void deleteOrRecoverAppItem(Long id, Boolean deleted, String status) {
        this.appItemDao.deleteOrRecoverAppItem(id, deleted, status);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateCreditsById(Long id, Long credits) {
        this.appItemDao.updateCreditsById(id, credits);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateRemainingById(Long id, Integer remaining) {
        this.appItemDao.updateRemainingById(id, remaining);
        this.eventHomeCache.invalidAppItemRemaining(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public int updateStatusAndSubStatusById(Long id, String status, String subStatus) {
        int ret = this.appItemDao.updateStatusAndSubStatusById(id, status, subStatus);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
        return ret;
    }

    @Override
    public void updateCreditsAndCustomPriceById(Long id, Long credits, String customPrice) {
        this.appItemDao.updateCreditsAndCustomPriceById(id, credits, customPrice);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        int ret = this.appItemDao.subRemainingById(id, subRemaining);
        this.eventHomeCache.invalidAppItemRemaining(id);
        this.cacheClient.remove(this.getKeyById(id));
        return ret;
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        int ret = this.appItemDao.addRemainingById(id, addRemaining);
        this.eventHomeCache.invalidAppItemRemaining(id);
        this.cacheClient.remove(this.getKeyById(id));
        return ret;
    }

    @Override
    public int updateStatusAndSubStatusByItemId(Long itemId, String status, String subStatus) {
        int ret = this.appItemDao.updateStatusAndSubStatusByItemId(itemId, status, subStatus);
        this.eventHomeCache.invalidItem(itemId);
        List<Long> ids = this.appItemDao.findIdByItemIds(Arrays.asList(itemId));
        for (Long id : ids) {
            this.cacheClient.remove(this.getKeyById(id));
        }
        return ret;
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        int ret = this.appItemDao.updateAutoOffDateNull(id);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
        return ret;
    }

    @Override
    public void deletePushAppItem(List<Long> ids) {
        this.appItemDao.deletePushAppItem(ids);
        this.eventHomeCache.invalidAppItem(ids);
        for (Long id : ids) {
            this.cacheClient.remove(this.getKeyById(id));
        }
    }

    @Override
    public void updateExpiedAppItem(Long itemId) {
        List<Long> ids = this.appItemDao.findExpiedAppItemIds(itemId);
        this.appItemDao.updateExpiedAppItem(itemId);
        this.eventHomeCache.invalidItem(itemId);
        for (Long id : ids) {
            this.cacheClient.remove(this.getKeyById(id));
        }
    }

    @Override
    public int updateExpiedAppItemById(Long appItemId) {
        int ret = this.appItemDao.updateExpiedAppItemById(appItemId);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
        return ret;
    }

    @Override
    public void setMyRepoMultiNull(Long appItemId) {
        this.appItemDao.setMyRepoMultiNull(appItemId);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
    }

    @Override
    public void setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity) {
        this.appItemDao.setLimitNull(appItemId, limitCount, limitTimeBetween, limitEverydayQuantity);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
    }

    @Override
    public void setImageNull(Long appItemId) {
        this.appItemDao.setImageNull(appItemId);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
    }

    @Override
    public void setSubStatusNull(Long appItemId) {
        this.appItemDao.setSubStatusNull(appItemId);
        this.eventHomeCache.invalidAppItem(appItemId);
        this.cacheClient.remove(this.getKeyById(appItemId));
    }

    @Override
    public void updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle) {
        this.appItemDao.updateMainPushAppItem(id, title, logo, smallImage, whiteImage, bannerImage, credits, subtitle);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo) {
        this.appItemDao.updateHdtoolAppItem(id, title, smallImage, whiteImage, credits, customPrice, logo);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateAppItemSourceType(Long id, Long credits, Date gmtModified, Integer sourceType, String title) {
        this.appItemDao.updateAppItemSourceType(id, credits, gmtModified, sourceType, title);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateValidEndDate(Long id, Date validEndDate) {
        this.appItemDao.updateValidEndDate(id, validEndDate);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateCustomPrice(Long id, String customPrice) {
        this.appItemDao.updateCustomPrice(id, customPrice);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateOperationsTypeById(Long id, Integer operationsType) {
        this.appItemDao.updateOperationsTypeById(id, operationsType);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateActivityAppItem(Long id, String title, String subtitle, String logo, String smallImage, String whiteImage) {
        this.appItemDao.updateActivityAppItem(id, title, subtitle, logo, smallImage, whiteImage);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public void updateTurntableAppItem(Long id, String title, String subtitle, String logo, String smallImage, String whiteImage, Long credits, String customPrice) {
        this.appItemDao.updateTurntableAppItem(id, title, subtitle, logo, smallImage, whiteImage, credits, customPrice);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
    }

    @Override
    public int updateSubTypeById(Long id, Integer subType) {
        int ret = this.appItemDao.updateSubTypeById(id, subType);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
        return ret;
    }

    @Override
    public int updateRemainingAndvalidEndDate(Long id, Integer remaining, Date validEndDate) {
        int ret = this.appItemDao.updateRemainingAndvalidEndDate(id, remaining, validEndDate);
        this.eventHomeCache.invalidAppItem(id);
        this.cacheClient.remove(this.getKeyById(id));
        return ret;
    }

    @Override
    public List<AppItemDO> findIdAndAppId4AppItem(List<Long> appItemIds) {
        return this.appItemDao.findIdAndAppId4AppItem(appItemIds);
    }

    @Override
    public int updateAppItemPayload(Long appId, Long appItemId, Integer payload) throws Exception {
        int ret = this.appItemDao.updateAppItemPayload(appId, appItemId, payload);
        this.eventHomeCache.invalidApp(appId);
        this.cacheClient.remove(this.getKeyById(appItemId));
        return ret;
    }

    @Override
    public int getTopNumByAppId(Long appId) {
        return this.appItemDao.getTopNumByAppId(appId);
    }

    @Override
    public int findAppMaxPayload(Long appId) {
        return this.appItemDao.findAppMaxPayload(appId);
    }

    @Override
    public List<Long> findTopAppItemDesc(Long appId) {
        return this.appItemDao.findTopAppItemDesc(appId);
    }

    @Override
    public int updateOfflineAppItem4Disable(Long appId) {
        List<Long> ids = this.appItemDao.findOfflineAppItemIds4Disable(appId);
        int ret = this.appItemDao.updateOfflineAppItem4Disable(appId);
        this.eventHomeCache.invalidApp(appId);
        for (Long id : ids) {
            this.cacheClient.remove(this.getKeyById(id));
        }
        return ret;
    }

    @Override
    public List<ItemKey> findHomeItemKeyByCache(AppDO app) {
        String key = "item.homeItemKey_" + app.getId();
        ItemKeyCache cache = (ItemKeyCache)this.cacheClient.get(key);
        Long memTime = this.eventHomeCache.getAppTimestamp(app.getId());
        if (cache != null && memTime != null && cache.getCacheTime() < memTime) {
            cache = new ItemKeyCache(this.findAppItemToItemKey(app));
            this.cacheClient.set(key, (Object)cache, 120);
        }
        return cache.getItemKeys();
    }

    @Override
    public List<AppItemDO> findBannerIconAppItemByCache(Long appId, List<Long> appItemIds) {
        ArrayList<Long> appItemIdList = new ArrayList<Long>(appItemIds);
        Collections.sort(appItemIdList);
        StringBuilder sb = new StringBuilder();
        for (Long l : appItemIdList) {
            sb.append(l).append(",");
        }
        String md5 = SecurityUtils.encode2StringByMd5((String)sb.toString());
        String key = "item.bannerIconAppItem_" + appId + "_" + md5;
        AppItemCache cache = (AppItemCache)this.cacheClient.get(key);
        Long memTime = this.eventHomeCache.getAppTimestamp(appId);
        if (cache != null && memTime != null && cache.getCacheTime() < memTime) {
            cache = new AppItemCache(this.findAllByIds(appItemIdList));
            this.cacheClient.set(key, (Object)cache, 120);
        }
        return cache.getAppItems();
    }

    @Override
    public List<ItemKey> findAppItemToItemKey(AppDO app) {
        List<AppItemDO> appItems = this.findhomeAppItemNeed(app.getId());
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (AppItemDO appItem : appItems) {
            if (appItem.getItemId() == null) continue;
            itemIds.add(appItem.getItemId());
        }
        HashMap<Long, ItemDO> itemId2ItemMap = new HashMap<Long, ItemDO>();
        if (itemIds.size() > 0) {
            List<ItemDO> items = this.itemService.findHomeItem(itemIds);
            for (ItemDO item : items) {
                itemId2ItemMap.put(item.getId(), item);
            }
        }
        ArrayList<ItemKey> itemKeys = new ArrayList<ItemKey>();
        for (AppItemDO appItemDO : appItems) {
            ItemDO itemDO = (ItemDO)itemId2ItemMap.get(appItemDO.getItemId());
            if (itemDO != null && !itemDO.getEnable().booleanValue()) continue;
            ItemKey itemKey = ItemKey.generate((ItemDO)itemDO, (AppItemDO)appItemDO, (AppDO)app);
            itemKeys.add(itemKey);
        }
        return itemKeys;
    }
}

