/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.item.dao.ItemAppSpecifyDao;
import cn.com.duiba.service.item.domain.dataobject.ItemAppSpecifyDO;
import cn.com.duiba.service.item.domain.vo.ItemAppSpecifyVO;
import cn.com.duiba.service.item.service.ItemAppSpecifyService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ItemAppSpecifyServiceImpl
implements ItemAppSpecifyService {
    @Resource
    private ItemAppSpecifyDao itemAppSpecifyDao;
    @Resource
    private CacheClient cacheClient;

    @Override
    public List<ItemAppSpecifyDO> findSpecifyByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        ArrayList<ItemAppSpecifyDO> list = new ArrayList<ItemAppSpecifyDO>();
        for (Long itemId : itemIds) {
            ItemAppSpecifyDO d = this.findByItemIdAndAppId(itemId, appId);
            if (d == null) continue;
            list.add(d);
        }
        return list;
    }

    @Override
    public List<ItemAppSpecifyVO> findAllByItemId(Long itemId) {
        return this.itemAppSpecifyDao.findAllByItemId(itemId);
    }

    @Override
    public void delete(Long id) {
        ItemAppSpecifyDO d = this.find(id);
        this.itemAppSpecifyDao.delete(id);
        if (d != null) {
            this.cacheClient.remove(this.getCacheKeyByItemIdAndAppId(d.getItemId(), d.getAppId()));
        }
    }

    @Override
    public int reduceRemaining(Long itemId, Long appId) {
        int ret = this.itemAppSpecifyDao.reduceRemaining(itemId, appId);
        this.cacheClient.remove(this.getCacheKeyByItemIdAndAppId(itemId, appId));
        return ret;
    }

    @Override
    public int increaseRemaining(Long itemId, Long appId) {
        int ret = this.itemAppSpecifyDao.increaseRemaining(itemId, appId);
        this.cacheClient.remove(this.getCacheKeyByItemIdAndAppId(itemId, appId));
        return ret;
    }

    @Override
    public Integer findSpecifyRemaining(Long itemId, Long appId) {
        Integer ret = this.itemAppSpecifyDao.findSpecifyRemaining(itemId, appId);
        return ret;
    }

    @Override
    public List<Long> findNOSpecify4App(Long appId) {
        return this.itemAppSpecifyDao.findNOSpecify4App(appId);
    }

    @Override
    public List<Long> findNOSpecify4AppNew(Long appId, Date newItemTime) {
        return this.itemAppSpecifyDao.findNOSpecify4AppNew(appId, newItemTime);
    }

    @Override
    public ItemAppSpecifyDO findByItemIdAndAppId(Long itemId, Long appId) {
        String key = this.getCacheKeyByItemIdAndAppId(itemId, appId);
        ItemAppSpecifyDO ret = (ItemAppSpecifyDO)this.cacheClient.get(key);
        if (ret == null) {
            ret = this.itemAppSpecifyDao.findByItemIdAndAppId(itemId, appId);
            this.cacheClient.set(key, (Object)ret, 300);
        }
        return ret;
    }

    @Override
    public ItemAppSpecifyDO findByItemIdAndAppIdLock(Long itemId, Long appId) {
        return this.itemAppSpecifyDao.findByItemIdAndAppIdLock(itemId, appId);
    }

    @Override
    public void insert(ItemAppSpecifyDO itemAppSpecifyDO) {
        this.itemAppSpecifyDao.insert(itemAppSpecifyDO);
    }

    @Override
    public ItemAppSpecifyDO find(Long id) {
        return this.itemAppSpecifyDao.find(id);
    }

    @Override
    public void updateRemaining(Long id, Integer remaining) {
        ItemAppSpecifyDO d = this.find(id);
        this.itemAppSpecifyDao.updateRemaining(id, remaining);
        this.cacheClient.remove(this.getCacheKeyByItemIdAndAppId(d.getItemId(), d.getAppId()));
    }

    private String getCacheKeyByItemIdAndAppId(Long itemId, Long appId) {
        return "item.itemAppSpecify_itemId_appId_" + itemId + "_" + appId;
    }
}

