/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.item.bo.ItemBo;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.ItemAppSpecifyService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.service.AppBannerService;
import cn.com.duiba.service.service.AppService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemBoImpl
implements ItemBo {
    @Resource
    private ItemService itemService;
    @Resource
    private AppBannerService appBannerService;
    @Resource
    private AppItemService appItemService;
    @Resource
    private AppService appService;
    @Resource
    private ItemAppSpecifyService itemAppSpecifyService;

    @Override
    public int offAndExpiredAppItem(Long itemId) {
        int ret = this.appItemService.updateStatusAndSubStatusByItemId(itemId, "off", "expired");
        if (ret > 0) {
            this.appBannerService.disableByItemId(itemId);
        }
        return ret;
    }

    @Override
    public Integer getNewItemsNum(Long id) {
        AppDO app = this.appService.find(id);
        int num = this.itemService.getNewItemsNum(app.getNewItemTime());
        List<Long> specifyNo4AppIds = this.itemAppSpecifyService.findNOSpecify4AppNew(app.getId(), app.getNewItemTime());
        return num - specifyNo4AppIds.size();
    }

    @Override
    @Transactional(value="credits")
    public Boolean delete(Long id) {
        ItemDO item = this.itemService.find(id);
        if (item.getEnable().booleanValue()) {
            return Boolean.FALSE;
        }
        item = new ItemDO(id);
        item.setDeleted(Boolean.TRUE);
        this.itemService.setDelete(item.getId(), item.getDeleted());
        List<AppItemDO> appItems = this.appItemService.findAllByItemId(id);
        for (AppItemDO ai : appItems) {
            this.appBannerService.disableByAppItemId(ai.getId());
        }
        return Boolean.TRUE;
    }
}

