/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.event;

import com.alibaba.fastjson.JSONObject;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ThreadPoolDuibaService {
    public static final int PriorityHigh = 10;
    public static final int PriorityNormal = 5;
    public static final int PriorityLow = 1;
    private static Logger log = LoggerFactory.getLogger(ThreadPoolDuibaService.class);
    private static final int PoolMaxThread = 50;
    private static ThreadPoolDuibaService service = new ThreadPoolDuibaService();
    private Object lock = new Object();
    private ExecutorService pool = Executors.newFixedThreadPool(50);
    private ScheduledExecutorService whileService = Executors.newScheduledThreadPool(1);
    private AtomicInteger runningStat = new AtomicInteger();
    private AtomicInteger waitRunStat = new AtomicInteger();
    private PriorityBlockingQueue<DuibaRunnable> queue = new PriorityBlockingQueue();

    public static ThreadPoolDuibaService get() {
        return service;
    }

    private ThreadPoolDuibaService() {
        this.whileService.scheduleWithFixedDelay(new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    DuibaRunnable runnable;
                    do {
                        runnable = null;
                        if (ThreadPoolDuibaService.this.runningStat.get() >= 50) return;
                        if (!ThreadPoolDuibaService.this.queue.isEmpty()) {
                            runnable = (DuibaRunnable)ThreadPoolDuibaService.this.queue.take();
                        }
                        if (runnable == null) continue;
                        log.debug("submit priority=" + runnable.getPriority());
                        ThreadPoolDuibaService.this.waitRunStat.decrementAndGet();
                        ThreadPoolDuibaService.this.runningStat.incrementAndGet();
                        ThreadPoolDuibaService.this.pool.submit(runnable);
                    } while (runnable != null);
                    return;
                }
                catch (Exception e) {
                    log.error("ThreadPoolService while cycle exception", (Throwable)e);
                }
            }
        }, 1000L, 10L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Runnable runnable, int priority) {
        Object object = this.lock;
        synchronized (object) {
            if (this.runningStat.get() < 50) {
                this.runningStat.incrementAndGet();
                this.pool.submit(new DuibaRunnable(runnable, priority));
            } else {
                this.waitRunStat.incrementAndGet();
                this.queue.add(new DuibaRunnable(runnable, priority));
            }
        }
    }

    public JSONObject dumpDetail() {
        JSONObject o = new JSONObject();
        o.put("runningStat", (Object)this.runningStat);
        o.put("runningStat", (Object)this.waitRunStat);
        return o;
    }

    public int dumpSize() {
        return this.waitRunStat.get() + this.runningStat.get();
    }

    public boolean isBusy() {
        int size = this.dumpSize();
        return size > 100;
    }

    public AtomicInteger getRunningStat() {
        return this.runningStat;
    }

    public AtomicInteger getWaitRunStat() {
        return this.waitRunStat;
    }

    public class DuibaRunnable
    implements Runnable,
    Comparable<DuibaRunnable> {
        private int priority;
        private Runnable runnable;

        public DuibaRunnable(Runnable runnable, int priority) {
            Assert.notNull((Object)runnable);
            this.runnable = runnable;
            this.priority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                ThreadPoolDuibaService.this.runningStat.decrementAndGet();
            }
        }

        @Override
        public int compareTo(DuibaRunnable o) {
            if (this.getPriority() < o.getPriority()) {
                return 1;
            }
            if (this.getPriority() > o.getPriority()) {
                return -1;
            }
            return 0;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

