/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.tools;

import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.tools.UnicodeReader;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.io.Resources;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AnalysisCoupon<T> {
    private Splitter spl;
    private InputStream in;
    private BufferedReader br;
    private String next;
    private int fileCount = 0;
    private Function<List<String>, T> zhuanhuan;

    public AnalysisCoupon(String fileUrl, String fileType, Function<List<String>, T> zhuanhuan) throws BusinessException {
        if (StringUtils.isBlank((String)fileType)) {
            throw new BusinessException("\u521b\u5efa\u5238\u7801\u6587\u4ef6\u89e3\u6790\u5668\u5fc5\u987b\u6307\u5b9a\u6587\u4ef6\u683c\u5f0f");
        }
        if (!"csv".equals(fileType) && !"txt".equals(fileType)) {
            throw new BusinessException("\u6587\u4ef6\u89e3\u6790\u5668\u53ea\u652f\u6301csv\u548ctxt");
        }
        if ("csv".equals(fileType)) {
            this.spl = Splitter.on((String)",").trimResults().omitEmptyStrings();
        }
        if ("txt".equals(fileType)) {
            this.spl = Splitter.on((String)"\t").trimResults().omitEmptyStrings();
        }
        if (zhuanhuan == null) {
            throw new BusinessException("\u521b\u5efa\u89e3\u6790\u5668\u5fc5\u987b\u6307\u5b9a\u8f6c\u6362\u5668");
        }
        this.zhuanhuan = zhuanhuan;
        if (StringUtils.isBlank((String)fileUrl)) {
            throw new BusinessException("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            URL httpurl = new URL(fileUrl);
            this.in = Resources.asByteSource((URL)httpurl).openStream();
            this.br = new BufferedReader(new UnicodeReader(this.in, "UTF-8"));
            this.next = this.br.readLine();
        }
        catch (Exception e) {
            throw new BusinessException("\u83b7\u53d6\u5238\u7801\u6587\u4ef6\u5931\u8d25");
        }
    }

    public T next() {
        try {
            String line = this.br.readLine();
            if (StringUtils.isNotBlank((String)this.next)) {
                List ss = this.spl.splitToList((CharSequence)this.next);
                this.next = line;
                ++this.fileCount;
                return (T)this.zhuanhuan.apply((Object)ss);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public int getTotal() {
        return this.fileCount;
    }

    protected void finalize() throws Throwable {
        if (this.br != null) {
            this.br.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        System.out.println("\u89e3\u6790\u5668\u88ab\u56de\u6536");
        super.finalize();
    }
}

