/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.vo.ItemClassifyItemCountVO;
import cn.com.duiba.service.domain.vo.PaginationVO;
import cn.com.duiba.service.item.bo.ItemClassifyBo;
import cn.com.duiba.service.item.domain.dataobject.ItemClassifyDO;
import cn.com.duiba.service.item.domain.vo.ItemClassifyVO;
import cn.com.duiba.service.item.service.ItemClassifyService;
import cn.com.duiba.service.item.service.ItemService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemClassifyBoImpl
implements ItemClassifyBo {
    private static Logger log = LoggerFactory.getLogger(ItemClassifyBoImpl.class);
    @Autowired
    private ItemService itemService;
    @Autowired
    private ItemClassifyService itemClassifyService;

    @Override
    public List<ItemClassifyDO> findAllByType(String type) {
        return this.itemClassifyService.findAllByType(type);
    }

    @Override
    public PaginationVO<ItemClassifyVO> findItemClassifyPage(Map<String, Object> queryMap) {
        PaginationVO page = new PaginationVO();
        List<ItemClassifyDO> icList = this.itemClassifyService.findPage(queryMap);
        Map<Long, Integer> itemClassifysQuantityMap = this.getItemClassifysQuantityMap(icList);
        ArrayList<ItemClassifyVO> voList = new ArrayList<ItemClassifyVO>();
        if (icList != null && icList.size() > 0) {
            ItemClassifyVO vo = null;
            for (ItemClassifyDO i : icList) {
                vo = new ItemClassifyVO();
                vo.setId(i.getId());
                vo.setName(i.getName());
                vo.setType(i.getType());
                vo.setItemQuantity(Integer.valueOf(itemClassifysQuantityMap.get(i.getId()) == null ? 0 : itemClassifysQuantityMap.get(i.getId())));
                voList.add(vo);
            }
        }
        page.setRows(voList);
        page.setTotalCount(this.itemClassifyService.findPageCount(queryMap));
        return page;
    }

    @Override
    public ItemClassifyDO createByNameAndType(String name, String type) {
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)type)) {
            throw new RuntimeException("\u5206\u7c7b\u540d\u5b57\u6216\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ItemClassifyDO itemClassify = new ItemClassifyDO(Boolean.TRUE.booleanValue());
        itemClassify.setName(name);
        itemClassify.setType(type);
        this.itemClassifyService.insert(itemClassify);
        return itemClassify;
    }

    @Override
    public ItemClassifyDO updateByNameAndId(String name, Long id) {
        if (StringUtils.isBlank((String)name) || id == null) {
            throw new RuntimeException("\u5206\u7c7b\u540d\u5b57\u6216\u8005Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ItemClassifyDO itemClassify = new ItemClassifyDO(id);
        itemClassify.setName(name);
        this.itemClassifyService.updateName(itemClassify.getId(), name);
        return itemClassify;
    }

    @Override
    @Transactional(value="credits")
    public void delete(Long id) {
        if (id == null) {
            throw new RuntimeException("Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.itemService.updateItemClassifyIdNullByItemClassifyId(id);
        this.itemClassifyService.delete(id);
    }

    private Map<Long, Integer> getItemClassifysQuantityMap(List<ItemClassifyDO> icList) {
        HashMap<Long, Integer> result = null;
        if (icList == null || icList.size() == 0) {
            return new HashMap<Long, Integer>();
        }
        ArrayList<Long> icIds = new ArrayList<Long>();
        for (ItemClassifyDO t : icList) {
            icIds.add(t.getId());
        }
        List<ItemClassifyItemCountVO> voList = this.itemService.findItemClassifyCountMap(icIds);
        if (voList == null || voList.size() == 0) {
            return new HashMap<Long, Integer>();
        }
        result = new HashMap<Long, Integer>();
        for (ItemClassifyItemCountVO v : voList) {
            result.put(v.getItemClassifyId(), v.getItemCount());
        }
        return result;
    }

    @Override
    public List<ItemClassifyDO> findAllByIds(List<Long> ids) {
        return this.itemClassifyService.findAllByIds(ids);
    }
}

