/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.bo.TurntableStockOperateBo;
import cn.com.duiba.service.domain.dataobject.AppBannerDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.TurntableOrderDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.TurntableBo;
import cn.com.duiba.service.item.domain.dataobject.DuibaTurntableDO;
import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;
import cn.com.duiba.service.item.domain.dataobject.TurntableOptionsDO;
import cn.com.duiba.service.item.remoteservice.RemoteDuibaTurntableService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteOperatingActivityService;
import cn.com.duiba.service.remoteservice.RemoteAppBannerService;
import cn.com.duiba.service.remoteservice.RemoteAppItemService;
import cn.com.duiba.service.remoteservice.RemoteTurntableOptionsService;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TurntableBoImpl
implements TurntableBo {
    private static Logger log = LoggerFactory.getLogger(TurntableBoImpl.class);
    @Autowired
    private TurntableStockOperateBo turntableStockOperateBo;
    @Autowired
    private RemoteAppItemService remoteAppItemService;
    @Autowired
    private RemoteOperatingActivityService remoteOperatingActivityService;
    @Autowired
    private RemoteTurntableOptionsService remoteTurntableOptionsService;
    @Autowired
    private RemoteDuibaTurntableService remoteDuibaTurntableService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemoteAppBannerService remoteAppBannerService;

    private void checkData(String logo, String type, Long itemId, String rate, Integer remaining, String name) throws BusinessException {
        if (StringUtils.isBlank((String)logo)) {
            throw new BusinessException("\u5956\u9879\u56fe\u6807\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new BusinessException("\u5956\u9879\u6587\u6848\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!type.equals(String.valueOf(0)) && (StringUtils.isBlank((String)rate) || Double.valueOf(rate) < 0.0 || Double.valueOf(rate) > 100.0)) {
            throw new BusinessException("\u4e2d\u5956\u6982\u7387\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e100");
        }
        if (!type.equals(String.valueOf(0)) && !type.equals(String.valueOf(1))) {
            if (itemId == null) {
                throw new BusinessException("\u5956\u9879\u7684\u5956\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (remaining == null || remaining < 0) {
                throw new BusinessException("\u5269\u4f59\u5956\u54c1\u6570\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
            }
        }
    }

    @Override
    @Transactional(value="credits")
    public void saveOrUpdateDuibaTurntableOptions(Long turntableId, Long[] id, String[] type, String[] logo, Long[] itemId, String[] rate, Integer[] limitCount, Integer[] minComein, Integer[] remaining, Integer[] preRemaining, Integer[] facePrice, String[] name) throws BusinessException {
        DuibaTurntableDO dt;
        for (int i = 0; i < 8; ++i) {
            if (!StringUtils.isNotEmpty((String)type[i])) continue;
            this.checkData(logo[i], type[i], itemId[i], rate[i], remaining[i], name[i]);
            int num = i + 1;
            TurntableOptionsDO option = new TurntableOptionsDO(true);
            if (id[i] != null) {
                option = this.remoteTurntableOptionsService.findByIdAndNum(id[i], Integer.valueOf(num));
                option = new TurntableOptionsDO(option.getId());
            }
            option.setOperatingActivityId(turntableId);
            option.setNum(Integer.valueOf(num));
            option.setName(name[i]);
            option.setLogo(logo[i]);
            if (type[i].equals(String.valueOf(0)) || type[i].equals(String.valueOf(1))) {
                option.setItemId(Long.valueOf(0L));
                option.setFacePrice(Integer.valueOf(0));
                option.setRemaining(null);
                option.setMinComein(Integer.valueOf(0));
                option.setRate(StringUtils.isEmpty((String)rate[i]) ? null : rate[i]);
            } else {
                if (itemId[i] == null) {
                    throw new BusinessException("\u5956\u9879itemId\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                option.setItemId(itemId[i]);
                option.setFacePrice(Integer.valueOf(facePrice[i] == null ? 0 : Integer.valueOf(facePrice[i]) * 100));
                option.setMinComein(Integer.valueOf(minComein[i] == null ? 0 : minComein[i]));
                option.setRemaining(Integer.valueOf(remaining[i] == null ? 0 : remaining[i]));
                option.setRate(StringUtils.isEmpty((String)rate[i]) ? null : rate[i]);
                option.setLimitCount(Integer.valueOf(limitCount[i] == null ? 0 : limitCount[i]));
            }
            Pattern pattern = Pattern.compile("[0-9]*");
            if (!pattern.matcher(type[i]).matches()) {
                option.setType(Integer.valueOf(TurntableOrderDO.itemTypeToTurntableOrderType((String)type[i])));
            } else {
                option.setType(Integer.valueOf(type[i]));
            }
            option.setActivityType(Integer.valueOf(4));
            if (option.getId() == null) {
                this.remoteTurntableOptionsService.insertTurntableOption(option);
                continue;
            }
            this.turntableStockOperateBo.updateRemainingByEdit_duiba(option.getId(), preRemaining[i], remaining[i]);
            this.remoteTurntableOptionsService.updateTurntableOption(option);
        }
        Integer num = this.remoteTurntableOptionsService.countByTruntableId(turntableId, Integer.valueOf(4));
        if (num != 8) {
            DuibaTurntableDO dt4u = new DuibaTurntableDO(turntableId);
            dt4u.setStatus(Integer.valueOf(0));
            this.remoteDuibaTurntableService.update(dt4u);
        } else if (num == 8 && (dt = this.remoteDuibaTurntableService.find(turntableId)).getStatus() == 0) {
            DuibaTurntableDO dt4u = new DuibaTurntableDO(turntableId);
            dt4u.setStatus(Integer.valueOf(3));
            this.remoteDuibaTurntableService.update(dt4u);
        }
    }

    @Override
    @Transactional(value="credits")
    public void saveOrUpdateTurntableOptions(Long turntableId, Long appId, Long[] id, String[] type, String[] logo, Long[] appItemId, String[] rate, Integer[] limitCount, Integer[] minComein, Integer[] remaining, Integer[] preRemaining, Integer[] facePrice, String[] prizeDegree, String[] name) throws BusinessException {
        int i;
        boolean thanks = false;
        for (i = 0; i < type.length; ++i) {
            if (!String.valueOf(0).equals(type[i])) continue;
            thanks = true;
        }
        if (!thanks) {
            throw new BusinessException("\u5956\u9879\u5fc5\u987b\u6dfb\u52a0\u4e00\u4e2a\u8c22\u8c22\u53c2\u4e0e!");
        }
        for (i = 0; i < 8; ++i) {
            if (!StringUtils.isNotEmpty((String)type[i])) continue;
            this.checkOptionsData(type[i], logo[i], appItemId[i], rate[i], remaining[i], name[i]);
            int num = i + 1;
            TurntableOptionsDO option = new TurntableOptionsDO(true);
            if (id[i] != null) {
                option = this.remoteTurntableOptionsService.findOptionById(id[i]);
                option = new TurntableOptionsDO(option.getId());
            }
            option.setOperatingActivityId(turntableId);
            option.setNum(Integer.valueOf(num));
            option.setName(name[i]);
            option.setLogo(logo[i]);
            if (appItemId[i] == null && !type[i].equals(String.valueOf(0)) && !type[i].equals(String.valueOf(1))) {
                appItemId[i] = this.remoteAppItemService.saveAppItemByActivity(appId, type[i], Boolean.valueOf(true)).getId();
                if (appItemId[i] == null) {
                    throw new BusinessException("\u5956\u9879appItemId\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                option.setAppItemId(appItemId[i]);
            } else if (type[i].equals(String.valueOf(0)) || type[i].equals(String.valueOf(1))) {
                appItemId[i] = null;
                option.setFacePrice(Integer.valueOf(0));
                option.setRemaining(null);
                option.setMinComein(Integer.valueOf(0));
                option.setRate(StringUtils.isEmpty((String)rate[i]) ? null : rate[i]);
            } else {
                if (appItemId[i] == null) {
                    throw new BusinessException("\u5956\u9879appItemId\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ItemKey key = this.remoteItemKeyService.getItemKey(null, appItemId[i], appId);
                if (key.getAppItem() != null && !key.getAppItem().getAppId().equals(key.getApp().getId())) {
                    throw new BusinessException("APP\u65e0\u6b64\u5546\u54c1");
                }
                if (key.isItemMode() && key.getItem().getLimitCount() != null && key.getItem().getLimitCount() > 0) {
                    throw new BusinessException("\u5956\u9879\u4e0d\u80fd\u5305\u542b\u5151\u5427\u9650\u5236\u5151\u6362\u5546\u54c1");
                }
                option.setAppItemId(appItemId[i]);
                option.setFacePrice(Integer.valueOf(facePrice[i] == null ? 0 : Integer.valueOf(facePrice[i]) * 100));
                option.setMinComein(Integer.valueOf(minComein[i] == null ? 0 : minComein[i]));
                option.setRemaining(Integer.valueOf(remaining[i] == null ? 0 : remaining[i]));
                option.setRate(StringUtils.isEmpty((String)rate[i]) ? null : rate[i]);
                option.setLimitCount(Integer.valueOf(limitCount[i] == null ? 0 : limitCount[i]));
            }
            Pattern pattern = Pattern.compile("[0-9]*");
            if (!pattern.matcher(type[i]).matches()) {
                option.setType(Integer.valueOf(TurntableOrderDO.itemTypeToTurntableOrderType((String)type[i])));
                if (option.getType() == 7) {
                    option.setPrizeDegree(prizeDegree[i]);
                }
            } else {
                option.setType(Integer.valueOf(type[i]));
            }
            option.setActivityType(Integer.valueOf(1));
            if (option.getId() == null) {
                this.remoteTurntableOptionsService.insertTurntableOption(option);
                continue;
            }
            this.turntableStockOperateBo.updateRemainingByEdit(option.getId(), preRemaining[i], remaining[i]);
            this.remoteTurntableOptionsService.updateTurntableOption(option);
        }
        this.updateTruntableDateState(turntableId);
    }

    public Integer updateTruntableDateState(Long turntableId) {
        OperatingActivityDO activity = this.remoteOperatingActivityService.find(turntableId);
        Integer state = null;
        Integer num = this.remoteTurntableOptionsService.countByTruntableId(turntableId, activity.getType());
        if (num != 8) {
            state = 0;
        } else {
            AppBannerDO appBanner;
            AppItemDO appItem;
            boolean flg = false;
            if (activity.getAppItemId() != null && !(appItem = this.remoteAppItemService.find(activity.getAppItemId())).getDeleted().booleanValue()) {
                flg = true;
            }
            if (activity.getAppBannerId() != null && !(appBanner = this.remoteAppBannerService.find(activity.getAppBannerId())).getDeleted().booleanValue()) {
                flg = true;
            }
            state = flg ? Integer.valueOf(2) : Integer.valueOf(1);
        }
        activity.setStatus(state);
        OperatingActivityDO activity4u = new OperatingActivityDO(activity.getId());
        activity4u.setStatus(activity.getStatus());
        return this.remoteOperatingActivityService.update(activity4u);
    }

    private void checkOptionsData(String type, String logo, Long appItemId, String rate, Integer remaining, String name) throws BusinessException {
        if (StringUtils.isBlank((String)logo)) {
            throw new BusinessException("\u5956\u9879\u56fe\u6807\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new BusinessException("\u5956\u9879\u6587\u6848\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!type.equals(String.valueOf(0)) && (StringUtils.isBlank((String)rate) || Double.valueOf(rate) < 0.0 || Double.valueOf(rate) > 100.0)) {
            throw new BusinessException("\u4e2d\u5956\u6982\u7387\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u5c0f\u4e8e\u7b49\u4e8e100");
        }
        if (!(type.equals(String.valueOf(0)) || type.equals(String.valueOf(1)) || remaining != null && remaining >= 0)) {
            throw new BusinessException("\u5269\u4f59\u5956\u54c1\u6570\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        if ((type.equals(String.valueOf(7)) || type.equals(String.valueOf(5)) || type.equals(String.valueOf(4))) && appItemId == null) {
            throw new BusinessException("\u5956\u9879\u7684\u5956\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }
}

