/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppBannerDO;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.DeveloperBlacklistDO;
import cn.com.duiba.service.domain.dataobject.DuibaHdtoolDO;
import cn.com.duiba.service.domain.dataobject.HdtoolAppSpecifyDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.DuibaHdtoolBo;
import cn.com.duiba.service.item.domain.dataobject.DuibaActivityDO;
import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;
import cn.com.duiba.service.item.remoteservice.RemoteOperatingActivityService;
import cn.com.duiba.service.remoteservice.RemoteAppBannerService;
import cn.com.duiba.service.remoteservice.RemoteAppItemService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteDuibaHdtoolService;
import cn.com.duiba.service.service.DeveloperBlacklistService;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class DuibaHdtoolBoImpl
implements DuibaHdtoolBo {
    private static Logger log = LoggerFactory.getLogger(DuibaHdtoolBoImpl.class);
    @Autowired
    private RemoteAppItemService remoteAppItemService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private RemoteOperatingActivityService remoteOperatingActivityService;
    @Autowired
    private DeveloperBlacklistService developerBlacklistService;
    @Autowired
    private RemoteDuibaHdtoolService remoteDuibaHdtoolService;
    @Autowired
    private RemoteAppBannerService remoteAppBannerService;
    @Autowired
    private RemoteAppService remoteAppService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuibaHdtoolDO closeDuibaTurntable(Long hdToolsId, Integer status) {
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            DuibaHdtoolDO d;
            DuibaHdtoolDO duibaHdtoolDO = d = this.updateNoTransaction(hdToolsId, status);
            return duibaHdtoolDO;
        }
        catch (Exception e) {
            transaction.setRollbackOnly();
            log.error("\u4fee\u6539\u6570\u636e\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.transactionManager.commit(transaction);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DuibaHdtoolDO deleteDuibaHdTool(Long hdToolId) {
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            DuibaHdtoolDO d = this.updateNoTransaction(hdToolId, 3);
            this.remoteDuibaHdtoolService.deleteById(hdToolId);
            DuibaHdtoolDO duibaHdtoolDO = d;
            return duibaHdtoolDO;
        }
        catch (Exception e) {
            transaction.setRollbackOnly();
            log.error("\u5220\u9664\u5151\u5427\u5927\u8f6c\u76d8\u6d3b\u52a8\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.transactionManager.commit(transaction);
        }
        return null;
    }

    private DuibaHdtoolDO updateNoTransaction(Long hdToolsId, Integer status) {
        DuibaHdtoolDO dt = this.remoteDuibaHdtoolService.find(hdToolsId);
        if (dt.getType() == 1) {
            this.remoteOperatingActivityService.updateStatusByActivityIdAndType(hdToolsId, Integer.valueOf(6), Integer.valueOf(3));
            this.remoteAppBannerService.disableByActivityId(Boolean.valueOf(true), hdToolsId, Integer.valueOf(6));
            this.remoteAppItemService.updateStatusByActivityId("off", Boolean.valueOf(true), hdToolsId, Integer.valueOf(6));
            this.remoteDuibaHdtoolService.updateStatus(hdToolsId, status);
        } else if (dt.getType() == 2) {
            this.remoteOperatingActivityService.updateStatusByActivityIdAndType(hdToolsId, Integer.valueOf(7), Integer.valueOf(3));
            this.remoteAppBannerService.disableByActivityId(Boolean.valueOf(true), hdToolsId, Integer.valueOf(7));
            this.remoteAppItemService.updateStatusByActivityId("off", Boolean.valueOf(true), hdToolsId, Integer.valueOf(7));
            this.remoteDuibaHdtoolService.updateStatus(hdToolsId, status);
        } else if (dt.getType() == 4) {
            this.remoteOperatingActivityService.updateStatusByActivityIdAndType(hdToolsId, Integer.valueOf(9), Integer.valueOf(3));
            this.remoteAppBannerService.disableByActivityId(Boolean.valueOf(true), hdToolsId, Integer.valueOf(9));
            this.remoteAppItemService.updateStatusByActivityId("off", Boolean.valueOf(true), hdToolsId, Integer.valueOf(9));
            this.remoteDuibaHdtoolService.updateStatus(hdToolsId, status);
        } else if (dt.getType() == 3) {
            this.remoteOperatingActivityService.updateStatusByActivityIdAndType(hdToolsId, Integer.valueOf(8), Integer.valueOf(3));
            this.remoteAppBannerService.disableByActivityId(Boolean.valueOf(true), hdToolsId, Integer.valueOf(8));
            this.remoteAppItemService.updateStatusByActivityId("off", Boolean.valueOf(true), hdToolsId, Integer.valueOf(8));
            this.remoteDuibaHdtoolService.updateStatus(hdToolsId, status);
        }
        dt.setStatus(status);
        return dt;
    }

    @Override
    public Long addDuibaHdToolToDeveloper(Long appId, Long duibaHdtoolId) throws BusinessException {
        AppDO app = this.remoteAppService.find(appId);
        if (app == null) {
            throw new BusinessException("app not exist");
        }
        DuibaHdtoolDO duibaHdtool = this.remoteDuibaHdtoolService.find(duibaHdtoolId);
        if (duibaHdtool == null || duibaHdtool.getDeleted().booleanValue()) {
            throw new BusinessException("\u6d3b\u52a8\u5df2\u5220\u9664");
        }
        if (1 != duibaHdtool.getStatus()) {
            throw new BusinessException("\u6d3b\u52a8\u672a\u5f00\u542f");
        }
        DeveloperBlacklistDO devBlacklist = this.developerBlacklistService.findByDeveloperId(app.getDeveloperId());
        if (devBlacklist != null && duibaHdtool.isOpenSwitch(DuibaActivityDO.SWITCHES_DEV_BLACKLIST.intValue())) {
            throw new BusinessException("\u6d3b\u52a8\u9ed1\u540d\u5355");
        }
        if (!this.isDirect(appId, duibaHdtool).booleanValue()) {
            throw new BusinessException("\u672a\u5b9a\u5411\u6d3b\u52a8");
        }
        OperatingActivityDO activity = null;
        if (duibaHdtool.getType() == 1) {
            activity = this.remoteOperatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(duibaHdtool.getId(), Integer.valueOf(6), appId, null);
        } else if (duibaHdtool.getType() == 2) {
            activity = this.remoteOperatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(duibaHdtool.getId(), Integer.valueOf(7), appId, null);
        } else if (duibaHdtool.getType() == 4) {
            activity = this.remoteOperatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(duibaHdtool.getId(), Integer.valueOf(9), appId, null);
        } else if (duibaHdtool.getType() == 3) {
            activity = this.remoteOperatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(duibaHdtool.getId(), Integer.valueOf(8), appId, null);
        }
        if (activity == null) {
            activity = new OperatingActivityDO(true);
        } else {
            activity = new OperatingActivityDO(activity.getId());
            activity.setDeleted(Boolean.valueOf(false));
        }
        if (duibaHdtool.getType() == 1) {
            activity.setType(Integer.valueOf(6));
        } else if (duibaHdtool.getType() == 2) {
            activity.setType(Integer.valueOf(7));
        } else if (duibaHdtool.getType() == 4) {
            activity.setType(Integer.valueOf(9));
        } else if (duibaHdtool.getType() == 3) {
            activity.setType(Integer.valueOf(8));
        }
        activity.setAppId(appId);
        activity.setActivityId(duibaHdtool.getId());
        activity.setTitle(duibaHdtool.getTitle());
        activity.setStatus(Integer.valueOf(1));
        if (duibaHdtool.getCreditsType() == 1) {
            activity.setCredits(Long.valueOf(duibaHdtool.getCreditsPrice()));
        } else {
            activity.setCredits(Long.valueOf(0L));
        }
        activity.setCreditsType(duibaHdtool.getCreditsType());
        activity.setSubType(duibaHdtool.getSubType());
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            if (activity.getId() == null) {
                OperatingActivityDO temp = this.remoteOperatingActivityService.insert(activity);
                activity.setId(temp.getId());
                AppItemDO appItemDO = new AppItemDO(true);
                appItemDO.setDeleted(Boolean.valueOf(true));
                appItemDO.setAppId(appId);
                if (duibaHdtool.getCreditsType() == 1) {
                    appItemDO.setCredits(Long.valueOf(duibaHdtool.getCreditsPrice()));
                } else {
                    appItemDO.setCredits(Long.valueOf(0L));
                }
                appItemDO.setCustomPrice("duiba");
                appItemDO.setTitle(duibaHdtool.getTitle());
                appItemDO.setSubtitle(duibaHdtool.getTitle());
                appItemDO.setSubStatus(duibaHdtool.getTitle());
                appItemDO.setLogo(duibaHdtool.getLogo());
                appItemDO.setSmallImage(duibaHdtool.getSmallImage());
                appItemDO.setWhiteImage(duibaHdtool.getWhiteImage());
                appItemDO.setType("fake");
                appItemDO.setSourceType(Integer.valueOf(1));
                appItemDO.setSourceRelationId(activity.getId());
                this.remoteAppItemService.saveAppItemByTurntableNoTranscation(appItemDO, activity.getId().longValue());
                AppBannerDO appBanner = new AppBannerDO(true);
                appBanner.setAppId(appId);
                appBanner.setDeleted(Boolean.valueOf(true));
                appBanner.setImage(duibaHdtool.getBannerImage());
                appBanner.setType("banner");
                appBanner.setSourceType(Integer.valueOf(1));
                appBanner.setSourceRelationId(activity.getId());
                this.remoteAppBannerService.saveAppBannerByTurntableNoTranscation(appBanner, activity.getId().longValue());
            } else {
                activity.setGmtModified(new Date());
                this.remoteOperatingActivityService.update(activity);
            }
        }
        catch (Exception e) {
            transaction.setRollbackOnly();
            log.error("\u6dfb\u52a0\u62bd\u5956\u5230\u5f00\u53d1\u8005\u8fd0\u8425\u6d3b\u52a8\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            this.transactionManager.commit(transaction);
        }
        return activity.getId();
    }

    private Boolean isDirect(Long appId, DuibaHdtoolDO duibaHdtool) {
        if (duibaHdtool.isOpenSwitch(0)) {
            HdtoolAppSpecifyDO tas = this.remoteDuibaHdtoolService.findSpecifyByHdToolIdAndApp(duibaHdtool.getId(), appId);
            if (tas == null) {
                return false;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update_duiba(DuibaHdtoolDO duibaHdtoolDO) {
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            AppItemDO t;
            DuibaHdtoolDO oldHdToolDO = this.remoteDuibaHdtoolService.find(duibaHdtoolDO.getId());
            this.remoteDuibaHdtoolService.update(duibaHdtoolDO);
            ArrayList<Long> activityIds = new ArrayList<Long>();
            activityIds.add(oldHdToolDO.getId());
            List operatingActivityList = new ArrayList();
            if (oldHdToolDO.getType() == 1) {
                operatingActivityList = this.remoteOperatingActivityService.findAllByActivityIdsAndType(activityIds, Integer.valueOf(6));
            } else if (oldHdToolDO.getType() == 2) {
                operatingActivityList = this.remoteOperatingActivityService.findAllByActivityIdsAndType(activityIds, Integer.valueOf(7));
            } else if (oldHdToolDO.getType() == 4) {
                operatingActivityList = this.remoteOperatingActivityService.findAllByActivityIdsAndType(activityIds, Integer.valueOf(9));
            } else if (oldHdToolDO.getType() == 3) {
                operatingActivityList = this.remoteOperatingActivityService.findAllByActivityIdsAndType(activityIds, Integer.valueOf(8));
            }
            ArrayList<Long> appItemIds = new ArrayList<Long>();
            ArrayList<Long> appBannerIds = new ArrayList<Long>();
            if (operatingActivityList != null && operatingActivityList.size() > 0) {
                for (OperatingActivityDO o : operatingActivityList) {
                    if (o.getAppItemId() != null) {
                        appItemIds.add(o.getAppItemId());
                    }
                    if (o.getAppBannerId() != null) {
                        appBannerIds.add(o.getAppBannerId());
                    }
                    OperatingActivityDO t2 = new OperatingActivityDO(o.getId());
                    if (oldHdToolDO.getTitle().trim().equals(o.getTitle().trim()) && !duibaHdtoolDO.getTitle().trim().equals(o.getTitle().trim())) {
                        t2.setTitle(duibaHdtoolDO.getTitle());
                    }
                    if (duibaHdtoolDO.getCreditsType() == 1) {
                        t2.setCredits(Long.valueOf(duibaHdtoolDO.getCreditsPrice()));
                    } else {
                        t2.setCredits(Long.valueOf(0L));
                    }
                    this.remoteOperatingActivityService.update(t2);
                }
            }
            List appItemList = new ArrayList();
            List appBannerList = new ArrayList();
            if (appItemIds.size() > 0) {
                appItemList = this.remoteAppItemService.findAllByIds(appItemIds);
                for (AppItemDO a : appItemList) {
                    t = new AppItemDO(a.getId());
                    if (StringUtils.isNotBlank((String)oldHdToolDO.getTitle()) && oldHdToolDO.getTitle().trim().equals(a.getTitle().trim()) && !duibaHdtoolDO.getTitle().trim().equals(a.getTitle().trim())) {
                        t.setTitle(duibaHdtoolDO.getTitle());
                    }
                    if (StringUtils.isBlank((String)a.getSmallImage()) || Objects.equal((Object)a.getSmallImage(), (Object)oldHdToolDO.getSmallImage())) {
                        t.setSmallImage(duibaHdtoolDO.getSmallImage());
                    }
                    if (StringUtils.isBlank((String)a.getWhiteImage()) || Objects.equal((Object)a.getWhiteImage(), (Object)oldHdToolDO.getWhiteImage())) {
                        t.setWhiteImage(duibaHdtoolDO.getWhiteImage());
                    }
                    if (duibaHdtoolDO.getCreditsType() == 1) {
                        t.setCredits(Long.valueOf(duibaHdtoolDO.getCreditsPrice()));
                    } else {
                        t.setCredits(Long.valueOf(0L));
                    }
                    t.setCustomPrice("duiba");
                    this.remoteAppItemService.updateHdtoolAppItem(t.getId(), t.getTitle(), t.getSmallImage(), t.getWhiteImage(), t.getCredits(), t.getCustomPrice(), duibaHdtoolDO.getLogo());
                }
            }
            if (appBannerIds.size() > 0) {
                appBannerList = this.remoteAppBannerService.findAllByIds(appBannerIds);
                for (AppItemDO a : appBannerList) {
                    t = new AppBannerDO(a.getId());
                    if (StringUtils.isNotBlank((String)oldHdToolDO.getBannerImage()) && oldHdToolDO.getBannerImage().trim().equals(a.getImage().trim()) && !duibaHdtoolDO.getBannerImage().trim().equals(a.getImage().trim())) {
                        t.setImage(duibaHdtoolDO.getBannerImage());
                    }
                    if (StringUtils.isNotBlank((String)oldHdToolDO.getTitle()) && oldHdToolDO.getTitle().trim().equals(a.getName().trim()) && !duibaHdtoolDO.getTitle().trim().equals(a.getName().trim())) {
                        t.setName(duibaHdtoolDO.getTitle());
                    }
                    if (t.getImage() == null && t.getName() == null) continue;
                    this.remoteAppBannerService.update((AppBannerDO)t);
                }
            }
        }
        catch (Exception e) {
            transaction.setRollbackOnly();
            log.error("\u4fee\u6539\u5151\u5427\u5927\u8f6c\u76d8\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.transactionManager.commit(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDuibaTurntable(Long hdToolsId) {
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            DuibaHdtoolDO activity = this.remoteDuibaHdtoolService.find(hdToolsId);
            if (activity.getType() == 1) {
                this.remoteOperatingActivityService.updateStatusByActivityIdAndType(hdToolsId, Integer.valueOf(6), Integer.valueOf(1));
            } else if (activity.getType() == 2) {
                this.remoteOperatingActivityService.updateStatusByActivityIdAndType(hdToolsId, Integer.valueOf(7), Integer.valueOf(1));
            } else if (activity.getType() == 4) {
                this.remoteOperatingActivityService.updateStatusByActivityIdAndType(hdToolsId, Integer.valueOf(9), Integer.valueOf(1));
            } else if (activity.getType() == 3) {
                this.remoteOperatingActivityService.updateStatusByActivityIdAndType(hdToolsId, Integer.valueOf(8), Integer.valueOf(1));
            }
            this.remoteDuibaHdtoolService.updateStatus(hdToolsId, Integer.valueOf(1));
        }
        catch (Exception e) {
            transaction.setRollbackOnly();
            log.error("\u4fee\u6539\u6570\u636e\u72b6\u6001\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.transactionManager.commit(transaction);
        }
    }
}

