/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.event;

import cn.com.duiba.service.item.event.DuibaEvent;
import cn.com.duiba.service.item.event.DuibaEventsRegister;
import cn.com.duiba.service.item.event.ItemEvent;
import cn.com.duiba.service.item.event.ThreadPoolDuibaService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuibaEventsDispatcher {
    private static Logger log = LoggerFactory.getLogger(DuibaEventsDispatcher.class);
    private static DuibaEventsDispatcher dispatcher = new DuibaEventsDispatcher();

    public static DuibaEventsDispatcher get() {
        return dispatcher;
    }

    public void dispatchEvent(DuibaEvent<?> e) {
        log.info("className: " + this.getClass().getName() + "   method: dispatchEvent  " + e.getClass().getName());
        if (e instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)e);
        }
    }

    private void processItemEvent(final ItemEvent be) {
        final List<ItemEvent.ItemEventListener> listeners = DuibaEventsRegister.get().itemEventListeners;
        if (!listeners.isEmpty()) {
            ThreadPoolDuibaService.get().submit(new Runnable(){

                @Override
                public void run() {
                    for (ItemEvent.ItemEventListener iel : new ArrayList(listeners)) {
                        try {
                            if (be.getType() == ItemEvent.ItemEventType.onShelfOn) {
                                iel.onShelfOn(be.getData());
                                continue;
                            }
                            if (be.getType() == ItemEvent.ItemEventType.onShelfOff) {
                                iel.onShelfOff(be.getData());
                                continue;
                            }
                            if (be.getType() != ItemEvent.ItemEventType.onDeleted) continue;
                            iel.onDeleted(be.getData());
                        }
                        catch (Exception e) {
                            log.error("processBannerEvent", (Throwable)e);
                        }
                    }
                }
            }, 5);
        }
    }
}

