/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.event.realtime;

import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.event.DuibaEventsRegister;
import cn.com.duiba.service.item.event.ItemEvent;
import cn.com.duiba.wolf.cache.CacheClient;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StatusModifyRealtime
implements InitializingBean {
    @Autowired
    private CacheClient memcachedClient;
    protected Logger log = LoggerFactory.getLogger(StatusModifyRealtime.class);
    private Long appId = 1534L;

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().registItemEvent(new ItemEvent.ItemEventListener(){

            @Override
            public void onShelfOn(ItemKey itemKey) {
                try {
                    if (itemKey.getApp() != null && itemKey.getApp().getId().equals(StatusModifyRealtime.this.appId)) {
                        HashMap<String, String> paramsMap = new HashMap<String, String>();
                        ItemKeyVO vo = new ItemKeyVO(itemKey);
                        String name = vo.getTitle();
                        paramsMap.put("name", name);
                        paramsMap.put("position", "item");
                        paramsMap.put("event", "shelf-on");
                        paramsMap.put("timestamp", System.currentTimeMillis() + "");
                        paramsMap.put("appKey", itemKey.getApp().getAppKey());
                        paramsMap.put("appSecret", itemKey.getApp().getAppSecret());
                        String sign = SignTool.sign(paramsMap);
                        name = URLEncoder.encode(name, "utf-8");
                        String params = "position=item&name=" + name + "&event=shelf-on&timestamp=" + System.currentTimeMillis() + "&appKey=" + itemKey.getApp().getAppKey() + "&sign=" + sign;
                        try {
                            StatusModifyRealtime.this.sendNotify(itemKey.getApp().getId(), params);
                        }
                        catch (Exception e) {
                            StatusModifyRealtime.this.log.error("\u4e0a\u67b6\u901a\u77e5\u5f02\u5e38,appId=" + itemKey.getApp().getId(), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    StatusModifyRealtime.this.log.error("\u4e0a\u67b6\u901a\u77e5\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }

            @Override
            public void onShelfOff(ItemKey itemKey) {
                try {
                    if (itemKey.getApp() != null && itemKey.getApp().getId().equals(StatusModifyRealtime.this.appId)) {
                        HashMap<String, String> paramsMap = new HashMap<String, String>();
                        ItemKeyVO vo = new ItemKeyVO(itemKey);
                        String name = vo.getTitle();
                        paramsMap.put("name", name);
                        paramsMap.put("position", "item");
                        paramsMap.put("event", "shelf-off");
                        paramsMap.put("timestamp", System.currentTimeMillis() + "");
                        paramsMap.put("appKey", itemKey.getApp().getAppKey());
                        paramsMap.put("appSecret", itemKey.getApp().getAppSecret());
                        String sign = SignTool.sign(paramsMap);
                        name = URLEncoder.encode(name, "utf-8");
                        String params = "position=item&name=" + name + "&event=shelf-off&timestamp=" + System.currentTimeMillis() + "&appKey=" + itemKey.getApp().getAppKey() + "&sign=" + sign;
                        try {
                            StatusModifyRealtime.this.sendNotify(itemKey.getApp().getId(), params);
                        }
                        catch (Exception e) {
                            StatusModifyRealtime.this.log.error("\u4e0a\u67b6\u901a\u77e5\u5f02\u5e38,appId=" + itemKey.getApp().getId(), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    StatusModifyRealtime.this.log.error("\u4e0b\u67b6\u901a\u77e5\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }

            @Override
            public void onDeleted(ItemKey itemKey) {
            }
        });
    }

    public void sendNotify(Long appId, String params) throws Exception {
        String key = "105wochacha";
        String url = (String)this.memcachedClient.get(key);
        if (url == null) {
            url = "http://iphone.wochacha.com/api/duibadatachange?";
        }
        url = url + params;
        HttpPost request = new HttpPost(url);
        request.setConfig(StatusModifyRealtime.getDefaultConfig());
        try {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            this.log.info("\u4e0a\u4e0b\u67b6\u901a\u77e5url:" + url);
            httpClient.execute((HttpUriRequest)request);
        }
        catch (Exception e1) {
            this.log.error("\u4e0a\u4e0b\u67b6\u901a\u77e5\u7f51\u7edc\u5f02\u5e38:" + e1.getMessage(), (Throwable)e1);
        }
    }

    private static RequestConfig getDefaultConfig() {
        return RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
    }
}

