/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.PriceDegree;
import cn.com.duiba.service.item.bo.CreditsCalculateBo;
import cn.com.duiba.service.item.bo.PreStockBo;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreditsCalculateBoImpl
implements CreditsCalculateBo {
    @Autowired
    private PreStockBo preStockBo;

    public Map<String, Map<String, String>> parseDegreeCredits(PriceDegree pd, AppDO app) {
        Map degreeMap = pd.getCustomDegree();
        for (String key : degreeMap.keySet()) {
            Long degree = Long.valueOf(key);
            Map map = (Map)pd.getCustomDegree().get(key);
            String v = (String)map.get("credits");
            Long credits = null;
            credits = v == null ? Long.valueOf(degree * (long)app.getCreditsRate().intValue() * 1L) : Long.valueOf(v);
            map.put("credits", String.valueOf(credits));
        }
        return degreeMap;
    }

    @Override
    public Long calculateCreditsByCreditsPrice(Long creditsPrice, AppDO app) {
        long credits = (long)Math.ceil((double)(creditsPrice * (long)app.getCreditsRate().intValue()) / 100.0);
        if (credits < 1L) {
            credits = 1L;
        }
        return credits;
    }

    @Override
    public Long calculateCreditsByItemKeyAndDegree(ItemKey key, String degree) {
        if ("fake".equals(key.getItemType()) && key.getAppItem() != null && key.getAppItem().getCustomPrice() != null && key.getAppItem().getCustomPrice().contains("duiba")) {
            Long creditsLong = (long)Math.ceil((double)(key.getAppItem().getCredits() * (long)key.getApp().getCreditsRate().intValue()) / 100.0);
            return creditsLong;
        }
        if (key.isItemMode()) {
            Integer minFacePrice;
            long credits = (long)Math.ceil((double)((long)key.getItem().getFacePrice().intValue() * (long)key.getApp().getCreditsRate().intValue()) / 100.0);
            if (key.getItem().isOpTypeItem(10) && null != (minFacePrice = this.preStockBo.getMinExchangePrice(key.getItem(), key.getApp()))) {
                credits = (long)Math.ceil((double)((long)minFacePrice.intValue() * (long)key.getApp().getCreditsRate().intValue()) / 100.0);
            }
            if (credits < 1L) {
                credits = 1L;
            }
            return credits;
        }
        if (key.isDuibaAppItemMode()) {
            if ("phoneflow".equals(key.getItem().getType())) {
                if (degree == null) {
                    return (long)key.getApp().getCreditsRate();
                }
                return Long.valueOf(degree) * (long)key.getApp().getCreditsRate().intValue();
            }
            if ("alipay".equals(key.getItem().getType()) || "alipaycode".equals(key.getItem().getType()) || "alipayfast".equals(key.getItem().getType()) || "qb".equals(key.getItem().getType()) || "phonebill".equals(key.getItem().getType())) {
                if (degree == null) {
                    PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
                    if (pd.getMinDegreeCredits() == null) {
                        return (long)(pd.getMinDegreeInt() * key.getApp().getCreditsRate()) * 1L;
                    }
                    return Long.valueOf(pd.getMinDegreeCredits());
                }
                PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
                if (pd.isDegreeExist(degree)) {
                    if (pd.getCreditsByDegree(degree) == null) {
                        return Long.valueOf(degree) * (long)key.getApp().getCreditsRate().intValue();
                    }
                    return Long.valueOf(pd.getCreditsByDegree(degree));
                }
                throw new RuntimeException("\u76ee\u524d\u65e0\u6cd5\u5151\u6362\uff0c\u8be5\u5151\u6362\u6863\u4f4d\u4e0d\u5b58\u5728(9)");
            }
            if ("coupon".equals(key.getItem().getType()) || "object".equals(key.getItem().getType()) || "phonebillDingzhi".equals(key.getItem().getType())) {
                Long credits = null;
                if (key.getAppItem().getCredits() != null) {
                    credits = key.getAppItem().getCredits();
                } else {
                    Integer minFacePrice;
                    credits = (long)Math.ceil((double)((long)key.getItem().getFacePrice().intValue() * (long)key.getApp().getCreditsRate().intValue()) / 100.0);
                    if (key.getItem().isOpTypeItem(10) && null != (minFacePrice = this.preStockBo.getMinExchangePrice(key.getItem(), key.getApp()))) {
                        credits = (long)Math.ceil((double)((long)minFacePrice.intValue() * (long)key.getApp().getCreditsRate().intValue()) / 100.0);
                    }
                }
                if (credits < 1L) {
                    credits = 1L;
                }
                return credits;
            }
            throw new RuntimeException("\u4e0d\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u5546\u54c1\uff01");
        }
        if (key.isSelfAppItemMode()) {
            if ("virtual".equals(key.getAppItem().getType())) {
                PriceDegree pd = new PriceDegree(key.getAppItem().getCustomPrice());
                if (degree == null) {
                    return pd.getMinDegreeCredits() == null ? null : Long.valueOf(pd.getMinDegreeCredits());
                }
                return pd.getCreditsByDegree(degree) == null ? null : Long.valueOf(pd.getCreditsByDegree(degree));
            }
            Long credits = key.getAppItem().getCredits();
            return credits;
        }
        throw new RuntimeException("\u4e0d\u5b58\u5728\u6b64\u6a21\u5f0f\uff01");
    }

    @Override
    public String convertCreditsUnit(Long credits) {
        String ret = "";
        ret = credits >= 10000L && credits % 1000L == 0L ? new BigDecimal(credits).divide(new BigDecimal(10000)) + "\u4e07" : credits + "";
        return ret;
    }

    @Override
    public String convertCreditsUnit4Consumer(Long credits, AppDO app) {
        String ret = "";
        if (credits == null) {
            return ret;
        }
        if (app.isAppSwitch(8)) {
            if (credits >= 1000000L && credits % 100000L == 0L) {
                ret = new BigDecimal(credits).divide(new BigDecimal(1000000)) + "\u4e07";
            } else {
                DecimalFormat df = new DecimalFormat("#0.00");
                ret = df.format(Double.valueOf(credits.longValue()) / 100.0) + "";
            }
        } else {
            ret = credits >= 10000L && credits % 1000L == 0L ? new BigDecimal(credits).divide(new BigDecimal(10000)) + "\u4e07" : credits + "";
        }
        return ret;
    }

    @Override
    public String convertMoneyUnit4Consumer(Long money) {
        String ret = "";
        if (money == null) {
            return ret;
        }
        if (money >= 1000000L && money % 100000L == 0L) {
            ret = new BigDecimal(money).divide(new BigDecimal(1000000)) + "\u4e07";
        } else {
            DecimalFormat df = new DecimalFormat("#0.00");
            ret = df.format(Double.valueOf(money.longValue()) / 100.0) + "";
        }
        return ret;
    }
}

