/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppBannerDO;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.DeveloperBlacklistDO;
import cn.com.duiba.service.domain.dataobject.DuibaHdtoolDO;
import cn.com.duiba.service.domain.dataobject.HdtoolAppSpecifyDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.AppBannerBo;
import cn.com.duiba.service.item.bo.AppItemBo;
import cn.com.duiba.service.item.bo.DuibaHdtoolBo;
import cn.com.duiba.service.item.domain.dataobject.DuibaActivityDO;
import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.OperatingActivityService;
import cn.com.duiba.service.service.AppBannerService;
import cn.com.duiba.service.service.AppService;
import cn.com.duiba.service.service.DeveloperBlacklistService;
import cn.com.duiba.service.service.DuibaHdtoolService;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DuibaHdtoolBoImpl
implements DuibaHdtoolBo {
    private static Logger log = LoggerFactory.getLogger(DuibaHdtoolBoImpl.class);
    @Autowired
    private AppItemService appItemService;
    @Autowired
    private OperatingActivityService operatingActivityService;
    @Autowired
    private DeveloperBlacklistService developerBlacklistService;
    @Autowired
    private DuibaHdtoolService duibaHdtoolService;
    @Autowired
    private AppBannerService appBannerService;
    @Autowired
    private AppService appService;
    @Autowired
    private AppBannerBo appBannerBo;
    @Autowired
    private AppItemBo appItemBo;

    @Override
    @Transactional(value="credits")
    public DuibaHdtoolDO closeDuibaTurntable(Long hdToolsId, Integer status) {
        DuibaHdtoolDO d = this.updateNoTransaction(hdToolsId, status);
        return d;
    }

    @Override
    @Transactional(value="credits")
    public DuibaHdtoolDO deleteDuibaHdTool(Long hdToolId) {
        DuibaHdtoolDO d = this.updateNoTransaction(hdToolId, 3);
        this.duibaHdtoolService.deleteById(hdToolId);
        return d;
    }

    private DuibaHdtoolDO updateNoTransaction(Long hdToolsId, Integer status) {
        DuibaHdtoolDO dt = this.duibaHdtoolService.find(hdToolsId);
        if (dt.getType() == 1) {
            this.operatingActivityService.updateStatusByActivityIdAndType(hdToolsId, 6, 3);
            this.appBannerService.disableByActivityId(Boolean.valueOf(true), hdToolsId, Integer.valueOf(6));
            this.appItemService.updateStatusByActivityId("off", true, hdToolsId, 6);
            this.duibaHdtoolService.updateStatus(hdToolsId, status);
        } else if (dt.getType() == 2) {
            this.operatingActivityService.updateStatusByActivityIdAndType(hdToolsId, 7, 3);
            this.appBannerService.disableByActivityId(Boolean.valueOf(true), hdToolsId, Integer.valueOf(7));
            this.appItemService.updateStatusByActivityId("off", true, hdToolsId, 7);
            this.duibaHdtoolService.updateStatus(hdToolsId, status);
        } else if (dt.getType() == 4) {
            this.operatingActivityService.updateStatusByActivityIdAndType(hdToolsId, 9, 3);
            this.appBannerService.disableByActivityId(Boolean.valueOf(true), hdToolsId, Integer.valueOf(9));
            this.appItemService.updateStatusByActivityId("off", true, hdToolsId, 9);
            this.duibaHdtoolService.updateStatus(hdToolsId, status);
        } else if (dt.getType() == 3) {
            this.operatingActivityService.updateStatusByActivityIdAndType(hdToolsId, 8, 3);
            this.appBannerService.disableByActivityId(Boolean.valueOf(true), hdToolsId, Integer.valueOf(8));
            this.appItemService.updateStatusByActivityId("off", true, hdToolsId, 8);
            this.duibaHdtoolService.updateStatus(hdToolsId, status);
        }
        dt.setStatus(status);
        return dt;
    }

    @Override
    @Transactional(value="credits")
    public Long addDuibaHdToolToDeveloper(Long appId, Long duibaHdtoolId) throws BusinessException {
        AppDO app = this.appService.find(appId);
        if (app == null) {
            throw new BusinessException("app not exist");
        }
        DuibaHdtoolDO duibaHdtool = this.duibaHdtoolService.find(duibaHdtoolId);
        if (duibaHdtool == null || duibaHdtool.getDeleted().booleanValue()) {
            throw new BusinessException("\u6d3b\u52a8\u5df2\u5220\u9664");
        }
        if (1 != duibaHdtool.getStatus()) {
            throw new BusinessException("\u6d3b\u52a8\u672a\u5f00\u542f");
        }
        DeveloperBlacklistDO devBlacklist = this.developerBlacklistService.findByDeveloperId(app.getDeveloperId());
        if (devBlacklist != null && duibaHdtool.isOpenSwitch(DuibaActivityDO.SWITCHES_DEV_BLACKLIST.intValue())) {
            throw new BusinessException("\u6d3b\u52a8\u9ed1\u540d\u5355");
        }
        if (!this.isDirect(appId, duibaHdtool).booleanValue()) {
            throw new BusinessException("\u672a\u5b9a\u5411\u6d3b\u52a8");
        }
        OperatingActivityDO activity = null;
        if (duibaHdtool.getType() == 1) {
            activity = this.operatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(duibaHdtool.getId(), 6, appId, null);
        } else if (duibaHdtool.getType() == 2) {
            activity = this.operatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(duibaHdtool.getId(), 7, appId, null);
        } else if (duibaHdtool.getType() == 4) {
            activity = this.operatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(duibaHdtool.getId(), 9, appId, null);
        } else if (duibaHdtool.getType() == 3) {
            activity = this.operatingActivityService.findByActivityIdAndTypeAndAppIdAndDeleted(duibaHdtool.getId(), 8, appId, null);
        }
        if (activity == null) {
            activity = new OperatingActivityDO(true);
        } else {
            activity = new OperatingActivityDO(activity.getId());
            activity.setDeleted(Boolean.valueOf(false));
        }
        if (duibaHdtool.getType() == 1) {
            activity.setType(Integer.valueOf(6));
        } else if (duibaHdtool.getType() == 2) {
            activity.setType(Integer.valueOf(7));
        } else if (duibaHdtool.getType() == 4) {
            activity.setType(Integer.valueOf(9));
        } else if (duibaHdtool.getType() == 3) {
            activity.setType(Integer.valueOf(8));
        }
        activity.setAppId(appId);
        activity.setActivityId(duibaHdtool.getId());
        activity.setTitle(duibaHdtool.getTitle());
        activity.setStatus(Integer.valueOf(1));
        if (duibaHdtool.getCreditsType() == 1) {
            activity.setCredits(Long.valueOf(duibaHdtool.getCreditsPrice()));
        } else {
            activity.setCredits(Long.valueOf(0L));
        }
        activity.setCreditsType(duibaHdtool.getCreditsType());
        activity.setSubType(duibaHdtool.getSubType());
        if (activity.getId() == null) {
            this.operatingActivityService.insert(activity);
            AppItemDO appItemDO = new AppItemDO(true);
            appItemDO.setDeleted(Boolean.valueOf(true));
            appItemDO.setAppId(appId);
            if (duibaHdtool.getCreditsType() == 1) {
                appItemDO.setCredits(Long.valueOf(duibaHdtool.getCreditsPrice()));
            } else {
                appItemDO.setCredits(Long.valueOf(0L));
            }
            appItemDO.setCustomPrice("duiba");
            appItemDO.setTitle(duibaHdtool.getTitle());
            appItemDO.setSubtitle(duibaHdtool.getTitle());
            appItemDO.setSubStatus(duibaHdtool.getTitle());
            appItemDO.setLogo(duibaHdtool.getLogo());
            appItemDO.setSmallImage(duibaHdtool.getSmallImage());
            appItemDO.setWhiteImage(duibaHdtool.getWhiteImage());
            appItemDO.setType("fake");
            appItemDO.setSourceType(Integer.valueOf(1));
            appItemDO.setSourceRelationId(activity.getId());
            this.appItemBo.saveAppItemByTurntableNoTranscation(appItemDO, activity.getId());
            AppBannerDO appBanner = new AppBannerDO(true);
            appBanner.setAppId(appId);
            appBanner.setDeleted(Boolean.valueOf(true));
            appBanner.setImage(duibaHdtool.getBannerImage());
            appBanner.setType("banner");
            appBanner.setSourceType(Integer.valueOf(1));
            appBanner.setSourceRelationId(activity.getId());
            this.appBannerBo.saveAppBannerByTurntableNoTranscation(appBanner, activity.getId());
        } else {
            activity.setGmtModified(new Date());
            this.operatingActivityService.update(activity);
        }
        return activity.getId();
    }

    private Boolean isDirect(Long appId, DuibaHdtoolDO duibaHdtool) {
        if (duibaHdtool.isOpenSwitch(0)) {
            HdtoolAppSpecifyDO tas = this.duibaHdtoolService.findSpecifyByHdToolIdAndApp(duibaHdtool.getId(), appId);
            if (tas == null) {
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    @Transactional(value="credits")
    public void update_duiba(DuibaHdtoolDO duibaHdtoolDO) {
        AppItemDO t;
        DuibaHdtoolDO oldHdToolDO = this.duibaHdtoolService.find(duibaHdtoolDO.getId());
        this.duibaHdtoolService.update(duibaHdtoolDO);
        ArrayList<Long> activityIds = new ArrayList<Long>();
        activityIds.add(oldHdToolDO.getId());
        List<Object> operatingActivityList = new ArrayList();
        if (oldHdToolDO.getType() == 1) {
            operatingActivityList = this.operatingActivityService.findAllByActivityIdsAndType(activityIds, 6);
        } else if (oldHdToolDO.getType() == 2) {
            operatingActivityList = this.operatingActivityService.findAllByActivityIdsAndType(activityIds, 7);
        } else if (oldHdToolDO.getType() == 4) {
            operatingActivityList = this.operatingActivityService.findAllByActivityIdsAndType(activityIds, 9);
        } else if (oldHdToolDO.getType() == 3) {
            operatingActivityList = this.operatingActivityService.findAllByActivityIdsAndType(activityIds, 8);
        }
        ArrayList<Long> appItemIds = new ArrayList<Long>();
        ArrayList<Long> appBannerIds = new ArrayList<Long>();
        if (operatingActivityList != null && operatingActivityList.size() > 0) {
            for (OperatingActivityDO operatingActivityDO : operatingActivityList) {
                if (operatingActivityDO.getAppItemId() != null) {
                    appItemIds.add(operatingActivityDO.getAppItemId());
                }
                if (operatingActivityDO.getAppBannerId() != null) {
                    appBannerIds.add(operatingActivityDO.getAppBannerId());
                }
                OperatingActivityDO t2 = new OperatingActivityDO(operatingActivityDO.getId());
                if (oldHdToolDO.getTitle().trim().equals(operatingActivityDO.getTitle().trim()) && !duibaHdtoolDO.getTitle().trim().equals(operatingActivityDO.getTitle().trim())) {
                    t2.setTitle(duibaHdtoolDO.getTitle());
                }
                if (duibaHdtoolDO.getCreditsType() == 1) {
                    t2.setCredits(Long.valueOf(duibaHdtoolDO.getCreditsPrice()));
                } else {
                    t2.setCredits(Long.valueOf(0L));
                }
                this.operatingActivityService.update(t2);
            }
        }
        List<Object> appItemList = new ArrayList();
        ArrayList arrayList = new ArrayList();
        if (appItemIds.size() > 0) {
            appItemList = this.appItemService.findAllByIds(appItemIds);
            for (AppItemDO appItemDO : appItemList) {
                t = new AppItemDO(appItemDO.getId());
                if (StringUtils.isNotBlank((String)oldHdToolDO.getTitle()) && oldHdToolDO.getTitle().trim().equals(appItemDO.getTitle().trim()) && !duibaHdtoolDO.getTitle().trim().equals(appItemDO.getTitle().trim())) {
                    t.setTitle(duibaHdtoolDO.getTitle());
                }
                if (StringUtils.isBlank((String)appItemDO.getSmallImage()) || Objects.equal((Object)appItemDO.getSmallImage(), (Object)oldHdToolDO.getSmallImage())) {
                    t.setSmallImage(duibaHdtoolDO.getSmallImage());
                }
                if (StringUtils.isBlank((String)appItemDO.getWhiteImage()) || Objects.equal((Object)appItemDO.getWhiteImage(), (Object)oldHdToolDO.getWhiteImage())) {
                    t.setWhiteImage(duibaHdtoolDO.getWhiteImage());
                }
                if (duibaHdtoolDO.getCreditsType() == 1) {
                    t.setCredits(Long.valueOf(duibaHdtoolDO.getCreditsPrice()));
                } else {
                    t.setCredits(Long.valueOf(0L));
                }
                t.setCustomPrice("duiba");
                this.appItemService.updateHdtoolAppItem(t.getId(), t.getTitle(), t.getSmallImage(), t.getWhiteImage(), t.getCredits(), t.getCustomPrice(), duibaHdtoolDO.getLogo());
            }
        }
        if (appBannerIds.size() > 0) {
            List list = this.appBannerService.findAllByIds(appBannerIds);
            for (AppBannerDO appBannerDO : list) {
                t = new AppBannerDO(appBannerDO.getId());
                if (StringUtils.isNotBlank((String)oldHdToolDO.getBannerImage()) && oldHdToolDO.getBannerImage().trim().equals(appBannerDO.getImage().trim()) && !duibaHdtoolDO.getBannerImage().trim().equals(appBannerDO.getImage().trim())) {
                    t.setImage(duibaHdtoolDO.getBannerImage());
                }
                if (StringUtils.isNotBlank((String)oldHdToolDO.getTitle()) && oldHdToolDO.getTitle().trim().equals(appBannerDO.getName().trim()) && !duibaHdtoolDO.getTitle().trim().equals(appBannerDO.getName().trim())) {
                    t.setName(duibaHdtoolDO.getTitle());
                }
                if (t.getImage() == null && t.getName() == null) continue;
                this.appBannerService.update((AppBannerDO)t);
            }
        }
    }

    @Override
    @Transactional(value="credits")
    public void startDuibaTurntable(Long hdToolsId) {
        DuibaHdtoolDO activity = this.duibaHdtoolService.find(hdToolsId);
        if (activity.getType() == 1) {
            this.operatingActivityService.updateStatusByActivityIdAndType(hdToolsId, 6, 1);
        } else if (activity.getType() == 2) {
            this.operatingActivityService.updateStatusByActivityIdAndType(hdToolsId, 7, 1);
        } else if (activity.getType() == 4) {
            this.operatingActivityService.updateStatusByActivityIdAndType(hdToolsId, 9, 1);
        } else if (activity.getType() == 3) {
            this.operatingActivityService.updateStatusByActivityIdAndType(hdToolsId, 8, 1);
        }
        this.duibaHdtoolService.updateStatus(hdToolsId, Integer.valueOf(1));
    }
}

