/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppBannerDO;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.DeveloperBlacklistDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.CreditsCalculateBo;
import cn.com.duiba.service.item.bo.DuibaSingleLotteryBo;
import cn.com.duiba.service.item.domain.dataobject.DuibaActivityDO;
import cn.com.duiba.service.item.domain.dataobject.DuibaSingleLotteryDO;
import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;
import cn.com.duiba.service.item.domain.dataobject.SingleLotteryAppSpecifyDO;
import cn.com.duiba.service.item.remoteservice.RemoteDuibaSingleLotteryService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.item.remoteservice.RemoteOperatingActivityService;
import cn.com.duiba.service.remoteservice.RemoteActPreStockService;
import cn.com.duiba.service.remoteservice.RemoteAppBannerService;
import cn.com.duiba.service.remoteservice.RemoteAppItemService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteDeveloperBlacklistService;
import cn.com.duiba.service.remoteservice.RemoteItemService;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DuibaSingleLotteryBoImpl
implements DuibaSingleLotteryBo {
    @Autowired
    private RemoteAppItemService remoteAppItemService;
    @Autowired
    private RemoteItemService remoteItemService;
    @Autowired
    private RemoteDeveloperBlacklistService remoteDeveloperBlacklistService;
    @Autowired
    private CreditsCalculateBo creditsCalculateBo;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemoteOperatingActivityService remoteOperatingActivityService;
    @Autowired
    private RemoteDuibaSingleLotteryService remoteDuibaSingleLotteryService;
    @Autowired
    private RemoteAppBannerService remoteAppBannerService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private RemoteActPreStockService remoteActPreStockService;

    @Override
    @Transactional(value="credits")
    public DuibaSingleLotteryDO closeAndUnViewSingleLottery(Long id) {
        this.remoteOperatingActivityService.updateStatusBySingleLotteryId(Integer.valueOf(3), id);
        this.remoteAppBannerService.disableByActivityId(Boolean.valueOf(true), id, Integer.valueOf(2));
        this.remoteAppItemService.updateStatusByActivityId("off", Boolean.valueOf(true), id, Integer.valueOf(2));
        DuibaSingleLotteryDO duibaSingleLottery4u = new DuibaSingleLotteryDO(id);
        duibaSingleLottery4u.setStatus(DuibaSingleLotteryDO.STATUS_UNPUBLISH);
        this.remoteDuibaSingleLotteryService.update(duibaSingleLottery4u);
        return duibaSingleLottery4u;
    }

    @Override
    public void addChildrenActivityToDeveloper(DuibaActivityDO duibaActivity, Long operatingActivityId, Long appId) {
        List itemIds = duibaActivity.getActivityItemIdList();
        if (itemIds == null || itemIds.size() == 0) {
            return;
        }
        List items = this.remoteItemService.findAllByIds(itemIds);
        if (items == null || items.size() == 0) {
            return;
        }
        ArrayList<Long> sourceRelationIds = new ArrayList<Long>();
        for (ItemDO t : items) {
            if (!"fake".equals(t.getType()) || 1 != t.getSourceType()) continue;
            sourceRelationIds.add(t.getSourceRelationId());
        }
        if (sourceRelationIds.size() == 0) {
            return;
        }
        List dslList = this.remoteDuibaSingleLotteryService.findAllByIds(sourceRelationIds);
        if (dslList == null || dslList.size() == 0) {
            return;
        }
        for (DuibaSingleLotteryDO t : dslList) {
            this.addChildActivityToDeveloper(t, operatingActivityId, appId);
        }
    }

    private void addChildActivityToDeveloper(DuibaSingleLotteryDO duibaSingleLottery, Long operatingActivityId, Long appId) {
        OperatingActivityDO oa = this.remoteOperatingActivityService.findByActivityIdAndParentIdAndTypeAndAppId(duibaSingleLottery.getId(), operatingActivityId, Integer.valueOf(2), appId);
        OperatingActivityDO parentOa = this.remoteOperatingActivityService.find(operatingActivityId);
        if (oa != null) {
            OperatingActivityDO o4u = new OperatingActivityDO(oa.getId());
            o4u.setDeleted(Boolean.FALSE);
            this.setInsertAndUpdateChildCommonProperties(duibaSingleLottery, appId, o4u);
            if (2 == parentOa.getStatus()) {
                o4u.setStatus(Integer.valueOf(2));
            } else {
                o4u.setStatus(Integer.valueOf(1));
            }
            this.remoteOperatingActivityService.update(o4u);
        } else {
            OperatingActivityDO o4i = new OperatingActivityDO(Boolean.TRUE.booleanValue());
            o4i.setAppId(appId);
            this.setInsertAndUpdateChildCommonProperties(duibaSingleLottery, appId, o4i);
            if (2 == parentOa.getStatus()) {
                o4i.setStatus(Integer.valueOf(2));
            } else {
                o4i.setStatus(Integer.valueOf(1));
            }
            o4i.setParentActivityId(operatingActivityId);
            this.remoteOperatingActivityService.insert(o4i);
        }
    }

    private void setInsertAndUpdateChildCommonProperties(DuibaSingleLotteryDO duibaSingleLottery, Long appId, OperatingActivityDO entity) {
        entity.setType(Integer.valueOf(2));
        entity.setTitle(duibaSingleLottery.getTitle());
        ItemKey itemKey = this.remoteItemKeyService.getItemKey(duibaSingleLottery.getMainItemId(), null, appId);
        Long credits = this.creditsCalculateBo.calculateCreditsByItemKeyAndDegree(itemKey, null);
        entity.setCredits(credits);
        entity.setRule(duibaSingleLottery.getIntroduction());
        entity.setActivityId(duibaSingleLottery.getId());
        entity.setImage(duibaSingleLottery.getImage());
    }

    @Override
    @Transactional(value="credits")
    public Long addSingleLotteryToDeveloper(Long appId, Long duibaSingleLotteryId, String isPreview) throws BusinessException {
        OperatingActivityDO activity;
        AppDO app = this.remoteAppService.find(appId);
        if (app == null) {
            throw new BusinessException("app not exist");
        }
        DuibaSingleLotteryDO duibaSingleLottery = this.remoteDuibaSingleLotteryService.find(duibaSingleLotteryId);
        if (duibaSingleLottery == null || duibaSingleLottery.getDeleted().booleanValue()) {
            throw new BusinessException("\u6d3b\u52a8\u5df2\u5220\u9664");
        }
        if (DuibaSingleLotteryDO.STATUS_STARTUP != duibaSingleLottery.getStatus()) {
            throw new BusinessException("\u6d3b\u52a8\u672a\u5f00\u542f");
        }
        DeveloperBlacklistDO devBlacklist = this.remoteDeveloperBlacklistService.findByDeveloperId(app.getDeveloperId());
        if (devBlacklist != null && duibaSingleLottery.isOpenSwitch(DuibaActivityDO.SWITCHES_DEV_BLACKLIST.intValue())) {
            throw new BusinessException("\u6d3b\u52a8\u9ed1\u540d\u5355");
        }
        if (!"preview".equals(isPreview)) {
            if (duibaSingleLottery.isOpTypeItem(DuibaSingleLotteryDO.OP_TYPE_ACTIVITY.intValue())) {
                throw new BusinessException("\u5355\u54c1\u62bd\u5956\u6d3b\u52a8\u4e0d\u53ef\u975e\u6cd5\u53c2\u4e0e");
            }
            if (!this.isDirect(appId, duibaSingleLottery).booleanValue()) {
                throw new BusinessException("\u672a\u5b9a\u5411\u6d3b\u52a8");
            }
        }
        if ((activity = this.remoteOperatingActivityService.findByAppIdAndDuibaSingleLotteryIdAndDeleted(appId, duibaSingleLotteryId, null)) == null) {
            activity = new OperatingActivityDO(true);
        } else {
            activity = new OperatingActivityDO(activity.getId());
            activity.setDeleted(Boolean.valueOf(false));
        }
        activity.setType(Integer.valueOf(2));
        activity.setAppId(appId);
        activity.setTitle(duibaSingleLottery.getTitle());
        activity.setStatus(Integer.valueOf(1));
        activity.setRule(duibaSingleLottery.getIntroduction());
        activity.setActivityId(duibaSingleLottery.getId());
        if (activity.getId() == null) {
            activity.setCredits(Long.valueOf(duibaSingleLottery.getCreditsPrice().intValue()));
            OperatingActivityDO temp = this.remoteOperatingActivityService.insert(activity);
            activity.setId(temp.getId());
            AppItemDO appItemDO = new AppItemDO(true);
            appItemDO.setDeleted(Boolean.valueOf(true));
            appItemDO.setAppId(appId);
            appItemDO.setCredits(Long.valueOf(duibaSingleLottery.getCreditsPrice().longValue()));
            appItemDO.setCustomPrice("duiba");
            appItemDO.setTitle(duibaSingleLottery.getTitle());
            appItemDO.setSubtitle(duibaSingleLottery.getSubtitle());
            appItemDO.setSubStatus(duibaSingleLottery.getTitle());
            appItemDO.setLogo(duibaSingleLottery.getLogo());
            appItemDO.setSmallImage(duibaSingleLottery.getSmallImage());
            appItemDO.setWhiteImage(duibaSingleLottery.getWhiteImage());
            appItemDO.setType("fake");
            appItemDO.setSourceType(Integer.valueOf(3));
            appItemDO.setSourceRelationId(activity.getId());
            this.remoteAppItemService.saveAppItemByTurntableNoTranscation(appItemDO, activity.getId().longValue());
            AppBannerDO appBanner = new AppBannerDO(true);
            appBanner.setAppId(appId);
            appBanner.setDeleted(Boolean.valueOf(true));
            appBanner.setImage(duibaSingleLottery.getBannerImage());
            appBanner.setType("banner");
            appBanner.setSourceType(Integer.valueOf(4));
            appBanner.setSourceRelationId(activity.getId());
            this.remoteAppBannerService.saveAppBannerByTurntableNoTranscation(appBanner, activity.getId().longValue());
        } else {
            this.remoteOperatingActivityService.update(activity);
        }
        return activity.getId();
    }

    private Boolean isDirect(Long appId, DuibaSingleLotteryDO duibaSingleLottery) {
        if (duibaSingleLottery.isOpenSwitch(DuibaSingleLotteryDO.SWITCHES_DIRECT.intValue())) {
            SingleLotteryAppSpecifyDO sla = this.remoteDuibaSingleLotteryService.findSpecifyByDuibaSingleLotteryAndApp(duibaSingleLottery.getId(), appId);
            if (sla == null) {
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    @Transactional(value="credits")
    public DuibaSingleLotteryDO closeDuibaSingleLotteryNoTransaction(Long id) {
        this.remoteOperatingActivityService.updateStatusBySingleLotteryId(Integer.valueOf(3), id);
        this.remoteAppBannerService.disableByActivityId(Boolean.valueOf(true), id, Integer.valueOf(2));
        this.remoteAppItemService.updateStatusByActivityId("off", Boolean.valueOf(true), id, Integer.valueOf(2));
        DuibaSingleLotteryDO duibaSingleLottery4u = new DuibaSingleLotteryDO(id);
        duibaSingleLottery4u.setStatus(DuibaSingleLotteryDO.STATUS_SHUTDOWN);
        this.remoteDuibaSingleLotteryService.update(duibaSingleLottery4u);
        return duibaSingleLottery4u;
    }

    @Override
    @Transactional(value="credits")
    public DuibaSingleLotteryDO deleteSingleLottery(Long id) {
        DuibaSingleLotteryDO duibaSingleLottery4u = this.closeDuibaSingleLotteryNoTransaction(id);
        ItemDO item = this.remoteItemService.findBySourceRelationIdAndSourceType(id, Integer.valueOf(1));
        if (item != null) {
            item = new ItemDO(item.getId());
            item.setDeleted(Boolean.TRUE);
            item.setEnable(Boolean.FALSE);
            this.remoteItemService.enableOrDisableById(item.getId(), item.getEnable(), item.getDeleted());
        }
        DuibaSingleLotteryDO duibaSingleLottery = new DuibaSingleLotteryDO(id);
        duibaSingleLottery.setDeleted(Boolean.valueOf(true));
        this.remoteDuibaSingleLotteryService.update(duibaSingleLottery);
        DuibaSingleLotteryDO duibaSingle = this.remoteDuibaSingleLotteryService.find(id);
        if (duibaSingle.isOpenSwitch(DuibaSingleLotteryDO.SWITCHES_NEW.intValue())) {
            this.remoteActPreStockService.deleteActStock(id, "singlelottery");
        }
        return duibaSingleLottery4u;
    }

    @Override
    @Transactional(value="credits")
    public void updateSingleLottery(DuibaSingleLotteryDO duibaSingleLottery) {
        if (!duibaSingleLottery.isOpTypeItem(DuibaSingleLotteryDO.OP_TYPE_ACTIVITY.intValue())) {
            List oaList = this.remoteOperatingActivityService.findAllBySingleLotteryId(duibaSingleLottery.getId());
            if (oaList != null && oaList.size() > 0) {
                ArrayList<Long> appIds = new ArrayList<Long>();
                for (OperatingActivityDO oa : oaList) {
                    appIds.add(oa.getAppId());
                }
                HashSet<Long> appIdSet = new HashSet<Long>();
                appIdSet.addAll(appIds);
                appIds.clear();
                appIds.addAll(appIdSet);
                HashMap<Long, AppDO> appMap = new HashMap<Long, AppDO>();
                List appList = this.remoteAppService.findByIds(appIds);
                for (AppDO a : appList) {
                    appMap.put(a.getId(), a);
                }
                AppItemDO ai = null;
                for (OperatingActivityDO oa : oaList) {
                    ai = new AppItemDO(oa.getAppItemId());
                    ai.setCredits(Long.valueOf(duibaSingleLottery.getCreditsPrice().longValue()));
                    ai.setCustomPrice("duiba");
                    this.remoteAppItemService.updateCreditsAndCustomPriceById(ai.getId(), ai.getCredits(), ai.getCustomPrice());
                }
            }
            this.pushUpdateToDeveloper(duibaSingleLottery);
        }
        this.remoteDuibaSingleLotteryService.updateForAdminEdit(duibaSingleLottery);
    }

    private void pushUpdateToDeveloper(DuibaSingleLotteryDO duibaSingleLottery) {
        AppItemDO t;
        DuibaSingleLotteryDO preDuibaSingleLottery = this.remoteDuibaSingleLotteryService.find(duibaSingleLottery.getId());
        List operatingActivityList = this.remoteOperatingActivityService.findAllBySingleLotteryId(preDuibaSingleLottery.getId());
        ArrayList<Long> appItemIds = new ArrayList<Long>();
        ArrayList<Long> appBannerIds = new ArrayList<Long>();
        if (operatingActivityList != null && operatingActivityList.size() > 0) {
            for (OperatingActivityDO o : operatingActivityList) {
                if (o.getAppItemId() != null) {
                    appItemIds.add(o.getAppItemId());
                }
                if (o.getAppBannerId() != null) {
                    appBannerIds.add(o.getAppBannerId());
                }
                OperatingActivityDO t2 = new OperatingActivityDO(o.getId());
                t2.setTitle(duibaSingleLottery.getTitle());
                t2.setCredits(Long.valueOf(duibaSingleLottery.getCreditsPrice().longValue()));
                this.remoteOperatingActivityService.update(t2);
            }
        }
        List appItemList = new ArrayList();
        List appBannerList = new ArrayList();
        if (appItemIds.size() > 0) {
            appItemList = this.remoteAppItemService.findAllByIds(appItemIds);
            for (AppItemDO a : appItemList) {
                t = new AppItemDO(a.getId());
                if (a.getTitle().equals(preDuibaSingleLottery.getTitle())) {
                    t.setTitle(duibaSingleLottery.getTitle());
                }
                if (StringUtils.isBlank((String)a.getLogo()) || Objects.equal((Object)preDuibaSingleLottery.getLogo(), (Object)a.getLogo())) {
                    t.setLogo(duibaSingleLottery.getLogo());
                }
                if (StringUtils.isBlank((String)a.getSmallImage()) || Objects.equal((Object)a.getSmallImage(), (Object)preDuibaSingleLottery.getSmallImage())) {
                    t.setSmallImage(duibaSingleLottery.getSmallImage());
                }
                if (StringUtils.isBlank((String)a.getWhiteImage()) || Objects.equal((Object)a.getWhiteImage(), (Object)preDuibaSingleLottery.getWhiteImage())) {
                    t.setWhiteImage(duibaSingleLottery.getWhiteImage());
                }
                t.setCredits(Long.valueOf(duibaSingleLottery.getCreditsPrice().longValue()));
                t.setCustomPrice("duiba");
                this.remoteAppItemService.updateTurntableAppItem(t.getId(), t.getTitle(), t.getSubtitle(), t.getLogo(), t.getSmallImage(), t.getWhiteImage(), t.getCredits(), t.getCustomPrice());
            }
        }
        if (appBannerIds.size() > 0) {
            appBannerList = this.remoteAppBannerService.findAllByIds(appBannerIds);
            for (AppItemDO a : appBannerList) {
                t = new AppBannerDO(a.getId());
                if (a.getImage().equals(preDuibaSingleLottery.getBannerImage())) {
                    t.setImage(duibaSingleLottery.getBannerImage());
                }
                this.remoteAppBannerService.update((AppBannerDO)t);
            }
        }
    }

    @Override
    @Transactional(value="credits")
    public void startupSingleLottery(Long id) {
        DuibaSingleLotteryDO duibaSingleLottery = this.remoteDuibaSingleLotteryService.find(id);
        if (duibaSingleLottery.isOpTypeItem(DuibaSingleLotteryDO.OP_TYPE_ACTIVITY.intValue())) {
            this.updateActivityStatusBySingleLotteryId(duibaSingleLottery.getId());
        } else {
            this.remoteOperatingActivityService.updateStatusBySingleLotteryId(Integer.valueOf(1), id);
        }
        duibaSingleLottery = new DuibaSingleLotteryDO(id);
        duibaSingleLottery.setStatus(DuibaSingleLotteryDO.STATUS_STARTUP);
        this.remoteDuibaSingleLotteryService.update(duibaSingleLottery);
    }

    private void updateActivityStatusBySingleLotteryId(Long duibaSingleLotteryId) {
        List oaList = this.remoteOperatingActivityService.findAllBySingleLotteryId(duibaSingleLotteryId);
        if (oaList == null || oaList.size() == 0) {
            return;
        }
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (OperatingActivityDO o : oaList) {
            parentIds.add(o.getParentActivityId());
        }
        if (parentIds.size() == 0) {
            return;
        }
        HashMap<Long, Integer> oaMap = new HashMap<Long, Integer>();
        List parentActivitys = this.remoteOperatingActivityService.findAllByIds(parentIds);
        if (parentActivitys == null || parentActivitys.size() == 0) {
            return;
        }
        for (OperatingActivityDO p : parentActivitys) {
            oaMap.put(p.getId(), p.getStatus());
        }
        for (OperatingActivityDO o : oaList) {
            OperatingActivityDO o4u = new OperatingActivityDO(o.getId());
            o4u.setStatus(Integer.valueOf(oaMap.get(o.getParentActivityId()) != null ? (Integer)oaMap.get(o.getParentActivityId()) : 1));
            this.remoteOperatingActivityService.update(o4u);
        }
    }
}

