/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppBannerDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.DuibaHdtoolDO;
import cn.com.duiba.service.domain.dataobject.DuibaHdtoolOptionsDO;
import cn.com.duiba.service.domain.dataobject.HdtoolStockManualChangeDO;
import cn.com.duiba.service.domain.dataobject.OperatingActivityOptionsDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.AppItemBo;
import cn.com.duiba.service.item.bo.HdToolsConfigBo;
import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.ItemKeyService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.service.OperatingActivityService;
import cn.com.duiba.service.service.ActPreStockService;
import cn.com.duiba.service.service.AppBannerService;
import cn.com.duiba.service.service.DuibaHdtoolOptionsService;
import cn.com.duiba.service.service.DuibaHdtoolService;
import cn.com.duiba.service.service.HdtoolStockManualChangeService;
import cn.com.duiba.service.service.OperatingActivityOptionsService;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HdToolsConfigBoImpl
implements HdToolsConfigBo {
    private static Logger log = LoggerFactory.getLogger(HdToolsConfigBoImpl.class);
    @Autowired
    private AppItemService appItemService;
    @Resource
    private AppItemBo appItemBo;
    @Autowired
    private ItemService itemService;
    @Autowired
    private OperatingActivityService operatingActivityService;
    @Autowired
    private ItemKeyService itemKeyService;
    @Autowired
    private DuibaHdtoolService duibaHdtoolService;
    @Autowired
    private AppBannerService appBannerService;
    @Autowired
    private DuibaHdtoolOptionsService duibaHdtoolOptionsService;
    @Autowired
    private ActPreStockService actPreStockService;
    @Autowired
    private OperatingActivityOptionsService operatingActivityOptionsService;
    @Autowired
    private HdtoolStockManualChangeService hdtoolStockManualChangeService;

    @Transactional(value="credits")
    private boolean addHdtoolStockQuantity(Long optionId, Integer quantity) throws BusinessException {
        Integer remaing = this.operatingActivityOptionsService.findRemaingForupdate(optionId);
        if (null == remaing) {
            throw new BusinessException("\u6d3b\u52a8\u5de5\u5177\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.operatingActivityOptionsService.addRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u53d8\u66f4\u6d3b\u52a8\u5de5\u5177\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        HdtoolStockManualChangeDO hdtoolStockChange = new HdtoolStockManualChangeDO(true);
        hdtoolStockChange.setRelationId(optionId);
        hdtoolStockChange.setRelationType("app");
        hdtoolStockChange.setBeforeStock(Long.valueOf(remaing.intValue()));
        hdtoolStockChange.setAfterStock(Long.valueOf(remaing + quantity));
        hdtoolStockChange.setChangeKind("add");
        hdtoolStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        this.hdtoolStockManualChangeService.insert(hdtoolStockChange);
        return true;
    }

    @Transactional(value="credits")
    private boolean reduceHdtoolStockQuantity(Long optionId, Integer quantity) throws BusinessException {
        Integer remaing = this.operatingActivityOptionsService.findRemaingForupdate(optionId);
        if (null == remaing) {
            throw new BusinessException("\u6d3b\u52a8\u5de5\u5177\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.operatingActivityOptionsService.subRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u53d8\u66f4\u6d3b\u52a8\u5de5\u5177\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        HdtoolStockManualChangeDO hdtoolStockChange = new HdtoolStockManualChangeDO(true);
        hdtoolStockChange.setRelationId(optionId);
        hdtoolStockChange.setRelationType("app");
        hdtoolStockChange.setBeforeStock(Long.valueOf(remaing.intValue()));
        hdtoolStockChange.setAfterStock(Long.valueOf(remaing - quantity));
        hdtoolStockChange.setChangeKind("sub");
        hdtoolStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        this.hdtoolStockManualChangeService.insert(hdtoolStockChange);
        return true;
    }

    private void updateRemainingByEdit(Long optionId, Integer preRemaining, Integer remaining) throws BusinessException {
        if (preRemaining == null && remaining == null) {
            return;
        }
        if (remaining == null) {
            throw new BusinessException("\u5956\u54c1\u6570\u91cf\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u7f16\u8f91\u9875\u9762\u91cd\u65b0\u7f16\u8f91");
        }
        if (preRemaining == null) {
            this.operatingActivityOptionsService.updateRemainingById(optionId, remaining);
            return;
        }
        int differ = remaining - preRemaining;
        if (differ == 0) {
            return;
        }
        if (differ > 0) {
            this.addHdtoolStockQuantity(optionId, Math.abs(differ));
        }
        if (differ < 0) {
            this.reduceHdtoolStockQuantity(optionId, Math.abs(differ));
        }
    }

    private void updateRemainingByEdit_duiba(Long optionId, Integer preRemaining, Integer remaining) throws BusinessException {
        if (preRemaining == null && remaining == null) {
            return;
        }
        if (remaining == null) {
            throw new BusinessException("\u5956\u54c1\u6570\u91cf\u4fee\u6539\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u7f16\u8f91\u9875\u9762\u91cd\u65b0\u7f16\u8f91");
        }
        if (preRemaining == null) {
            this.duibaHdtoolOptionsService.updateRemainingById(optionId, remaining);
            return;
        }
        int differ = remaining - preRemaining;
        if (differ == 0) {
            return;
        }
        if (differ > 0) {
            this.addHdtoolStockQuantity_duiba(optionId, Math.abs(differ));
        }
        if (differ < 0) {
            this.reduceHdtoolStockQuantity_duiba(optionId, Math.abs(differ));
        }
    }

    @Transactional(value="credits")
    private boolean addHdtoolStockQuantity_duiba(Long optionId, Integer quantity) throws BusinessException {
        Integer remaing = this.duibaHdtoolOptionsService.findRemaingForupdate(optionId);
        if (null == remaing) {
            throw new BusinessException("\u6d3b\u52a8\u5de5\u5177\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.duibaHdtoolOptionsService.addRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u6dfb\u52a0\u6d3b\u52a8\u5de5\u5177\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        HdtoolStockManualChangeDO hdtoolStockChange = new HdtoolStockManualChangeDO(true);
        hdtoolStockChange.setRelationId(optionId);
        hdtoolStockChange.setRelationType("duiba");
        hdtoolStockChange.setBeforeStock(Long.valueOf(remaing.intValue()));
        hdtoolStockChange.setAfterStock(Long.valueOf(remaing + quantity));
        hdtoolStockChange.setChangeKind("add");
        hdtoolStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        this.hdtoolStockManualChangeService.insert(hdtoolStockChange);
        return true;
    }

    @Transactional(value="credits")
    private boolean reduceHdtoolStockQuantity_duiba(Long optionId, Integer quantity) throws BusinessException {
        Integer remaing = this.duibaHdtoolOptionsService.findRemaingForupdate(optionId);
        if (null == remaing) {
            throw new BusinessException("\u6d3b\u52a8\u5de5\u5177\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.duibaHdtoolOptionsService.subRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u51cf\u5c11\u6d3b\u52a8\u5de5\u5177\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        HdtoolStockManualChangeDO hdtoolStockChange = new HdtoolStockManualChangeDO(true);
        hdtoolStockChange.setRelationId(optionId);
        hdtoolStockChange.setRelationType("duiba");
        hdtoolStockChange.setBeforeStock(Long.valueOf(remaing.intValue()));
        hdtoolStockChange.setAfterStock(Long.valueOf(remaing - quantity));
        hdtoolStockChange.setChangeKind("sub");
        hdtoolStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        this.hdtoolStockManualChangeService.insert(hdtoolStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public void saveOrUpdateHdToolOptions(Long activityId, Long appId, String[] awards) throws BusinessException {
        ArrayList<Long> awardIds = new ArrayList<Long>();
        for (int i = 0; i < awards.length; ++i) {
            JSONObject jsonOption = JSONObject.parseObject((String)awards[i]);
            Long id = jsonOption.getLong("id");
            if (null == id) continue;
            awardIds.add(id);
        }
        List oaoList = this.operatingActivityOptionsService.findByOperatingActivityId(activityId);
        if (!oaoList.isEmpty() && !awardIds.isEmpty() && awardIds.size() != oaoList.size()) {
            ArrayList<Long> oaoIds = new ArrayList<Long>();
            for (OperatingActivityOptionsDO oao : oaoList) {
                oaoIds.add(oao.getId());
            }
            for (int i = 0; i < awards.length; ++i) {
                JSONObject jsonOption = JSONObject.parseObject((String)awards[i]);
                Long id = jsonOption.getLong("id");
                if (null == id || !oaoIds.contains(id)) continue;
                oaoIds.remove(id);
            }
            if (!oaoIds.isEmpty()) {
                this.operatingActivityOptionsService.updateOptionDeleteStatus(oaoIds);
            }
        }
        for (int i = 0; i < awards.length; ++i) {
            JSONObject jsonOption = JSONObject.parseObject((String)awards[i]);
            String type = jsonOption.getString("type");
            this.checkAppHdtoolsOptionData(jsonOption.getString("img"), type, jsonOption.getLong("appItemId"), jsonOption.getString("probability"), jsonOption.getString("remaind"), jsonOption.getString("title"));
            if (!StringUtils.isNotBlank((String)type)) continue;
            int payload = i + 1;
            OperatingActivityOptionsDO option = new OperatingActivityOptionsDO(true);
            if (null != jsonOption.getLong("id")) {
                option = this.operatingActivityOptionsService.findOptionById(jsonOption.getLong("id"));
                option = new OperatingActivityOptionsDO(option.getId());
            }
            option.setOperatingActivityId(activityId);
            option.setName(jsonOption.getString("title"));
            option.setPayload(Integer.valueOf(payload));
            option.setLogo(jsonOption.getString("img"));
            option.setPrizeType(jsonOption.getString("type"));
            option.setHidden(Boolean.valueOf(jsonOption.getBoolean("show") == false));
            option.setDescription(jsonOption.getString("description"));
            if (type.equals("thanks") || type.equals("again")) {
                option.setAppItemId(null);
                option.setItemId(null);
                option.setFacePrice(null);
                option.setRemaining(null);
                option.setLimitCount(null);
                option.setMinComein(null);
                option.setRate(StringUtils.isBlank((String)jsonOption.getString("probability")) ? null : jsonOption.getString("probability"));
            } else {
                Long appItemId = jsonOption.getLong("appItemId");
                if (null == appItemId) {
                    appItemId = this.appItemBo.saveAppItemByActivity(appId, type, true).getId();
                }
                if (null == appItemId) {
                    throw new BusinessException("\u5956\u9879appItemId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ItemKey key = this.itemKeyService.getItemKey(null, appItemId, appId);
                if (key.isItemMode() && key.getItem().getLimitCount() != null && key.getItem().getLimitCount() > 0) {
                    throw new BusinessException("\u5956\u9879\u4e0d\u80fd\u5305\u542b\u5151\u5427\u9650\u5236\u5151\u6362\u5546\u54c1");
                }
                if (key.getAppItem() != null && !key.getAppItem().getAppId().equals(appId)) {
                    throw new BusinessException("APP\u4e0d\u80fd\u6dfb\u52a0\u6b64\u5956\u54c1");
                }
                option.setAppItemId(appItemId);
                if (null != key.getItem()) {
                    option.setItemId(key.getItem().getId());
                }
                if (jsonOption.getString("type").equals("virtual")) {
                    option.setFacePrice(jsonOption.getString("value") == null ? "0" : jsonOption.getString("value"));
                } else {
                    option.setFacePrice(jsonOption.getString("value") == null ? "0" : String.valueOf(Integer.valueOf(jsonOption.getString("value")) * 100));
                }
                option.setMinComein(Integer.valueOf(jsonOption.getInteger("low") == null ? 0 : jsonOption.getInteger("low")));
                option.setRemaining(Integer.valueOf(jsonOption.getInteger("remaind") == null ? 0 : jsonOption.getInteger("remaind")));
                option.setRate(StringUtils.isBlank((String)jsonOption.getString("probability")) ? null : jsonOption.getString("probability"));
                option.setLimitCount(Integer.valueOf(jsonOption.getInteger("limit") == null ? 0 : jsonOption.getInteger("limit")));
            }
            if (null == option.getId()) {
                this.operatingActivityOptionsService.insertOption(option);
                continue;
            }
            this.updateRemainingByEdit(option.getId(), jsonOption.getInteger("oldRemaind"), jsonOption.getInteger("remaind"));
            this.operatingActivityOptionsService.updatePrize(option);
        }
        this.updateTruntableDateState(activityId);
    }

    private void checkAppHdtoolsOptionData(String logo, String type, Long appItemId, String rate, String remaining, String name) throws BusinessException {
        if (StringUtils.isBlank((String)logo)) {
            throw new BusinessException("\u5956\u9879\u56fe\u6807\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new BusinessException("\u5956\u9879\u6587\u6848\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!type.equals(String.valueOf("thanks")) && (StringUtils.isBlank((String)rate) || Double.valueOf(rate) < 0.0 || Double.valueOf(rate) > 100.0)) {
            throw new BusinessException("\u4e2d\u5956\u6982\u7387\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e100");
        }
        if (!type.equals(String.valueOf("thanks")) && !type.equals(String.valueOf("again"))) {
            Integer remainingNum = 0;
            try {
                if (!"".equals(remaining) && remaining != null) {
                    remainingNum = Integer.parseInt(remaining);
                }
                if (remainingNum < 0) {
                    throw new BusinessException("\u5269\u4f59\u5956\u54c1\u6570\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
                }
            }
            catch (NumberFormatException e) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5956\u54c1\u6570\u8f6c\u6362\u51fa\u9519\u6216\u6570\u5b57\u957f\u5ea6\u5927\u4e8e99999999");
            }
        }
        if ((type.equals(String.valueOf("virtual")) || type.equals(String.valueOf("object")) || type.equals(String.valueOf("coupon"))) && appItemId == null) {
            throw new BusinessException("\u5956\u9879\u7684\u5956\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }

    public Integer updateTruntableDateState(Long activityId) {
        OperatingActivityDO activity = this.operatingActivityService.find(activityId);
        Integer state = null;
        Integer num = this.operatingActivityOptionsService.countByOperatingActivityId(activityId);
        if (num < 2 || num > 8) {
            state = 0;
        } else {
            AppBannerDO appBanner;
            AppItemDO appItem;
            boolean flg = false;
            if (null != activity.getAppItemId() && !(appItem = this.appItemService.find(activity.getAppItemId())).getDeleted().booleanValue()) {
                flg = true;
            }
            if (activity.getAppBannerId() != null && !(appBanner = this.appBannerService.find(activity.getAppBannerId())).getDeleted().booleanValue()) {
                flg = true;
            }
            state = flg ? Integer.valueOf(2) : Integer.valueOf(1);
        }
        activity.setStatus(state);
        OperatingActivityDO activity4u = new OperatingActivityDO(activity.getId());
        activity4u.setStatus(activity.getStatus());
        return this.operatingActivityService.update(activity4u);
    }

    @Override
    @Transactional(value="credits")
    public void saveOrUpdateDuibaHdToolOptions(Long hdToolsId, List<String> awards) throws BusinessException {
        DuibaHdtoolDO hdtool = this.duibaHdtoolService.find(hdToolsId);
        ArrayList<Long> awardIds = new ArrayList<Long>();
        for (int i = 0; i < awards.size(); ++i) {
            JSONObject jsonOption = JSONObject.parseObject((String)awards.get(i));
            Long id = jsonOption.getLong("id");
            if (null == id) continue;
            awardIds.add(id);
        }
        List oaoList = this.duibaHdtoolService.findOptionsByDuibaHdtoolId(hdToolsId);
        if (!oaoList.isEmpty() && !awardIds.isEmpty() && awardIds.size() != oaoList.size()) {
            ArrayList<Long> oaoIds = new ArrayList<Long>();
            for (DuibaHdtoolOptionsDO oao : oaoList) {
                oaoIds.add(oao.getId());
            }
            for (int i = 0; i < awards.size(); ++i) {
                JSONObject jsonOption = JSONObject.parseObject((String)awards.get(i));
                Long id = jsonOption.getLong("id");
                if (null == id || !oaoIds.contains(id)) continue;
                oaoIds.remove(id);
            }
            if (!oaoIds.isEmpty()) {
                this.duibaHdtoolService.deleteOptions(oaoIds);
                if (null != hdtool && hdtool.isOpenSwitch(3)) {
                    for (Long id : oaoIds) {
                        this.actPreStockService.deleteActPrizeStock(hdToolsId, id, "hdtool");
                    }
                }
            }
        }
        for (int i = 0; i < awards.size(); ++i) {
            JSONObject jsonOption = JSONObject.parseObject((String)awards.get(i));
            String type = jsonOption.getString("type");
            this.checkDuibaHdtoolOptionData(jsonOption.getString("img"), type, jsonOption.getLong("appItemId"), jsonOption.getString("probability"), jsonOption.getString("remaind"), jsonOption.getString("title"));
            if (!StringUtils.isNotBlank((String)type)) continue;
            int payload = i + 1;
            DuibaHdtoolOptionsDO option = new DuibaHdtoolOptionsDO(true);
            if (null != jsonOption.getLong("id")) {
                option = this.duibaHdtoolService.findOptionById(jsonOption.getLong("id"));
                option = new DuibaHdtoolOptionsDO(option.getId());
            }
            option.setDuibaHdtoolId(hdToolsId);
            option.setName(jsonOption.getString("title"));
            option.setPayload(Integer.valueOf(payload));
            option.setLogo(jsonOption.getString("img"));
            option.setPrizeType(jsonOption.getString("type"));
            option.setHidden(Boolean.valueOf(jsonOption.getBoolean("show") == false));
            if (StringUtils.isNotBlank((String)jsonOption.getString("description"))) {
                option.setDescription(jsonOption.getString("description").replaceAll("\r", "<br/>").replaceAll("\r[*]\n", "<br/>").trim());
            }
            Long itemId = jsonOption.getLong("appItemId");
            if (type.equals("thanks") || type.equals("again")) {
                option.setAppItemId(null);
                option.setItemId(null);
                option.setFacePrice(null);
                option.setRemaining(null);
                option.setLimitCount(null);
                option.setMinComein(null);
                option.setRate(StringUtils.isBlank((String)jsonOption.getString("probability")) ? null : jsonOption.getString("probability"));
            } else {
                if (null == itemId) {
                    throw new BusinessException("\u5956\u9879\u4e0d\u53ef\u7528");
                }
                option.setAppItemId(null);
                option.setItemId(itemId);
                option.setFacePrice(jsonOption.getString("value") == null ? "0" : String.valueOf(Integer.valueOf(jsonOption.getString("value")) * 100));
                option.setMinComein(Integer.valueOf(jsonOption.getInteger("low") == null ? 0 : jsonOption.getInteger("low")));
                option.setRemaining(Integer.valueOf(jsonOption.getInteger("remaind") == null ? 0 : jsonOption.getInteger("remaind")));
                option.setRate(StringUtils.isBlank((String)jsonOption.getString("probability")) ? null : jsonOption.getString("probability"));
                option.setLimitCount(Integer.valueOf(jsonOption.getInteger("limit") == null ? 0 : jsonOption.getInteger("limit")));
            }
            if (null == option.getId()) {
                this.duibaHdtoolService.insertHdtoolOption(option);
                if (null == hdtool || !hdtool.isOpenSwitch(3) || type.equals("thanks") || type.equals("again")) continue;
                this.actPreStockService.addShareActPreStock(hdToolsId, option.getId(), Long.valueOf(Long.parseLong(option.getRemaining().toString())), this.itemService.find(option.getItemId()).getName(), "hdtool");
                continue;
            }
            this.updateRemainingByEdit_duiba(option.getId(), jsonOption.getInteger("oldRemaind"), jsonOption.getInteger("remaind"));
            this.duibaHdtoolService.updateHdtoolPrize(option);
            if (null == hdtool || !hdtool.isOpenSwitch(3) || type.equals("thanks") || type.equals("again")) continue;
            this.actPreStockService.refreshActPreStock(hdToolsId, "hdtool", Long.valueOf(0L), null, this.itemService.find(option.getItemId()).getName());
        }
        Integer num = this.duibaHdtoolService.countOptionsByHdtoolId(hdToolsId);
        if (num >= 2 && num <= 8) {
            DuibaHdtoolDO duibaHdToolsDO = this.duibaHdtoolService.find(hdToolsId);
            if (duibaHdToolsDO.getStatus() == 0) {
                this.duibaHdtoolService.updateStatus(hdToolsId, Integer.valueOf(3));
            }
        } else {
            this.duibaHdtoolService.updateStatus(hdToolsId, Integer.valueOf(0));
        }
    }

    private void checkDuibaHdtoolOptionData(String logo, String type, Long itemId, String rate, String remaining, String name) throws BusinessException {
        if (StringUtils.isBlank((String)logo)) {
            throw new BusinessException("\u5956\u9879\u56fe\u6807\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)name)) {
            throw new BusinessException("\u5956\u9879\u6587\u6848\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (!type.equals(String.valueOf("thanks")) && (StringUtils.isBlank((String)rate) || Double.valueOf(rate) < 0.0 || Double.valueOf(rate) > 100.0)) {
            throw new BusinessException("\u4e2d\u5956\u6982\u7387\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e100");
        }
        if (!type.equals(String.valueOf("thanks")) && !type.equals(String.valueOf("again"))) {
            if (itemId == null) {
                throw new BusinessException("\u5956\u9879\u7684\u5956\u54c1\u4e0d\u53ef\u4e3a\u7a7a");
            }
            Integer remainingNum = 0;
            try {
                if (!"".equals(remaining) && remaining != null) {
                    remainingNum = Integer.parseInt(remaining);
                }
                if (remainingNum < 0) {
                    throw new BusinessException("\u5269\u4f59\u5956\u54c1\u6570\u4e0d\u53ef\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
                }
            }
            catch (NumberFormatException e) {
                throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u5956\u54c1\u6570\u8f6c\u6362\u51fa\u9519\u6216\u6570\u5b57\u957f\u5ea6\u5927\u4e8e99999999");
            }
        }
    }
}

