/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.ItemStockConsumeBo;
import cn.com.duiba.service.item.domain.dataobject.ItemAppSpecifyDO;
import cn.com.duiba.service.item.domain.dataobject.ItemStockConsumeDO;
import cn.com.duiba.service.item.domain.dataobject.ItemStockSpecifyConsumeDO;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.ItemAppSpecifyService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.service.ItemStockConsumeService;
import cn.com.duiba.service.item.service.ItemStockSpecifyConsumeService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemStockConsumeBoImpl
implements ItemStockConsumeBo {
    private static Logger log = LoggerFactory.getLogger(ItemStockConsumeBoImpl.class);
    @Autowired
    private ItemAppSpecifyService itemAppSpecifyService;
    @Autowired
    private ItemStockSpecifyConsumeService itemStockSpecifyConsumeService;
    @Resource
    private ItemStockConsumeService itemStockConsumeService;
    @Resource
    private AppItemService appItemService;
    @Resource
    private ItemService itemService;

    @Override
    @Transactional(value="credits")
    public void consumeRedirectStock(ItemKey key, String bizId, String bizSource) throws BusinessException {
        if (!key.getItemType().equals("object") && !key.getItemType().equals("coupon")) {
            throw new BusinessException("\u4e0d\u652f\u6301\u6b64\u7c7b\u578b:" + key.getItemType());
        }
        ItemAppSpecifyDO specify = this.itemAppSpecifyService.findByItemIdAndAppIdLock(key.getItem().getId(), key.getApp().getId());
        if (null == specify) {
            throw new BusinessException("\u65e0\u5b9a\u5411\u5e93\u5b58");
        }
        if (specify.getRemaining() <= 0) {
            throw new BusinessException("\u5546\u54c1\u5b9a\u5411\u5e93\u5b58\u4e0d\u8db3,itemId=" + key.getItem().getId());
        }
        int row = this.itemAppSpecifyService.reduceRemaining(key.getItem().getId(), key.getApp().getId());
        if (row < 1) {
            throw new BusinessException("\u51cf\u5b9a\u5411\u5e93\u5b58\u5931\u8d25");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        ItemStockSpecifyConsumeDO consume = new ItemStockSpecifyConsumeDO(true);
        consume.setBizId(bizId);
        consume.setBizSource(bizSource);
        consume.setRelationId(key.getItem().getId());
        consume.setRelationType("item");
        consume.setAppId(key.getApp().getId());
        consume.setAction("pay");
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.itemStockSpecifyConsumeService.insert(consume);
    }

    @Override
    @Transactional(value="credits")
    public void paybackRedirectStock(String bizId, String bizSource) throws BusinessException {
        ItemStockSpecifyConsumeDO consume = this.itemStockSpecifyConsumeService.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        ItemAppSpecifyDO specify = this.itemAppSpecifyService.findByItemIdAndAppIdLock(consume.getRelationId(), consume.getAppId());
        if (null == specify) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        int row = this.itemAppSpecifyService.increaseRemaining(specify.getItemId(), specify.getAppId());
        if (row < 1) {
            throw new BusinessException("\u8fd4\u5b9a\u5411\u5e93\u5b58\u5931\u8d25");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        ItemStockSpecifyConsumeDO detail = new ItemStockSpecifyConsumeDO(true);
        detail.setBizId(bizId);
        detail.setBizSource(bizSource);
        detail.setRelationId(consume.getRelationId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(consume.getAppId());
        detail.setAction("back");
        detail.setQuantity(consume.getQuantity());
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.itemStockSpecifyConsumeService.insert(detail);
    }

    @Override
    public boolean specifyItemCheck(ItemKey itemKey) {
        ItemAppSpecifyDO itemAppSpecifyDO;
        return itemKey.getItem() == null || !itemKey.getItem().isOpTypeItem(3) || null != (itemAppSpecifyDO = this.itemAppSpecifyService.findByItemIdAndAppId(itemKey.getItem().getId(), itemKey.getApp().getId()));
    }

    @Override
    public boolean specifyItemRemaingCheck(ItemKey itemKey) {
        ItemAppSpecifyDO itemAppSpecifyDO;
        return itemKey.getItem() == null || !itemKey.getItem().isOpTypeItem(3) || null == (itemAppSpecifyDO = this.itemAppSpecifyService.findByItemIdAndAppId(itemKey.getItem().getId(), itemKey.getApp().getId())) || itemAppSpecifyDO.getRemaining() > 0;
    }

    @Override
    @Transactional(value="credits")
    public void consumeStock(ItemKey itemKey, String bizId, String bizSource) throws BusinessException {
        int row;
        if (!itemKey.getItemType().equals("object") && !itemKey.getItemType().equals("virtual")) {
            throw new BusinessException("\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\uff1a" + itemKey.getItemType());
        }
        Long relationId = null;
        String relationType = null;
        if (itemKey.isSelfAppItemMode()) {
            AppItemDO appitem = this.appItemService.findForUpdate(itemKey.getAppItem().getId());
            if (null == appitem) {
                throw new BusinessException("\u65e0\u6b64\u5546\u54c1");
            }
            if (appitem.getRemaining() <= 0) {
                throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,appItemId=" + itemKey.getAppItem().getId());
            }
            if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                Integer limit = appitem.getLimitEverydayQuantity();
                int sales = this.itemStockConsumeService.countAppConsumeStockLock(appitem.getId(), "appItem", itemKey.getApp().getId(), DateUtils.getDayDate((Date)new Date()));
                if (null != limit && sales >= limit) {
                    throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,appItemId=" + itemKey.getAppItem().getId());
                }
            }
            if ((row = this.appItemService.reduceRemaining(appitem.getId())) < 1) {
                throw new BusinessException("\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25");
            }
            relationId = appitem.getId();
            relationType = "appItem";
        } else if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
            Integer limit;
            ItemDO itemDO = this.itemService.findForUpdate(itemKey.getItem().getId());
            if (null == itemDO) {
                throw new BusinessException("\u65e0\u6b64\u5546\u54c1");
            }
            if (itemDO.getRemaining() <= 0) {
                throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,itemId=" + itemKey.getItem().getId());
            }
            if (itemKey.isItemMode()) {
                if (itemDO.isOpTypeItem(1)) {
                    limit = itemDO.getLimitEverydayQuantity();
                    int sales = this.itemStockConsumeService.countConsumeStockLock(itemDO.getId(), "item", DateUtils.getDayDate((Date)new Date()));
                    if (null != limit && sales >= limit) {
                        throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,itemId=" + itemKey.getItem().getId());
                    }
                }
            } else if (itemKey.isDuibaAppItemMode()) {
                if (itemKey.getAppItem().isOpTypeAppItem(1)) {
                    limit = itemKey.getAppItem().getLimitEverydayQuantity();
                    int sales = this.itemStockConsumeService.countAppConsumeStockLock(itemDO.getId(), "item", itemKey.getApp().getId(), DateUtils.getDayDate((Date)new Date()));
                    if (null != limit && sales >= limit) {
                        throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,itemId=" + itemKey.getItem().getId());
                    }
                } else if (itemKey.getItem().isOpTypeItem(1)) {
                    limit = itemDO.getLimitEverydayQuantity();
                    int sales = this.itemStockConsumeService.countConsumeStockLock(itemDO.getId(), "item", DateUtils.getDayDate((Date)new Date()));
                    if (null != limit && sales >= limit) {
                        throw new BusinessException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3,itemId=" + itemKey.getItem().getId());
                    }
                }
            }
            if ((row = this.itemService.reduceRemaining(itemKey.getItem().getId())) < 1) {
                throw new BusinessException("\u51cf\u5546\u54c1\u5e93\u5b58\u5931\u8d25");
            }
            relationId = itemDO.getId();
            relationType = "item";
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        ItemStockConsumeDO consume = new ItemStockConsumeDO(true);
        consume.setBizId(bizId);
        consume.setBizSource(bizSource);
        consume.setRelationId(relationId);
        consume.setRelationType(relationType);
        consume.setAppId(itemKey.getApp().getId());
        consume.setAction("pay");
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.itemStockConsumeService.insert(consume);
    }

    @Override
    public void paybackStock(String bizId, String bizSource) throws BusinessException {
        ItemDO itemDO;
        AppItemDO appitem;
        int row;
        ItemStockConsumeDO consume = this.itemStockConsumeService.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            return;
        }
        if (consume.getRelationType().equals("appItem") ? (row = this.appItemService.increaseRemaining((appitem = this.appItemService.findForUpdate(consume.getRelationId())).getId())) < 1 : consume.getRelationType().equals("item") && (row = this.itemService.increaseRemaining((itemDO = this.itemService.findForUpdate(consume.getRelationId())).getId())) < 1) {
            throw new BusinessException("\u8fd4\u5e93\u5b58\u5931\u8d25");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        ItemStockConsumeDO detail = new ItemStockConsumeDO(true);
        detail.setBizId(consume.getBizId());
        detail.setBizSource(consume.getBizSource());
        detail.setRelationId(consume.getRelationId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(consume.getAppId());
        detail.setAction("back");
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.itemStockConsumeService.insert(detail);
    }
}

