/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.dataobject.PreStockConsumeDetailDO;
import cn.com.duiba.service.domain.dataobject.PreStockDO;
import cn.com.duiba.service.domain.dataobject.PreStockPointDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.bo.PreStockBo;
import cn.com.duiba.service.remoteservice.RemotePreStockConsumeDetailService;
import cn.com.duiba.service.remoteservice.RemotePreStockPointService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PreStockBoImpl
implements PreStockBo {
    private static final Logger log = LoggerFactory.getLogger(PreStockBoImpl.class);
    @Autowired
    private RemotePreStockService remotePreStockService;
    @Autowired
    private RemotePreStockConsumeDetailService remotePreStockConsumeDetailService;
    @Autowired
    private RemotePreStockPointService remotePreStockPointService;
    @Autowired
    private CacheClient cacheClient;

    @Override
    @Transactional(value="credits")
    public void consumeStock(String bizId, Long appId, Long pointId) throws BusinessException, StatusException {
        Integer sales;
        PreStockDO stock = this.remotePreStockService.findByPointId(pointId);
        if (null == stock) {
            throw new BusinessException("\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        if (stock.getStock() < 1L) {
            throw new BusinessException("\u9884\u5206\u914d\u5e93\u5b58\u4e0d\u8db3\uff0cstockId=" + stock.getId());
        }
        Long preStockId = stock.getId();
        PreStockConsumeDetailDO detail = null;
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        this.remotePreStockService.lock4update(preStockId);
        PreStockPointDO pointStock = this.remotePreStockPointService.find(pointId);
        if (null != pointStock && pointStock.getLimitEverydayQuantity() != null && (sales = this.remotePreStockConsumeDetailService.countSalesTimeByLock(pointId, DateUtils.getDayDate((Date)new Date()))) >= pointStock.getLimitEverydayQuantity()) {
            throw new StatusException(5);
        }
        boolean success = this.remotePreStockService.reduceQuantity(stock.getId(), 1L);
        if (!success) {
            throw new BusinessException("\u51cf\u5e93\u5b58\u5931\u8d25");
        }
        detail = new PreStockConsumeDetailDO(true);
        detail.setBizId(bizId);
        detail.setAction("pay");
        detail.setPointId(pointId);
        detail.setStockId(preStockId);
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        detail.setAppId(appId);
        this.remotePreStockConsumeDetailService.insert(detail);
        try {
            this.deletePreStockCounter(pointId);
        }
        catch (Exception e) {
            log.error("className: " + this.getClass().getName() + " method: deletePreStockCounter error", (Throwable)e);
        }
    }

    @Override
    @Transactional(value="credits")
    public void paybackStock(String bizId) throws BusinessException {
        PreStockConsumeDetailDO consume = this.remotePreStockConsumeDetailService.findByBizIdAndPayAction(bizId);
        if (null == consume) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        this.remotePreStockService.lock4update(consume.getStockId());
        boolean success = this.remotePreStockService.addQuantity(consume.getStockId(), 1L);
        if (!success) {
            throw new BusinessException("\u8fd4\u5e93\u5b58\u51fa\u9519");
        }
        PreStockConsumeDetailDO detail = new PreStockConsumeDetailDO(true);
        detail.setBizId(bizId);
        detail.setAction("back");
        detail.setPointId(consume.getPointId());
        detail.setStockId(consume.getStockId());
        detail.setQuantity(consume.getQuantity());
        detail.setAppId(consume.getAppId());
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.remotePreStockConsumeDetailService.insert(detail);
        try {
            this.deletePreStockCounter(consume.getPointId());
        }
        catch (Exception e) {
            log.error("className: " + this.getClass().getName() + " method: deletePreStockCounter error", (Throwable)e);
        }
    }

    @Override
    public Integer getMinExchangePrice(ItemDO item, AppDO app) {
        PreStockPointDO point = this.getPointStock(item, app);
        if (null != point && null != point.getMinFacePrice()) {
            return point.getMinFacePrice();
        }
        return null;
    }

    @Override
    public Long getPreStock(ItemDO item, AppDO app) {
        PreStockDO stock;
        PreStockPointDO point = this.getPointStock(item, app);
        if (null != point && null != (stock = this.remotePreStockService.findByPointId(point.getId()))) {
            return stock.getStock();
        }
        return null;
    }

    @Override
    public Integer getPreStockQuantitySales(ItemKey itemKey) {
        PreStockPointDO point = this.getPointStock(itemKey.getItem(), itemKey.getApp());
        if (null == point || null == point.getLimitEverydayQuantity()) {
            return null;
        }
        try {
            String key = this.getKey(point.getId());
            Integer salesCount = (Integer)this.cacheClient.get(key);
            if (null == salesCount) {
                Integer countNum = this.remotePreStockConsumeDetailService.countSalesTime(point.getId(), DateUtils.getDayDate((Date)new Date()));
                int exp = Math.min(DateUtils.getToTomorrowSeconds(), 3600);
                this.cacheClient.set(key, (Object)exp, countNum.intValue());
                salesCount = countNum;
            }
            Integer limit = point.getLimitEverydayQuantity();
            Integer remaining = 0;
            if (salesCount < limit) {
                remaining = limit - salesCount;
            }
            return remaining;
        }
        catch (Exception e) {
            log.error("className: " + this.getClass().getName() + " method: getPreStockQuantitySales \u83b7\u53d6\u9650\u91cf\u5269\u4f59\u5e93\u5b58\u5f02\u5e38", (Throwable)e);
            return 0;
        }
    }

    private Boolean deletePreStockCounter(Long pointId) {
        PreStockPointDO pointStock = this.remotePreStockPointService.find(pointId);
        if (null == pointStock || null == pointStock.getLimitEverydayQuantity()) {
            return null;
        }
        String key = this.getKey(pointId);
        this.cacheClient.remove(key);
        return true;
    }

    @Override
    public boolean chargeMode(String chargeMode) {
        if ("hdtool".equals(chargeMode)) {
            return false;
        }
        if ("singlelottery".equals(chargeMode)) {
            return false;
        }
        if ("turntable".equals(chargeMode)) {
            return false;
        }
        if ("manuallottery".equals(chargeMode)) {
            return false;
        }
        if ("game".equals(chargeMode)) {
            return false;
        }
        return !"seckill".equals(chargeMode);
    }

    @Override
    public PreStockPointDO getPointStock(ItemDO item, AppDO app) {
        if (null != item && item.isOpTypeItem(10)) {
            PreStockPointDO point = this.remotePreStockPointService.findAppIdAndItemId(app.getId(), item.getId());
            if (null != point) {
                return point;
            }
            PreStockPointDO pointShare = this.remotePreStockPointService.findItemIdAndNullApp(item.getId());
            if (null != pointShare) {
                return pointShare;
            }
        }
        return null;
    }

    private String getKey(Long pointId) {
        return "121-" + pointId;
    }
}

